/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.rules.initialize_and_validate_claim;

import gov.cms.fiss.pricers.common.api.OutpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimData;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimPricingRequest;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimPricingResponse;
import gov.cms.fiss.pricers.opps.core.OppsPricerContext;
import gov.cms.fiss.pricers.opps.core.tables.OutMigrationAdjustmentEntry;
import org.apache.commons.lang3.StringUtils;

public class WageIndexOutmigrationAdjustment
implements CalculationRule<OppsClaimPricingRequest, OppsClaimPricingResponse, OppsPricerContext> {
    @Override
    public void calculate(OppsPricerContext calculationContext) {
        OppsClaimData input = (OppsClaimData)((OppsClaimPricingRequest)calculationContext.getInput()).getClaimData();
        OutpatientProviderData providerData = calculationContext.getProviderData();
        if (OppsPricerContext.isZeroValue(providerData.getCbsaWageIndexLocation()) && OppsPricerContext.isZeroValue(providerData.getPaymentCbsa()) && StringUtils.isEmpty(StringUtils.trimToEmpty(providerData.getSpecialPaymentIndicator()))) {
            OutMigrationAdjustmentEntry outMigrationAdjustmentEntry = calculationContext.getDataTables().getOutMigrationAdjustment(Integer.parseInt(providerData.getCountyCode()), input.getServiceFromDate());
            if (outMigrationAdjustmentEntry == null) {
                return;
            }
            calculationContext.setWageIndex(calculationContext.getWageIndex().add(outMigrationAdjustmentEntry.getAdjustmentFactor()));
        }
    }
}

