/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics.jetty11;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.RatioGauge;
import com.codahale.metrics.Timer;
import com.codahale.metrics.annotation.ResponseMeteredLevel;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.server.AsyncContextState;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;

public class InstrumentedHandler
extends HandlerWrapper {
    private static final String NAME_REQUESTS = "requests";
    private static final String NAME_DISPATCHES = "dispatches";
    private static final String NAME_ACTIVE_REQUESTS = "active-requests";
    private static final String NAME_ACTIVE_DISPATCHES = "active-dispatches";
    private static final String NAME_ACTIVE_SUSPENDED = "active-suspended";
    private static final String NAME_ASYNC_DISPATCHES = "async-dispatches";
    private static final String NAME_ASYNC_TIMEOUTS = "async-timeouts";
    private static final String NAME_1XX_RESPONSES = "1xx-responses";
    private static final String NAME_2XX_RESPONSES = "2xx-responses";
    private static final String NAME_3XX_RESPONSES = "3xx-responses";
    private static final String NAME_4XX_RESPONSES = "4xx-responses";
    private static final String NAME_5XX_RESPONSES = "5xx-responses";
    private static final String NAME_GET_REQUESTS = "get-requests";
    private static final String NAME_POST_REQUESTS = "post-requests";
    private static final String NAME_HEAD_REQUESTS = "head-requests";
    private static final String NAME_PUT_REQUESTS = "put-requests";
    private static final String NAME_DELETE_REQUESTS = "delete-requests";
    private static final String NAME_OPTIONS_REQUESTS = "options-requests";
    private static final String NAME_TRACE_REQUESTS = "trace-requests";
    private static final String NAME_CONNECT_REQUESTS = "connect-requests";
    private static final String NAME_MOVE_REQUESTS = "move-requests";
    private static final String NAME_OTHER_REQUESTS = "other-requests";
    private static final String NAME_PERCENT_4XX_1M = "percent-4xx-1m";
    private static final String NAME_PERCENT_4XX_5M = "percent-4xx-5m";
    private static final String NAME_PERCENT_4XX_15M = "percent-4xx-15m";
    private static final String NAME_PERCENT_5XX_1M = "percent-5xx-1m";
    private static final String NAME_PERCENT_5XX_5M = "percent-5xx-5m";
    private static final String NAME_PERCENT_5XX_15M = "percent-5xx-15m";
    private static final Set<ResponseMeteredLevel> COARSE_METER_LEVELS = EnumSet.of(ResponseMeteredLevel.COARSE, ResponseMeteredLevel.ALL);
    private static final Set<ResponseMeteredLevel> DETAILED_METER_LEVELS = EnumSet.of(ResponseMeteredLevel.DETAILED, ResponseMeteredLevel.ALL);
    private final MetricRegistry metricRegistry;
    private String name;
    private final String prefix;
    private Timer requests;
    private Timer dispatches;
    private Counter activeRequests;
    private Counter activeDispatches;
    private Counter activeSuspended;
    private Meter asyncDispatches;
    private Meter asyncTimeouts;
    private final ResponseMeteredLevel responseMeteredLevel;
    private List<Meter> responses;
    private Map<Integer, Meter> responseCodeMeters;
    private Timer getRequests;
    private Timer postRequests;
    private Timer headRequests;
    private Timer putRequests;
    private Timer deleteRequests;
    private Timer optionsRequests;
    private Timer traceRequests;
    private Timer connectRequests;
    private Timer moveRequests;
    private Timer otherRequests;
    private AsyncListener listener;

    public InstrumentedHandler(MetricRegistry registry) {
        this(registry, null);
    }

    public InstrumentedHandler(MetricRegistry registry, String prefix) {
        this(registry, prefix, ResponseMeteredLevel.COARSE);
    }

    public InstrumentedHandler(MetricRegistry registry, String prefix, ResponseMeteredLevel responseMeteredLevel) {
        this.responseMeteredLevel = responseMeteredLevel;
        this.metricRegistry = registry;
        this.prefix = prefix;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        String prefix = this.getMetricPrefix();
        this.requests = this.metricRegistry.timer(MetricRegistry.name(prefix, NAME_REQUESTS));
        this.dispatches = this.metricRegistry.timer(MetricRegistry.name(prefix, NAME_DISPATCHES));
        this.activeRequests = this.metricRegistry.counter(MetricRegistry.name(prefix, NAME_ACTIVE_REQUESTS));
        this.activeDispatches = this.metricRegistry.counter(MetricRegistry.name(prefix, NAME_ACTIVE_DISPATCHES));
        this.activeSuspended = this.metricRegistry.counter(MetricRegistry.name(prefix, NAME_ACTIVE_SUSPENDED));
        this.asyncDispatches = this.metricRegistry.meter(MetricRegistry.name(prefix, NAME_ASYNC_DISPATCHES));
        this.asyncTimeouts = this.metricRegistry.meter(MetricRegistry.name(prefix, NAME_ASYNC_TIMEOUTS));
        this.responseCodeMeters = DETAILED_METER_LEVELS.contains((Object)this.responseMeteredLevel) ? new ConcurrentHashMap() : Collections.emptyMap();
        this.getRequests = this.metricRegistry.timer(MetricRegistry.name(prefix, NAME_GET_REQUESTS));
        this.postRequests = this.metricRegistry.timer(MetricRegistry.name(prefix, NAME_POST_REQUESTS));
        this.headRequests = this.metricRegistry.timer(MetricRegistry.name(prefix, NAME_HEAD_REQUESTS));
        this.putRequests = this.metricRegistry.timer(MetricRegistry.name(prefix, NAME_PUT_REQUESTS));
        this.deleteRequests = this.metricRegistry.timer(MetricRegistry.name(prefix, NAME_DELETE_REQUESTS));
        this.optionsRequests = this.metricRegistry.timer(MetricRegistry.name(prefix, NAME_OPTIONS_REQUESTS));
        this.traceRequests = this.metricRegistry.timer(MetricRegistry.name(prefix, NAME_TRACE_REQUESTS));
        this.connectRequests = this.metricRegistry.timer(MetricRegistry.name(prefix, NAME_CONNECT_REQUESTS));
        this.moveRequests = this.metricRegistry.timer(MetricRegistry.name(prefix, NAME_MOVE_REQUESTS));
        this.otherRequests = this.metricRegistry.timer(MetricRegistry.name(prefix, NAME_OTHER_REQUESTS));
        if (COARSE_METER_LEVELS.contains((Object)this.responseMeteredLevel)) {
            this.responses = Collections.unmodifiableList(Arrays.asList(this.metricRegistry.meter(MetricRegistry.name(prefix, NAME_1XX_RESPONSES)), this.metricRegistry.meter(MetricRegistry.name(prefix, NAME_2XX_RESPONSES)), this.metricRegistry.meter(MetricRegistry.name(prefix, NAME_3XX_RESPONSES)), this.metricRegistry.meter(MetricRegistry.name(prefix, NAME_4XX_RESPONSES)), this.metricRegistry.meter(MetricRegistry.name(prefix, NAME_5XX_RESPONSES))));
            this.metricRegistry.register(MetricRegistry.name(prefix, NAME_PERCENT_4XX_1M), new RatioGauge(){

                @Override
                protected RatioGauge.Ratio getRatio() {
                    return RatioGauge.Ratio.of(((Meter)InstrumentedHandler.this.responses.get(3)).getOneMinuteRate(), InstrumentedHandler.this.requests.getOneMinuteRate());
                }
            });
            this.metricRegistry.register(MetricRegistry.name(prefix, NAME_PERCENT_4XX_5M), new RatioGauge(){

                @Override
                protected RatioGauge.Ratio getRatio() {
                    return RatioGauge.Ratio.of(((Meter)InstrumentedHandler.this.responses.get(3)).getFiveMinuteRate(), InstrumentedHandler.this.requests.getFiveMinuteRate());
                }
            });
            this.metricRegistry.register(MetricRegistry.name(prefix, NAME_PERCENT_4XX_15M), new RatioGauge(){

                @Override
                protected RatioGauge.Ratio getRatio() {
                    return RatioGauge.Ratio.of(((Meter)InstrumentedHandler.this.responses.get(3)).getFifteenMinuteRate(), InstrumentedHandler.this.requests.getFifteenMinuteRate());
                }
            });
            this.metricRegistry.register(MetricRegistry.name(prefix, NAME_PERCENT_5XX_1M), new RatioGauge(){

                @Override
                protected RatioGauge.Ratio getRatio() {
                    return RatioGauge.Ratio.of(((Meter)InstrumentedHandler.this.responses.get(4)).getOneMinuteRate(), InstrumentedHandler.this.requests.getOneMinuteRate());
                }
            });
            this.metricRegistry.register(MetricRegistry.name(prefix, NAME_PERCENT_5XX_5M), new RatioGauge(){

                @Override
                protected RatioGauge.Ratio getRatio() {
                    return RatioGauge.Ratio.of(((Meter)InstrumentedHandler.this.responses.get(4)).getFiveMinuteRate(), InstrumentedHandler.this.requests.getFiveMinuteRate());
                }
            });
            this.metricRegistry.register(MetricRegistry.name(prefix, NAME_PERCENT_5XX_15M), new RatioGauge(){

                @Override
                public RatioGauge.Ratio getRatio() {
                    return RatioGauge.Ratio.of(((Meter)InstrumentedHandler.this.responses.get(4)).getFifteenMinuteRate(), InstrumentedHandler.this.requests.getFifteenMinuteRate());
                }
            });
        } else {
            this.responses = Collections.emptyList();
        }
        this.listener = new AsyncAttachingListener();
    }

    @Override
    protected void doStop() throws Exception {
        String prefix = this.getMetricPrefix();
        this.metricRegistry.remove(MetricRegistry.name(prefix, NAME_REQUESTS));
        this.metricRegistry.remove(MetricRegistry.name(prefix, NAME_DISPATCHES));
        this.metricRegistry.remove(MetricRegistry.name(prefix, NAME_ACTIVE_REQUESTS));
        this.metricRegistry.remove(MetricRegistry.name(prefix, NAME_ACTIVE_DISPATCHES));
        this.metricRegistry.remove(MetricRegistry.name(prefix, NAME_ACTIVE_SUSPENDED));
        this.metricRegistry.remove(MetricRegistry.name(prefix, NAME_ASYNC_DISPATCHES));
        this.metricRegistry.remove(MetricRegistry.name(prefix, NAME_ASYNC_TIMEOUTS));
        this.metricRegistry.remove(MetricRegistry.name(prefix, NAME_1XX_RESPONSES));
        this.metricRegistry.remove(MetricRegistry.name(prefix, NAME_2XX_RESPONSES));
        this.metricRegistry.remove(MetricRegistry.name(prefix, NAME_3XX_RESPONSES));
        this.metricRegistry.remove(MetricRegistry.name(prefix, NAME_4XX_RESPONSES));
        this.metricRegistry.remove(MetricRegistry.name(prefix, NAME_5XX_RESPONSES));
        this.metricRegistry.remove(MetricRegistry.name(prefix, NAME_GET_REQUESTS));
        this.metricRegistry.remove(MetricRegistry.name(prefix, NAME_POST_REQUESTS));
        this.metricRegistry.remove(MetricRegistry.name(prefix, NAME_HEAD_REQUESTS));
        this.metricRegistry.remove(MetricRegistry.name(prefix, NAME_PUT_REQUESTS));
        this.metricRegistry.remove(MetricRegistry.name(prefix, NAME_DELETE_REQUESTS));
        this.metricRegistry.remove(MetricRegistry.name(prefix, NAME_OPTIONS_REQUESTS));
        this.metricRegistry.remove(MetricRegistry.name(prefix, NAME_TRACE_REQUESTS));
        this.metricRegistry.remove(MetricRegistry.name(prefix, NAME_CONNECT_REQUESTS));
        this.metricRegistry.remove(MetricRegistry.name(prefix, NAME_MOVE_REQUESTS));
        this.metricRegistry.remove(MetricRegistry.name(prefix, NAME_OTHER_REQUESTS));
        this.metricRegistry.remove(MetricRegistry.name(prefix, NAME_PERCENT_4XX_1M));
        this.metricRegistry.remove(MetricRegistry.name(prefix, NAME_PERCENT_4XX_5M));
        this.metricRegistry.remove(MetricRegistry.name(prefix, NAME_PERCENT_4XX_15M));
        this.metricRegistry.remove(MetricRegistry.name(prefix, NAME_PERCENT_5XX_1M));
        this.metricRegistry.remove(MetricRegistry.name(prefix, NAME_PERCENT_5XX_5M));
        this.metricRegistry.remove(MetricRegistry.name(prefix, NAME_PERCENT_5XX_15M));
        if (this.responseCodeMeters != null) {
            this.responseCodeMeters.keySet().stream().map(sc -> MetricRegistry.name(this.getMetricPrefix(), String.format("%d-responses", sc))).forEach(this.metricRegistry::remove);
        }
        super.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(String path, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
        long start;
        this.activeDispatches.inc();
        HttpChannelState state = request.getHttpChannelState();
        if (state.isInitial()) {
            this.activeRequests.inc();
            start = request.getTimeStamp();
            state.addListener(this.listener);
        } else {
            start = System.currentTimeMillis();
            this.activeSuspended.dec();
            if (state.getState() == HttpChannelState.State.HANDLING) {
                this.asyncDispatches.mark();
            }
        }
        try {
            super.handle(path, request, httpRequest, httpResponse);
        }
        finally {
            long now = System.currentTimeMillis();
            long dispatched = now - start;
            this.activeDispatches.dec();
            this.dispatches.update(dispatched, TimeUnit.MILLISECONDS);
            if (state.isSuspended()) {
                this.activeSuspended.inc();
            } else if (state.isInitial()) {
                this.updateResponses(httpRequest, httpResponse, start, request.isHandled());
            }
        }
    }

    private Timer requestTimer(String method) {
        HttpMethod m4 = HttpMethod.fromString(method);
        if (m4 == null) {
            return this.otherRequests;
        }
        switch (m4) {
            case GET: {
                return this.getRequests;
            }
            case POST: {
                return this.postRequests;
            }
            case PUT: {
                return this.putRequests;
            }
            case HEAD: {
                return this.headRequests;
            }
            case DELETE: {
                return this.deleteRequests;
            }
            case OPTIONS: {
                return this.optionsRequests;
            }
            case TRACE: {
                return this.traceRequests;
            }
            case CONNECT: {
                return this.connectRequests;
            }
            case MOVE: {
                return this.moveRequests;
            }
        }
        return this.otherRequests;
    }

    private void updateResponses(HttpServletRequest request, HttpServletResponse response, long start, boolean isHandled) {
        if (isHandled) {
            this.mark(response.getStatus());
        } else {
            this.mark(404);
        }
        this.activeRequests.dec();
        long elapsedTime = System.currentTimeMillis() - start;
        this.requests.update(elapsedTime, TimeUnit.MILLISECONDS);
        this.requestTimer(request.getMethod()).update(elapsedTime, TimeUnit.MILLISECONDS);
    }

    private void mark(int statusCode) {
        int responseStatus;
        if (DETAILED_METER_LEVELS.contains((Object)this.responseMeteredLevel)) {
            this.getResponseCodeMeter(statusCode).mark();
        }
        if (COARSE_METER_LEVELS.contains((Object)this.responseMeteredLevel) && (responseStatus = statusCode / 100) >= 1 && responseStatus <= 5) {
            this.responses.get(responseStatus - 1).mark();
        }
    }

    private Meter getResponseCodeMeter(int statusCode) {
        return this.responseCodeMeters.computeIfAbsent(statusCode, sc -> this.metricRegistry.meter(MetricRegistry.name(this.getMetricPrefix(), String.format("%d-responses", sc))));
    }

    private String getMetricPrefix() {
        return this.prefix == null ? MetricRegistry.name(this.getHandler().getClass(), this.name) : MetricRegistry.name(this.prefix, this.name);
    }

    private class AsyncAttachingListener
    implements AsyncListener {
        private AsyncAttachingListener() {
        }

        @Override
        public void onTimeout(AsyncEvent event) throws IOException {
        }

        @Override
        public void onStartAsync(AsyncEvent event) throws IOException {
            event.getAsyncContext().addListener(new InstrumentedAsyncListener());
        }

        @Override
        public void onError(AsyncEvent event) throws IOException {
        }

        @Override
        public void onComplete(AsyncEvent event) throws IOException {
        }
    }

    private class InstrumentedAsyncListener
    implements AsyncListener {
        private final long startTime = System.currentTimeMillis();

        InstrumentedAsyncListener() {
        }

        @Override
        public void onTimeout(AsyncEvent event) throws IOException {
            InstrumentedHandler.this.asyncTimeouts.mark();
        }

        @Override
        public void onStartAsync(AsyncEvent event) throws IOException {
        }

        @Override
        public void onError(AsyncEvent event) throws IOException {
        }

        @Override
        public void onComplete(AsyncEvent event) throws IOException {
            AsyncContextState state = (AsyncContextState)event.getAsyncContext();
            HttpServletRequest request = (HttpServletRequest)state.getRequest();
            HttpServletResponse response = (HttpServletResponse)state.getResponse();
            InstrumentedHandler.this.updateResponses(request, response, this.startTime, true);
            if (!state.getHttpChannelState().isSuspended()) {
                InstrumentedHandler.this.activeSuspended.dec();
            }
        }
    }
}

