// Generated by delombok at Thu Nov 13 21:35:57 UTC 2025
package gov.cms.fiss.pricers.opps.core.model;

import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.opps.api.v2.IoceServiceLineData;
import gov.cms.fiss.pricers.opps.api.v2.ServiceLinePaymentData;
import java.math.BigDecimal;

/**
 * Container for service line calculations.
 *
 * <p>(LINE-HOLD-ITEMS)
 */
public class LineCalculation {
  private static final BigDecimal ZERO = BigDecimalUtils.ZERO;
  private BigDecimal bloodFraction = ZERO; // H-BLOOD-FRACTION
  private BigDecimal reimbursement = ZERO; // H-LITEM-REIM
  private BigDecimal totalDeductible = ZERO; // H-TOTAL-LN-DEDUCT
  private BigDecimal nationalCoinsurance = ZERO; // H-NAT-COIN
  private BigDecimal minimumCoinsurance = ZERO; // H-MIN-COIN
  private BigDecimal reducedCoinsurance = ZERO; // H-RED-COIN
  private BigDecimal payment = ZERO; // H-LITEM-PYMT
  private BigDecimal bloodDeductible = ZERO; // H-LN-BLOOD-DEDUCT
  private BigDecimal deviceCreditAmount = ZERO; // H-LINE-DEVCR-AMT
  private IoceServiceLineData lineInput;
  private ServiceLinePaymentData lineOutput;
  private DeductibleLine deductibleLine;

  public LineCalculation(LineCalculation copyOf) {
    this.bloodFraction = copyOf.getBloodFraction();
    this.reimbursement = copyOf.getReimbursement();
    this.totalDeductible = copyOf.getTotalDeductible();
    this.nationalCoinsurance = copyOf.getNationalCoinsurance();
    this.minimumCoinsurance = copyOf.getMinimumCoinsurance();
    this.reducedCoinsurance = copyOf.getReducedCoinsurance();
    this.payment = copyOf.getPayment();
    this.bloodDeductible = copyOf.getBloodDeductible();
    this.deviceCreditAmount = copyOf.getDeviceCreditAmount();
    this.lineInput = copyOf.getLineInput();
    this.lineOutput = copyOf.getLineOutput();
    this.deductibleLine = new DeductibleLine(copyOf.getDeductibleLine());
  }

  public LineCalculation(IoceServiceLineData lineInput, ServiceLinePaymentData lineOutput, DeductibleLine deductibleLine) {
    this.lineInput = lineInput;
    this.lineOutput = lineOutput;
    this.deductibleLine = deductibleLine;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBloodFraction() {
    return this.bloodFraction;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getReimbursement() {
    return this.reimbursement;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getTotalDeductible() {
    return this.totalDeductible;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getNationalCoinsurance() {
    return this.nationalCoinsurance;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getMinimumCoinsurance() {
    return this.minimumCoinsurance;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getReducedCoinsurance() {
    return this.reducedCoinsurance;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getPayment() {
    return this.payment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBloodDeductible() {
    return this.bloodDeductible;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getDeviceCreditAmount() {
    return this.deviceCreditAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public IoceServiceLineData getLineInput() {
    return this.lineInput;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ServiceLinePaymentData getLineOutput() {
    return this.lineOutput;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public DeductibleLine getDeductibleLine() {
    return this.deductibleLine;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBloodFraction(final BigDecimal bloodFraction) {
    this.bloodFraction = bloodFraction;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReimbursement(final BigDecimal reimbursement) {
    this.reimbursement = reimbursement;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTotalDeductible(final BigDecimal totalDeductible) {
    this.totalDeductible = totalDeductible;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNationalCoinsurance(final BigDecimal nationalCoinsurance) {
    this.nationalCoinsurance = nationalCoinsurance;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMinimumCoinsurance(final BigDecimal minimumCoinsurance) {
    this.minimumCoinsurance = minimumCoinsurance;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReducedCoinsurance(final BigDecimal reducedCoinsurance) {
    this.reducedCoinsurance = reducedCoinsurance;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPayment(final BigDecimal payment) {
    this.payment = payment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBloodDeductible(final BigDecimal bloodDeductible) {
    this.bloodDeductible = bloodDeductible;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDeviceCreditAmount(final BigDecimal deviceCreditAmount) {
    this.deviceCreditAmount = deviceCreditAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLineInput(final IoceServiceLineData lineInput) {
    this.lineInput = lineInput;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLineOutput(final ServiceLinePaymentData lineOutput) {
    this.lineOutput = lineOutput;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDeductibleLine(final DeductibleLine deductibleLine) {
    this.deductibleLine = deductibleLine;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "LineCalculation(bloodFraction=" + this.getBloodFraction() + ", reimbursement=" + this.getReimbursement() + ", totalDeductible=" + this.getTotalDeductible() + ", nationalCoinsurance=" + this.getNationalCoinsurance() + ", minimumCoinsurance=" + this.getMinimumCoinsurance() + ", reducedCoinsurance=" + this.getReducedCoinsurance() + ", payment=" + this.getPayment() + ", bloodDeductible=" + this.getBloodDeductible() + ", deviceCreditAmount=" + this.getDeviceCreditAmount() + ", lineInput=" + this.getLineInput() + ", lineOutput=" + this.getLineOutput() + ", deductibleLine=" + this.getDeductibleLine() + ")";
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof LineCalculation)) return false;
    final LineCalculation other = (LineCalculation) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$bloodFraction = this.getBloodFraction();
    final java.lang.Object other$bloodFraction = other.getBloodFraction();
    if (this$bloodFraction == null ? other$bloodFraction != null : !this$bloodFraction.equals(other$bloodFraction)) return false;
    final java.lang.Object this$reimbursement = this.getReimbursement();
    final java.lang.Object other$reimbursement = other.getReimbursement();
    if (this$reimbursement == null ? other$reimbursement != null : !this$reimbursement.equals(other$reimbursement)) return false;
    final java.lang.Object this$totalDeductible = this.getTotalDeductible();
    final java.lang.Object other$totalDeductible = other.getTotalDeductible();
    if (this$totalDeductible == null ? other$totalDeductible != null : !this$totalDeductible.equals(other$totalDeductible)) return false;
    final java.lang.Object this$nationalCoinsurance = this.getNationalCoinsurance();
    final java.lang.Object other$nationalCoinsurance = other.getNationalCoinsurance();
    if (this$nationalCoinsurance == null ? other$nationalCoinsurance != null : !this$nationalCoinsurance.equals(other$nationalCoinsurance)) return false;
    final java.lang.Object this$minimumCoinsurance = this.getMinimumCoinsurance();
    final java.lang.Object other$minimumCoinsurance = other.getMinimumCoinsurance();
    if (this$minimumCoinsurance == null ? other$minimumCoinsurance != null : !this$minimumCoinsurance.equals(other$minimumCoinsurance)) return false;
    final java.lang.Object this$reducedCoinsurance = this.getReducedCoinsurance();
    final java.lang.Object other$reducedCoinsurance = other.getReducedCoinsurance();
    if (this$reducedCoinsurance == null ? other$reducedCoinsurance != null : !this$reducedCoinsurance.equals(other$reducedCoinsurance)) return false;
    final java.lang.Object this$payment = this.getPayment();
    final java.lang.Object other$payment = other.getPayment();
    if (this$payment == null ? other$payment != null : !this$payment.equals(other$payment)) return false;
    final java.lang.Object this$bloodDeductible = this.getBloodDeductible();
    final java.lang.Object other$bloodDeductible = other.getBloodDeductible();
    if (this$bloodDeductible == null ? other$bloodDeductible != null : !this$bloodDeductible.equals(other$bloodDeductible)) return false;
    final java.lang.Object this$deviceCreditAmount = this.getDeviceCreditAmount();
    final java.lang.Object other$deviceCreditAmount = other.getDeviceCreditAmount();
    if (this$deviceCreditAmount == null ? other$deviceCreditAmount != null : !this$deviceCreditAmount.equals(other$deviceCreditAmount)) return false;
    final java.lang.Object this$lineInput = this.getLineInput();
    final java.lang.Object other$lineInput = other.getLineInput();
    if (this$lineInput == null ? other$lineInput != null : !this$lineInput.equals(other$lineInput)) return false;
    final java.lang.Object this$lineOutput = this.getLineOutput();
    final java.lang.Object other$lineOutput = other.getLineOutput();
    if (this$lineOutput == null ? other$lineOutput != null : !this$lineOutput.equals(other$lineOutput)) return false;
    final java.lang.Object this$deductibleLine = this.getDeductibleLine();
    final java.lang.Object other$deductibleLine = other.getDeductibleLine();
    if (this$deductibleLine == null ? other$deductibleLine != null : !this$deductibleLine.equals(other$deductibleLine)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof LineCalculation;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $bloodFraction = this.getBloodFraction();
    result = result * PRIME + ($bloodFraction == null ? 43 : $bloodFraction.hashCode());
    final java.lang.Object $reimbursement = this.getReimbursement();
    result = result * PRIME + ($reimbursement == null ? 43 : $reimbursement.hashCode());
    final java.lang.Object $totalDeductible = this.getTotalDeductible();
    result = result * PRIME + ($totalDeductible == null ? 43 : $totalDeductible.hashCode());
    final java.lang.Object $nationalCoinsurance = this.getNationalCoinsurance();
    result = result * PRIME + ($nationalCoinsurance == null ? 43 : $nationalCoinsurance.hashCode());
    final java.lang.Object $minimumCoinsurance = this.getMinimumCoinsurance();
    result = result * PRIME + ($minimumCoinsurance == null ? 43 : $minimumCoinsurance.hashCode());
    final java.lang.Object $reducedCoinsurance = this.getReducedCoinsurance();
    result = result * PRIME + ($reducedCoinsurance == null ? 43 : $reducedCoinsurance.hashCode());
    final java.lang.Object $payment = this.getPayment();
    result = result * PRIME + ($payment == null ? 43 : $payment.hashCode());
    final java.lang.Object $bloodDeductible = this.getBloodDeductible();
    result = result * PRIME + ($bloodDeductible == null ? 43 : $bloodDeductible.hashCode());
    final java.lang.Object $deviceCreditAmount = this.getDeviceCreditAmount();
    result = result * PRIME + ($deviceCreditAmount == null ? 43 : $deviceCreditAmount.hashCode());
    final java.lang.Object $lineInput = this.getLineInput();
    result = result * PRIME + ($lineInput == null ? 43 : $lineInput.hashCode());
    final java.lang.Object $lineOutput = this.getLineOutput();
    result = result * PRIME + ($lineOutput == null ? 43 : $lineOutput.hashCode());
    final java.lang.Object $deductibleLine = this.getDeductibleLine();
    result = result * PRIME + ($deductibleLine == null ? 43 : $deductibleLine.hashCode());
    return result;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LineCalculation() {
  }
}
