// Generated by delombok at Thu Nov 13 21:35:57 UTC 2025
package gov.cms.fiss.pricers.opps.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.opps.OppsPricerConfiguration;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Map;
import java.util.Map.Entry;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentHashMap;

/**
 * This class is responsible for holding all the CopyBook data tables for the pricer as well as
 * helper methods to access the data.
 */
public class DataTables {
  private static final Map<Integer, DataTables> YEAR_LOOKUP = new ConcurrentHashMap<>();
  /**
   * W-APC-RATE-TABLE lookup table.
   */
  private final Map<String, NavigableMap<LocalDate, ApcRateHistoryEntry>> apcRateHistory;
  /**
   * W-WNXC-WNXC-TABLE lookup table.
   */
  private final Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> cbsaTable;
  /**
   * OUTM-TAB lookup table.
   */
  private final Map<Integer, NavigableMap<LocalDate, OutMigrationAdjustmentEntry>> outMigrationAdjustmentMap;
  /**
   * PREV-TAB lookup table.
   */
  private final Map<String, PreviousYearWageIndexEntry> previousYearWageIndexMap;
  /**
   * W-2020-BLOOD-APC-TABLE lookup table.
   */
  private final Map<String, BloodRankEntry> bloodRankMap;

  public DataTables(Map<String, NavigableMap<LocalDate, ApcRateHistoryEntry>> apcRateHistory, Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> cbsaTable, Map<String, BloodRankEntry> bloodRankMap, Map<Integer, NavigableMap<LocalDate, OutMigrationAdjustmentEntry>> outMigrationAdjustmentMap, Map<String, PreviousYearWageIndexEntry> previousYearWageIndexMap) {
    this.apcRateHistory = apcRateHistory;
    this.cbsaTable = cbsaTable;
    this.bloodRankMap = bloodRankMap;
    this.outMigrationAdjustmentMap = outMigrationAdjustmentMap;
    this.previousYearWageIndexMap = previousYearWageIndexMap;
  }

  public static DataTables forYear(int pricerYear) {
    return YEAR_LOOKUP.get(pricerYear);
  }

  /**
   * Loads data tables with the given CSV ingestion configuration.
   */
  public static void loadDataTables(OppsPricerConfiguration pricerConfiguration) {
    final CsvIngestionConfiguration csvIngestionConfiguration = pricerConfiguration.getCsvIngestionConfiguration();
    final ApcRateHistoryLookupGenerator apcRateHistoryLookupGenerator = new ApcRateHistoryLookupGenerator(csvIngestionConfiguration);
    final CbsaWageIndexLookupGenerator cbsaWageIndexLookupGenerator = new CbsaWageIndexLookupGenerator(csvIngestionConfiguration);
    final BloodRankLookupGenerator bloodRankLookupGenerator = new BloodRankLookupGenerator(csvIngestionConfiguration);
    final OutMigrationAdjustmentLookupGenerator outMigrationAdjustmentLookupGenerator = new OutMigrationAdjustmentLookupGenerator(csvIngestionConfiguration);
    final Map<String, PreviousYearWageIndexEntry> previousYearWageIndexMap;
    // Use override value if present else default
    if (pricerConfiguration.getPreviousYearWageIndexOverride() != null) {
      previousYearWageIndexMap = new PreviousYearWageIndexLookupGenerator(csvIngestionConfiguration).generate(pricerConfiguration.getPreviousYearWageIndexOverride());
    } else {
      previousYearWageIndexMap = new PreviousYearWageIndexLookupGenerator(csvIngestionConfiguration).generate();
    }
    // Load all the tables
    for (final int pricerYear : pricerConfiguration.getSupportedYears()) {
      YEAR_LOOKUP.put(pricerYear, new DataTables(apcRateHistoryLookupGenerator.generate(pricerYear), cbsaWageIndexLookupGenerator.generate(pricerYear), bloodRankLookupGenerator.generate(pricerYear), outMigrationAdjustmentLookupGenerator.generate(pricerYear), previousYearWageIndexMap));
    }
  }

  /**
   * Returns the APC rates table for iteration.
   *
   * @return All the APC rate entries
   */
  public Map<String, NavigableMap<LocalDate, ApcRateHistoryEntry>> getApcRateHistoryTable() {
    return apcRateHistory;
  }

  /**
   * Returns the APC rates for the given payment APC.
   *
   * @param paymentApc APC to be used
   * @return APC rate entries if found otherwise null
   */
  public NavigableMap<LocalDate, ApcRateHistoryEntry> getApcRateHistoryEntry(String paymentApc) {
    // LOOK-UP LINE APC IN APC TABLE FOR ALL LINES THAT - PASS VALIDATION RULES
    return apcRateHistory.get(paymentApc);
  }

  /**
   * Wage index lookup based on CBSA.
   *
   * @param cbsa CBSA to be looked up
   * @return CBSA wage index entries if found otherwise null
   */
  public NavigableMap<LocalDate, CbsaWageIndexEntry> getCbsaWageIndexEntries(String cbsa) {
    return cbsaTable.get(cbsa);
  }

  /**
   * Returns blood ranking for the given HCPCS code.
   */
  public Integer getBloodRank(String hcpcsCode) {
    final BloodRankEntry entry = bloodRankMap.get(hcpcsCode);
    return entry == null ? null : entry.getRank();
  }

  /**
   * DETERMINE WHETHER THE CURRENT HCPCS IS A BLOOD DEDUCTIBLE.
   *
   * <p>(19655-SET-BD-HCPCS-FLAG - Replaces BLD-DEDUC-HCPCS-FLAG)
   */
  public boolean isBloodHcpcsDeductible(String hcpcs) {
    return bloodRankMap.containsKey(hcpcs);
  }

  /**
   * Returns the outmigration adjustment entry from OUTM-TAB if: OUTM-EFF-DATE &lt;=
   * L-SERVICE-FROM-DATE and OUTM-EFF-DATE &gt;= W-CY-BEGIN-DATE and OUTM-EFF-DATE &lt;=
   * W-CY-END-DATE for the given county code.
   *
   * <p>(19120-GET-OUTM-ADJ)
   */
  public OutMigrationAdjustmentEntry getOutMigrationAdjustment(int countyCode, LocalDate serviceDate) {
    // Extract map based on county code
    final NavigableMap<LocalDate, OutMigrationAdjustmentEntry> map = outMigrationAdjustmentMap.get(countyCode);
    // Return null if county code is not present in the lookup table
    if (map == null) {
      return null;
    }
    // Get the greatest map entry with an effective date less than or equal to the service date
    final Entry<LocalDate, OutMigrationAdjustmentEntry> mapEntry = map.floorEntry(serviceDate);
    // Return null if map does not contain any entries for the given service date
    if (mapEntry == null) {
      return null;
    }
    // Extract the outmigration entry from the map entry
    final OutMigrationAdjustmentEntry entry = mapEntry.getValue();
    // Verify the effective date matches the calendar year of the service date
    if (entry.getEffectiveDate().getYear() == serviceDate.getYear()) {
      return entry.copyBuilder().build();
    }
    // Return null if table does not contain any matching entries for the supplied county code &
    // service date
    return null;
  }

  /**
   * SEARCH AND RETURN PRIOR YEAR WAGE INDEX TABLE.
   *
   * <p>(19123-GET-PRIOR-CY-WI)
   */
  public BigDecimal getPriorYearWageIndex(String providerNumber) {
    final PreviousYearWageIndexEntry entry = previousYearWageIndexMap.get(providerNumber);
    if (entry == null) {
      return null;
    }
    return entry.getWageIndex();
  }

  /**
   * W-WNXC-WNXC-TABLE lookup table.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> getCbsaTable() {
    return this.cbsaTable;
  }
}
