// Generated by delombok at Thu Nov 13 21:35:57 UTC 2025
package gov.cms.fiss.pricers.opps.resources;

import gov.cms.fiss.pricers.common.api.AmbulatoryPaymentClassificationRateData;
import gov.cms.fiss.pricers.common.api.CbsaWageIndexData;
import gov.cms.fiss.pricers.opps.core.tables.ApcRateHistoryEntry;
import gov.cms.fiss.pricers.opps.core.tables.CbsaWageIndexEntry;
import gov.cms.fiss.pricers.opps.core.tables.DataTables;
import gov.cms.fiss.pricers.opps.resources.mapping.AmbulatoryPaymentClassificationRateDataMapper;
import gov.cms.fiss.pricers.opps.resources.mapping.CbsaWageIndexDataMapper;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.function.IntFunction;
import java.util.stream.Collectors;

public final class OppsExtractionUtil {
  public static final IntFunction<List<AmbulatoryPaymentClassificationRateData>> APC_EXTRACTOR = pricerYear -> {
    final Optional<Map<String, NavigableMap<LocalDate, ApcRateHistoryEntry>>> matchingData = Optional.ofNullable(DataTables.forYear(pricerYear).getApcRateHistoryTable());
    return matchingData.map(Map::entrySet).stream().flatMap(s -> s.stream().map(Entry::getValue)).map(Map::entrySet).flatMap(Collection::stream).map(Entry::getValue).map(AmbulatoryPaymentClassificationRateDataMapper.INSTANCE::mapToAmbulatoryPaymentClassificationRateData).collect(Collectors.toList());
  };
  public static final IntFunction<List<CbsaWageIndexData>> CBSA_EXTRACTOR = pricerYear -> {
    final Optional<Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>>> matchingData = Optional.ofNullable(DataTables.forYear(pricerYear).getCbsaTable());
    return matchingData.map(Map::entrySet).stream().flatMap(s -> s.stream().map(Entry::getValue)).map(Map::entrySet).flatMap(Collection::stream).map(Entry::getValue).map(CbsaWageIndexDataMapper.INSTANCE::mapToCbsaWageIndexData).collect(Collectors.toList());
  };

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  private OppsExtractionUtil() {
    throw new java.lang.UnsupportedOperationException("This is a utility class and cannot be instantiated");
  }
}
