// Generated by delombok at Thu Nov 13 21:35:34 UTC 2025
package gov.cms.fiss.pricers.opps.api.v2;

import gov.cms.fiss.pricers.common.api.PaymentData;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithTwoFractionDigits;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.util.List;

@Schema(description = "The claim payment result.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "A-ADDITIONAL-VARIABLES", value = "<structure>")})})
public class OppsPaymentData extends PaymentData {
  @BigDecimalScale
  @NotNull
  @Schema(description = "The total of all line blood deductible amounts.", example = "39084.23", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "A-BLOOD-DEDUCT-DUE", value = "PIC 9(05)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal bloodDeductibleDue = BigDecimalUtils.ZERO;
  @Max(9)
  @Min(0)
  @NotNull
  @Schema(description = "The number of blood pints used for blood deductibles on claim.", example = "2", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "A-BLOOD-PINTS-USED", value = "PIC 9(01)")})})
  private int bloodPintsUsed;
  @BigDecimalScale
  @NotNull
  @Schema(description = "The total of all line device credit amounts.", example = "97834.47", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "A-DEVICE-CREDIT-QD", value = "PIC 9(09)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal deviceCreditQd = BigDecimalUtils.ZERO;
  @ArraySchema(arraySchema = @Schema(description = "The service line payments.", required = true), uniqueItems = true, extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "A-LINE-ITEMS", value = "<structure>")})})
  @NotEmpty
  @Size(max = 450)
  @Valid
  private List<@NotNull ServiceLinePaymentData> serviceLinePayments;
  @BigDecimalScale
  @NotNull
  @Schema(description = "The total of all line charge amounts.", example = "17023.23", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "A-TOT-CLM-CHRG", value = "PIC 9(09)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal totalClaimCharges = BigDecimalUtils.ZERO;
  @BigDecimalScale
  @NotNull
  @Schema(description = "The total of all line deductible amounts.", example = "198.00", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "A-TOTAL-CLM-DEDUCT", value = "PIC 9(03)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal totalClaimDeductible = BigDecimalUtils.ZERO;
  @BigDecimalScale
  @NotNull
  @Schema(description = "The total of all line outlier payment amounts.", example = "1456.62", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "A-OUTLIER-PYMT", value = "PIC 9(09)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal totalClaimOutlierPayment = BigDecimalUtils.ZERO;

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBloodDeductibleDue() {
    return this.bloodDeductibleDue;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getBloodPintsUsed() {
    return this.bloodPintsUsed;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getDeviceCreditQd() {
    return this.deviceCreditQd;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<@NotNull ServiceLinePaymentData> getServiceLinePayments() {
    return this.serviceLinePayments;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getTotalClaimCharges() {
    return this.totalClaimCharges;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getTotalClaimDeductible() {
    return this.totalClaimDeductible;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getTotalClaimOutlierPayment() {
    return this.totalClaimOutlierPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBloodDeductibleDue(final BigDecimal bloodDeductibleDue) {
    this.bloodDeductibleDue = bloodDeductibleDue;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBloodPintsUsed(final int bloodPintsUsed) {
    this.bloodPintsUsed = bloodPintsUsed;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDeviceCreditQd(final BigDecimal deviceCreditQd) {
    this.deviceCreditQd = deviceCreditQd;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setServiceLinePayments(final List<@NotNull ServiceLinePaymentData> serviceLinePayments) {
    this.serviceLinePayments = serviceLinePayments;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTotalClaimCharges(final BigDecimal totalClaimCharges) {
    this.totalClaimCharges = totalClaimCharges;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTotalClaimDeductible(final BigDecimal totalClaimDeductible) {
    this.totalClaimDeductible = totalClaimDeductible;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTotalClaimOutlierPayment(final BigDecimal totalClaimOutlierPayment) {
    this.totalClaimOutlierPayment = totalClaimOutlierPayment;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof OppsPaymentData)) return false;
    final OppsPaymentData other = (OppsPaymentData) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    if (!super.equals(o)) return false;
    if (this.getBloodPintsUsed() != other.getBloodPintsUsed()) return false;
    final java.lang.Object this$bloodDeductibleDue = this.getBloodDeductibleDue();
    final java.lang.Object other$bloodDeductibleDue = other.getBloodDeductibleDue();
    if (this$bloodDeductibleDue == null ? other$bloodDeductibleDue != null : !this$bloodDeductibleDue.equals(other$bloodDeductibleDue)) return false;
    final java.lang.Object this$deviceCreditQd = this.getDeviceCreditQd();
    final java.lang.Object other$deviceCreditQd = other.getDeviceCreditQd();
    if (this$deviceCreditQd == null ? other$deviceCreditQd != null : !this$deviceCreditQd.equals(other$deviceCreditQd)) return false;
    final java.lang.Object this$serviceLinePayments = this.getServiceLinePayments();
    final java.lang.Object other$serviceLinePayments = other.getServiceLinePayments();
    if (this$serviceLinePayments == null ? other$serviceLinePayments != null : !this$serviceLinePayments.equals(other$serviceLinePayments)) return false;
    final java.lang.Object this$totalClaimCharges = this.getTotalClaimCharges();
    final java.lang.Object other$totalClaimCharges = other.getTotalClaimCharges();
    if (this$totalClaimCharges == null ? other$totalClaimCharges != null : !this$totalClaimCharges.equals(other$totalClaimCharges)) return false;
    final java.lang.Object this$totalClaimDeductible = this.getTotalClaimDeductible();
    final java.lang.Object other$totalClaimDeductible = other.getTotalClaimDeductible();
    if (this$totalClaimDeductible == null ? other$totalClaimDeductible != null : !this$totalClaimDeductible.equals(other$totalClaimDeductible)) return false;
    final java.lang.Object this$totalClaimOutlierPayment = this.getTotalClaimOutlierPayment();
    final java.lang.Object other$totalClaimOutlierPayment = other.getTotalClaimOutlierPayment();
    if (this$totalClaimOutlierPayment == null ? other$totalClaimOutlierPayment != null : !this$totalClaimOutlierPayment.equals(other$totalClaimOutlierPayment)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof OppsPaymentData;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = super.hashCode();
    result = result * PRIME + this.getBloodPintsUsed();
    final java.lang.Object $bloodDeductibleDue = this.getBloodDeductibleDue();
    result = result * PRIME + ($bloodDeductibleDue == null ? 43 : $bloodDeductibleDue.hashCode());
    final java.lang.Object $deviceCreditQd = this.getDeviceCreditQd();
    result = result * PRIME + ($deviceCreditQd == null ? 43 : $deviceCreditQd.hashCode());
    final java.lang.Object $serviceLinePayments = this.getServiceLinePayments();
    result = result * PRIME + ($serviceLinePayments == null ? 43 : $serviceLinePayments.hashCode());
    final java.lang.Object $totalClaimCharges = this.getTotalClaimCharges();
    result = result * PRIME + ($totalClaimCharges == null ? 43 : $totalClaimCharges.hashCode());
    final java.lang.Object $totalClaimDeductible = this.getTotalClaimDeductible();
    result = result * PRIME + ($totalClaimDeductible == null ? 43 : $totalClaimDeductible.hashCode());
    final java.lang.Object $totalClaimOutlierPayment = this.getTotalClaimOutlierPayment();
    result = result * PRIME + ($totalClaimOutlierPayment == null ? 43 : $totalClaimOutlierPayment.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "OppsPaymentData(bloodDeductibleDue=" + this.getBloodDeductibleDue() + ", bloodPintsUsed=" + this.getBloodPintsUsed() + ", deviceCreditQd=" + this.getDeviceCreditQd() + ", serviceLinePayments=" + this.getServiceLinePayments() + ", totalClaimCharges=" + this.getTotalClaimCharges() + ", totalClaimDeductible=" + this.getTotalClaimDeductible() + ", totalClaimOutlierPayment=" + this.getTotalClaimOutlierPayment() + ")";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public OppsPaymentData() {
  }
}
