/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.util;

import ch.obermuhlner.math.big.BigDecimalMath;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public final class BigDecimalUtils {
    public static final int DEFAULT_PRECISION = 2;
    public static final int DEFAULT_SCALE = 2;
    public static final BigDecimal ZERO = BigDecimal.ZERO.setScale(2, RoundingMode.UNNECESSARY);

    public static BigDecimal defaultValue(BigDecimal providedValue, @NonNull BigDecimal defaultValue) {
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return null != providedValue ? providedValue : defaultValue;
    }

    public static BigDecimal defaultValue(BigDecimal providedValue) {
        return BigDecimalUtils.defaultValue(providedValue, ZERO);
    }

    public static boolean equals(BigDecimal lhs, BigDecimal rhs) {
        if (null == lhs) {
            return null == rhs;
        }
        if (null == rhs) {
            return false;
        }
        return lhs.compareTo(rhs) == 0;
    }

    public static boolean isGreaterThan(BigDecimal lhs, BigDecimal rhs) {
        if (null == lhs) {
            return false;
        }
        if (null == rhs) {
            return true;
        }
        return lhs.compareTo(rhs) > 0;
    }

    public static boolean isGreaterThanZero(BigDecimal val) {
        return BigDecimalUtils.isGreaterThan(val, ZERO);
    }

    public static boolean isGreaterThanOrEqualTo(BigDecimal lhs, BigDecimal rhs) {
        if (null == lhs) {
            return null == rhs;
        }
        if (null == rhs) {
            return true;
        }
        return lhs.compareTo(rhs) >= 0;
    }

    public static boolean isGreaterThanOrEqualToZero(BigDecimal val) {
        return BigDecimalUtils.isGreaterThanOrEqualTo(val, ZERO);
    }

    public static boolean isLessThan(BigDecimal lhs, BigDecimal rhs) {
        return lhs.compareTo(rhs) < 0;
    }

    public static boolean isLessThanZero(BigDecimal val) {
        if (null == val) {
            return true;
        }
        return BigDecimalUtils.isLessThan(val, BigDecimal.ZERO);
    }

    public static boolean isLessThanOrEqualTo(BigDecimal lhs, BigDecimal rhs) {
        if (null == rhs) {
            return null == lhs;
        }
        if (null == lhs) {
            return true;
        }
        return lhs.compareTo(rhs) <= 0;
    }

    public static boolean isLessThanOrEqualToZero(BigDecimal val) {
        return BigDecimalUtils.isLessThanOrEqualTo(val, ZERO);
    }

    public static boolean isZero(BigDecimal val) {
        return BigDecimalUtils.equals(ZERO, val);
    }

    public static BigDecimal pow(BigDecimal base, BigDecimal exponent) {
        return BigDecimalUtils.pow(base, exponent, 2);
    }

    public static BigDecimal pow(BigDecimal base, BigDecimal exponent, int precision) {
        if (null == base || null == exponent) {
            return null;
        }
        return BigDecimalMath.pow((BigDecimal)base, (BigDecimal)exponent, (MathContext)new MathContext(precision));
    }

    public static BigDecimal truncateDecimals(BigDecimal val) {
        return BigDecimalUtils.truncateDecimals(val, 2);
    }

    public static BigDecimal truncateDecimals(BigDecimal val, int scale) {
        if (null == val) {
            return null;
        }
        return val.setScale(scale, RoundingMode.DOWN);
    }

    public static BigDecimal decimalSum(BigDecimal addend, BigDecimal ... augends) {
        BigDecimal total = ZERO.add(Optional.ofNullable(addend).orElse(ZERO));
        for (BigDecimal augend : augends) {
            total = total.add(Optional.ofNullable(augend).orElse(ZERO));
        }
        return total;
    }

    @Generated
    private BigDecimalUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

