/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core;

import gov.cms.fiss.pricers.common.api.InternalPricerException;
import gov.cms.fiss.pricers.common.api.YearNotImplementedException;
import gov.cms.fiss.pricers.common.application.ClaimProcessor;
import gov.cms.fiss.pricers.common.application.PricerDispatch;
import gov.cms.fiss.pricers.opps.OppsPricerConfiguration;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimData;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimPricingRequest;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimPricingResponse;
import gov.cms.fiss.pricers.opps.core.Opps2020RulePricer;
import gov.cms.fiss.pricers.opps.core.Opps2021RulePricer;
import gov.cms.fiss.pricers.opps.core.Opps2022RulePricer;
import gov.cms.fiss.pricers.opps.core.Opps2023RulePricer;
import gov.cms.fiss.pricers.opps.core.Opps2024RulePricer;
import gov.cms.fiss.pricers.opps.core.Opps2025RulePricer;
import gov.cms.fiss.pricers.opps.core.tables.DataTables;

public class OppsPricerDispatch
extends PricerDispatch<OppsClaimPricingRequest, OppsClaimPricingResponse, OppsPricerConfiguration> {
    public OppsPricerDispatch(OppsPricerConfiguration pricerConfiguration) {
        super(pricerConfiguration, o -> o.getReturnCodeData().getCode());
    }

    @Override
    protected void initializeReferences(OppsPricerConfiguration pricerConfiguration) {
        DataTables.loadDataTables(pricerConfiguration);
        for (int supportedYear : pricerConfiguration.getSupportedYears()) {
            switch (supportedYear) {
                case 2020: {
                    this.yearReference.register(supportedYear, Opps2020RulePricer.class, DataTables.forYear(supportedYear));
                    break;
                }
                case 2021: {
                    this.yearReference.register(supportedYear, Opps2021RulePricer.class, DataTables.forYear(supportedYear));
                    break;
                }
                case 2022: {
                    this.yearReference.register(supportedYear, Opps2022RulePricer.class, DataTables.forYear(supportedYear));
                    break;
                }
                case 2023: {
                    this.yearReference.register(supportedYear, Opps2023RulePricer.class, DataTables.forYear(supportedYear));
                    break;
                }
                case 2024: {
                    this.yearReference.register(supportedYear, Opps2024RulePricer.class, DataTables.forYear(supportedYear));
                    break;
                }
                case 2025: {
                    this.yearReference.register(supportedYear, Opps2025RulePricer.class, DataTables.forYear(supportedYear));
                    break;
                }
            }
        }
    }

    @Override
    protected ClaimProcessor<OppsClaimPricingRequest, OppsClaimPricingResponse> getProcessor(OppsClaimPricingRequest input) throws YearNotImplementedException, InternalPricerException {
        return this.yearReference.fromCalendarYear(((OppsClaimData)input.getClaimData()).getServiceFromDate(), "serviceFromDate");
    }

    @Override
    protected boolean isErrorOutput(OppsClaimPricingResponse output) {
        return Integer.parseInt(output.getReturnCodeData().getCode()) >= 50;
    }
}

