/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.rules.adjust_procedure_lines;

import gov.cms.fiss.pricers.common.api.OutpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.opps.api.v2.IoceServiceLineData;
import gov.cms.fiss.pricers.opps.api.v2.ServiceLinePaymentData;
import gov.cms.fiss.pricers.opps.core.DeductibleLineContext;
import gov.cms.fiss.pricers.opps.core.OppsPricerContext;
import gov.cms.fiss.pricers.opps.core.OutlierPaymentInfo;
import gov.cms.fiss.pricers.opps.core.codes.PaymentMethodFlag;
import gov.cms.fiss.pricers.opps.core.codes.ReturnCode;
import gov.cms.fiss.pricers.opps.core.model.DeductibleLine;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.stream.Stream;

public class CalculateOutlierPayment
implements CalculationRule<DeductibleLine, ServiceLinePaymentData, DeductibleLineContext> {
    @Override
    public boolean shouldExecute(DeductibleLineContext calculationContext) {
        return calculationContext.getLineCalculation().getPayment() != null;
    }

    @Override
    public void calculate(DeductibleLineContext calculationContext) {
        BigDecimal lineOutlierPayment;
        DeductibleLine deductibleLine = (DeductibleLine)calculationContext.getInput();
        OppsPricerContext pricerContext = calculationContext.getPricerContext();
        OutlierPaymentInfo outlierPaymentInfo = calculationContext.getOutlierPaymentInfo();
        OutpatientProviderData providerData = pricerContext.getProviderData();
        BigDecimal outlierPayment = outlierPaymentInfo.getOutlierPayment();
        IoceServiceLineData line = deductibleLine.getServiceLine();
        BigDecimal linePayment = calculationContext.getLineCalculation().getPayment();
        BigDecimal cost = deductibleLine.getSubCharge().multiply(providerData.getOperatingCostToChargeRatio()).setScale(2, RoundingMode.HALF_UP);
        if (pricerContext.isCommunityMentalHealthCenter()) {
            lineOutlierPayment = cost.subtract(OppsPricerContext.OUTLIER_FACTOR_ALT.multiply(linePayment)).multiply(OppsPricerContext.OUTLIER_PERCENT).setScale(2, RoundingMode.HALF_UP);
            if (BigDecimalUtils.isLessThanZero(lineOutlierPayment)) {
                lineOutlierPayment = BigDecimal.ZERO;
            }
            if (this.isSubjectToOutlierCap(line.getPaymentMethodFlag())) {
                outlierPaymentInfo.setCmhcTotalPayment(outlierPaymentInfo.getCmhcTotalPayment().add(linePayment));
                outlierPaymentInfo.setCmhcTotalOutlier(outlierPaymentInfo.getCmhcTotalOutlier().add(lineOutlierPayment));
            }
        } else {
            BigDecimal apcAdjPymt = OppsPricerContext.OUTLIER_FACTOR.multiply(linePayment).setScale(2, RoundingMode.HALF_UP);
            lineOutlierPayment = BigDecimalUtils.isGreaterThan(cost, apcAdjPymt) && BigDecimalUtils.isGreaterThan(cost, linePayment.add(pricerContext.getLinePaymentOutlierOffset())) ? cost.subtract(apcAdjPymt).multiply(OppsPricerContext.OUTLIER_PERCENT).setScale(2, RoundingMode.HALF_UP) : BigDecimalUtils.ZERO;
        }
        if (BigDecimalUtils.isGreaterThanZero(lineOutlierPayment)) {
            outlierPayment = outlierPayment.add(lineOutlierPayment);
            if (OppsPricerContext.hasExternalAdjustment(line.getActionFlag())) {
                outlierPayment = outlierPayment.subtract(lineOutlierPayment);
                lineOutlierPayment = BigDecimalUtils.ZERO;
            }
        }
        if (!this.isEligibleForAnOutlierPayment(line.getPaymentMethodFlag()) && BigDecimalUtils.isGreaterThanZero(lineOutlierPayment)) {
            outlierPayment = outlierPayment.subtract(lineOutlierPayment);
            pricerContext.applyClaimReturnCode(ReturnCode.CMHC_LIMIT_REACHED_2);
        }
        outlierPaymentInfo.setOutlierPayment(outlierPayment);
    }

    private boolean isSubjectToOutlierCap(String paymentMethodFlag) {
        return Stream.of(PaymentMethodFlag.OPPS_0, PaymentMethodFlag.CONTRACTOR_BYPASS_Z).anyMatch(paf -> paf.is(paymentMethodFlag));
    }

    private boolean isEligibleForAnOutlierPayment(String paymentMethodFlag) {
        return Stream.of(PaymentMethodFlag.CMHC_LIMIT_REACHED_6, PaymentMethodFlag.RADIATION_ONCOLOGY_MODEL_B).noneMatch(paf -> paf.is(paymentMethodFlag));
    }
}

