/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.rules.calculate_deductible_lines.calculate_standard_payment;

import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.opps.api.v2.IoceServiceLineData;
import gov.cms.fiss.pricers.opps.core.DeductibleLineContext;
import gov.cms.fiss.pricers.opps.core.OppsPricerContext;
import gov.cms.fiss.pricers.opps.core.codes.PaymentAdjustmentFlag;
import gov.cms.fiss.pricers.opps.core.model.DeductibleLine;
import gov.cms.fiss.pricers.opps.core.model.LineCalculation;
import gov.cms.fiss.pricers.opps.core.rules.calculate_deductible_lines.calculate_standard_payment.AbstractDeductibleLineRule;
import java.math.RoundingMode;
import java.util.List;
import java.util.stream.Stream;

public class CalculateLineReimbursement
extends AbstractDeductibleLineRule {
    @Override
    public void calculate(DeductibleLineContext calculationContext) {
        LineCalculation lineCalculation = calculationContext.getLineCalculation();
        DeductibleLine deductibleLine = (DeductibleLine)calculationContext.getInput();
        IoceServiceLineData lineInput = deductibleLine.getServiceLine();
        if (calculationContext.isPackagedBloodDeductibleLine()) {
            lineCalculation.setReimbursement(BigDecimalUtils.ZERO);
            lineCalculation.setTotalDeductible(BigDecimalUtils.ZERO);
            lineCalculation.setNationalCoinsurance(BigDecimalUtils.ZERO);
            lineCalculation.setMinimumCoinsurance(BigDecimalUtils.ZERO);
            lineCalculation.setReducedCoinsurance(BigDecimalUtils.ZERO);
            calculationContext.completeStandardPaymentCalculation();
            return;
        }
        if (this.isCoinsuranceNotApplicable(lineInput.getPaymentAdjustmentFlags())) {
            lineCalculation.setReimbursement(lineCalculation.getPayment().subtract(lineCalculation.getTotalDeductible()));
            lineCalculation.setNationalCoinsurance(BigDecimalUtils.ZERO);
            lineCalculation.setMinimumCoinsurance(BigDecimalUtils.ZERO);
            lineCalculation.setReducedCoinsurance(BigDecimalUtils.ZERO);
            calculationContext.completeStandardPaymentCalculation();
            return;
        }
        lineCalculation.setReimbursement(lineCalculation.getPayment().subtract(lineCalculation.getTotalDeductible()).subtract(lineCalculation.getBloodDeductible()).multiply(deductibleLine.getReimbursementRate()).setScale(2, RoundingMode.HALF_UP));
        lineCalculation.setNationalCoinsurance(lineCalculation.getPayment().subtract(lineCalculation.getTotalDeductible()).subtract(lineCalculation.getReimbursement()).subtract(lineCalculation.getBloodDeductible()));
        if (OppsPricerContext.isSection603(lineInput.getPaymentMethodFlag())) {
            lineCalculation.setMinimumCoinsurance(lineCalculation.getPayment().multiply(OppsPricerContext.PFS_REDUCTION_COINSURANCE_RATE).setScale(2, RoundingMode.HALF_UP));
            lineCalculation.setReducedCoinsurance(BigDecimalUtils.ZERO);
            calculationContext.completeStandardPaymentCalculation();
        }
    }

    private boolean isCoinsuranceNotApplicable(List<String> paymentAdjustmentFlags) {
        return Stream.of(PaymentAdjustmentFlag.DEDUCTIBLE_AND_COINSURANCE_NOT_APPLICABLE_9, PaymentAdjustmentFlag.COINSURANCE_NOT_APPLICABLE_10, PaymentAdjustmentFlag.X_RAY_NO_COINSURANCE_23, PaymentAdjustmentFlag.COMPUTED_RADIOLOGY_NO_COINSURANCE_24).anyMatch(si -> si.is(paymentAdjustmentFlags));
    }
}

