/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.tables;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import jakarta.validation.constraints.Digits;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import lombok.Generated;

@JsonDeserialize(builder=OutMigrationAdjustmentEntryBuilder.class)
@JsonPropertyOrder(value={"county", "adjustmentFactor", "effectiveDate"})
@Immutable
public class OutMigrationAdjustmentEntry
implements Comparable<OutMigrationAdjustmentEntry> {
    @Digits(integer=5, fraction=0)
    private final @Digits(integer=5, fraction=0) Integer county;
    @Digits(integer=1, fraction=4)
    private final @Digits(integer=1, fraction=4) BigDecimal adjustmentFactor;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyyMMdd")
    private final LocalDate effectiveDate;

    @Override
    public int compareTo(@Nonnull OutMigrationAdjustmentEntry other) {
        return Comparator.comparing(OutMigrationAdjustmentEntry::getCounty).thenComparing(OutMigrationAdjustmentEntry::getEffectiveDate).compare(this, other);
    }

    public OutMigrationAdjustmentEntryBuilder copyBuilder() {
        return OutMigrationAdjustmentEntry.builder().county(this.getCounty()).adjustmentFactor(this.getAdjustmentFactor()).effectiveDate(this.getEffectiveDate());
    }

    @Generated
    OutMigrationAdjustmentEntry(Integer county, BigDecimal adjustmentFactor, LocalDate effectiveDate) {
        this.county = county;
        this.adjustmentFactor = adjustmentFactor;
        this.effectiveDate = effectiveDate;
    }

    @Generated
    public static OutMigrationAdjustmentEntryBuilder builder() {
        return new OutMigrationAdjustmentEntryBuilder();
    }

    @Generated
    public Integer getCounty() {
        return this.county;
    }

    @Generated
    public BigDecimal getAdjustmentFactor() {
        return this.adjustmentFactor;
    }

    @Generated
    public LocalDate getEffectiveDate() {
        return this.effectiveDate;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class OutMigrationAdjustmentEntryBuilder {
        @Generated
        private Integer county;
        @Generated
        private BigDecimal adjustmentFactor;
        @Generated
        private LocalDate effectiveDate;

        @Generated
        OutMigrationAdjustmentEntryBuilder() {
        }

        @Generated
        public OutMigrationAdjustmentEntryBuilder county(Integer county) {
            this.county = county;
            return this;
        }

        @Generated
        public OutMigrationAdjustmentEntryBuilder adjustmentFactor(BigDecimal adjustmentFactor) {
            this.adjustmentFactor = adjustmentFactor;
            return this;
        }

        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyyMMdd")
        @Generated
        public OutMigrationAdjustmentEntryBuilder effectiveDate(LocalDate effectiveDate) {
            this.effectiveDate = effectiveDate;
            return this;
        }

        @Generated
        public OutMigrationAdjustmentEntry build() {
            return new OutMigrationAdjustmentEntry(this.county, this.adjustmentFactor, this.effectiveDate);
        }

        @Generated
        public String toString() {
            return "OutMigrationAdjustmentEntry.OutMigrationAdjustmentEntryBuilder(county=" + this.county + ", adjustmentFactor=" + this.adjustmentFactor + ", effectiveDate=" + this.effectiveDate + ")";
        }
    }

    @Generated
    public static final class Fields {
        public static final String COUNTY = "county";
        public static final String ADJUSTMENT_FACTOR = "adjustmentFactor";
        public static final String EFFECTIVE_DATE = "effectiveDate";
    }
}

