/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvContentReader;
import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.common.csv.LookupGenerator;
import gov.cms.fiss.pricers.opps.core.tables.PreviousYearWageIndexEntry;
import java.util.List;
import java.util.Map;

public class PreviousYearWageIndexLookupGenerator {
    private static final String CSV_FILE_PATTERN = "/previous-year-wage-index-2019.csv";
    private final CsvContentReader<PreviousYearWageIndexEntry> contentProvider = new CsvContentReader<PreviousYearWageIndexEntry>(PreviousYearWageIndexEntry.class).customizeSchema(CsvContentReader.HEADER_ROW_CUSTOMIZER);

    public PreviousYearWageIndexLookupGenerator(CsvIngestionConfiguration csvIngestionConfiguration) {
        if (!csvIngestionConfiguration.isValidationEnabled()) {
            this.contentProvider.disableValidation();
        }
    }

    public Map<String, PreviousYearWageIndexEntry> generate() {
        return this.generate(CSV_FILE_PATTERN);
    }

    public Map<String, PreviousYearWageIndexEntry> generate(String csvFile) {
        List<PreviousYearWageIndexEntry> content = this.contentProvider.read(csvFile);
        return LookupGenerator.generateMap(PreviousYearWageIndexEntry::getProviderNumber, content);
    }
}

