/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.request.logging.old;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.pattern.DynamicConverter;
import ch.qos.logback.core.pattern.PatternLayoutBase;
import ch.qos.logback.core.spi.AppenderAttachableImpl;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.logging.common.AppenderFactory;
import io.dropwizard.logging.common.ConsoleAppenderFactory;
import io.dropwizard.logging.common.async.AsyncLoggingEventAppenderFactory;
import io.dropwizard.logging.common.filter.NullLevelFilterFactory;
import io.dropwizard.logging.common.layout.LayoutFactory;
import io.dropwizard.request.logging.RequestLogFactory;
import io.dropwizard.request.logging.old.ClassicLogFormat;
import io.dropwizard.request.logging.old.DropwizardSlf4jRequestLogWriter;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Supplier;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.RequestLog;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="classic")
public class LogbackClassicRequestLogFactory
implements RequestLogFactory<RequestLog> {
    @NotNull
    private TimeZone timeZone = TimeZone.getTimeZone("UTC");
    @Valid
    @NotNull
    private List<AppenderFactory<ILoggingEvent>> appenders = Collections.singletonList(new ConsoleAppenderFactory());

    @JsonProperty
    public List<AppenderFactory<ILoggingEvent>> getAppenders() {
        return this.appenders;
    }

    @JsonProperty
    public void setAppenders(List<AppenderFactory<ILoggingEvent>> appenders) {
        this.appenders = appenders;
    }

    @JsonProperty
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @JsonProperty
    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @Override
    @JsonIgnore
    public boolean isEnabled() {
        return !this.appenders.isEmpty();
    }

    @Override
    public RequestLog build(String name) {
        Logger logger2 = (Logger)LoggerFactory.getLogger("http.request");
        logger2.setAdditive(false);
        LoggerContext context = logger2.getLoggerContext();
        NullLevelFilterFactory levelFilterFactory = new NullLevelFilterFactory();
        AsyncLoggingEventAppenderFactory asyncAppenderFactory = new AsyncLoggingEventAppenderFactory();
        LayoutFactory layoutFactory = (c, tz) -> new RequestLogLayout(c);
        AppenderAttachableImpl<ILoggingEvent> attachable = new AppenderAttachableImpl<ILoggingEvent>();
        for (AppenderFactory<ILoggingEvent> appender : this.appenders) {
            attachable.addAppender(appender.build(context, name, layoutFactory, levelFilterFactory, asyncAppenderFactory));
        }
        return new CustomRequestLog(new DropwizardSlf4jRequestLogWriter(attachable), ClassicLogFormat.pattern(this.timeZone));
    }

    private static class RequestLogLayout
    extends PatternLayoutBase<ILoggingEvent> {
        private RequestLogLayout(Context context) {
            this.setContext(context);
        }

        @Override
        public String doLayout(ILoggingEvent event) {
            return event.getFormattedMessage() + CoreConstants.LINE_SEPARATOR;
        }

        @Override
        protected Map<String, Supplier<DynamicConverter>> getDefaultConverterSupplierMap() {
            return Collections.emptyMap();
        }

        @Override
        public Map<String, String> getDefaultConverterMap() {
            return Collections.emptyMap();
        }
    }
}

