// Generated by delombok at Thu Nov 13 21:35:57 UTC 2025
package gov.cms.fiss.pricers.opps.core.codes;

import org.apache.commons.lang3.StringUtils;

@SuppressWarnings("unused")
public enum PaymentMethodFlag {
  /**
   * OPPS pricer determines payment for service.
   */
  OPPS_0("0"), /**
   * Service not paid based on coverage or billing rules.
   */
  NOT_PAID_1("1"), /**
   * Service is not subject to OPPS.
   */
  NOT_OPPS_2("2"), /**
   * Service is not subject to OPPS and has an OCE line item denial or rejection.
   */
  NOT_OPPS_WITH_LINE_DENIAL_3("3"), /**
   * Line item is denied or rejected by MAC; OCE not applied to line item.
   */
  LINE_DENIAL_4("4"), /**
   * Payment for service determined under FQHC PPS.
   */
  FQHC_PPS_5("5"), /**
   * CMHC outlier limitation reached.
   */
  CMHC_LIMIT_REACHED_6("6"), /**
   * Section 603 service with no reduction in OPPS Pricer.
   */
  SECTION603_NO_REDUCTION_7("7"), /**
   * Section 603 service with PFS reduction applied in OPPS Pricer.
   */
  SECTION603_REDUCTION_8("8"), /**
   * CMHC outlier limitation bypassed.
   */
  CMHC_LIMIT_BYPASSED_9("9"), /**
   * Payment reduction for off-campus clinic visit.
   */
  OFF_CAMPUS_CLINIC_A("A"), /**
   * Payment reduction for off-campus clinic visit.
   */
  CONTRACTOR_BYPASS_OFF_CAMPUS_CLINIC_W("W"), /**
   * Contractor bypass applied to off-campus clinic visit for payment reduction
   */
  CONTRACTOR_BYPASS_SECTION_603_NO_REDUCTION_X("X"), /**
   * Contractor bypass applied to Section 603 service with reduction applied in OPPS Pricer.
   */
  CONTRACTOR_BYPASS_SECTION_603_REDUCTION_Y("Y"), /**
   * Contractor bypass determines payment for services.
   */
  CONTRACTOR_BYPASS_Z("Z"), /**
   * Radiation Oncology Model identifier to receive PMA adjustment.
   */
  RADIATION_ONCOLOGY_MODEL_B("B");
  private final String flag;

  PaymentMethodFlag(String flag) {
    this.flag = flag;
  }

  public boolean is(String paymentMethodFlag) {
    return StringUtils.equals(flag, paymentMethodFlag);
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getFlag() {
    return this.flag;
  }
}
