// Generated by delombok at Thu Nov 13 21:35:57 UTC 2025
package gov.cms.fiss.pricers.opps.core.codes;

import gov.cms.fiss.pricers.common.api.ReturnCodeData;
import org.apache.commons.lang3.StringUtils;

@SuppressWarnings("unused")
public enum ReturnCode {
  /**
   * Line not processed.
   */
  NOT_PROCESSED_0(0, "LINE NOT PROCESSED", "Line not processed"), /**
   * Claim processed.
   */
  PROCESSED_1(1, "PROCESSED", "Processed"), CMHC_LIMIT_REACHED_2(2, "CMHC LIMIT REACHED", "CMHC limit reached"), /**
   * Reduced for absent quality reporting.
   */
  ABSENT_QUALITY_REPORTING_11(11, "ABSENT QUALITY REPORTING", "Absent quality reporting"), /**
   * Payment equal to zero (Bene deductible &gt; Payment).
   */
  PAYMENT_EQUALS_ZERO_20(20, "PAYMENT EQUALS ZERO", "Payment equals zero"), /**
   * Daily Coinsurance limitation.
   */
  DAILY_COINSURANCE_LIMITATION_22(22, "DAILY COINSURANCE LIMITATION", "Daily coinsurance limitation"), /**
   * Provider elected coinsurance reduction for APC.
   */
  COINSURANCE_REDUCTION_25(25, "COINSURANCE REDUCTION", "Coinsurance reduction"), /**
   * APC not found in table.
   */
  APC_NOT_FOUND_30(30, "APC NOT FOUND", "APC not found"), /**
   * Discount Factor Indicator Invalid.
   */
  DISCOUNT_FACTOR_INDICATOR_INVALID_38(38, "DISCOUNT FACTOR INDICATOR INVALID", "Discount factor indicator invalid"), /**
   * Service Indicator Invalid.
   */
  STATUS_INDICATOR_INVALID_40(40, "STATUS INDICATOR INVALID", "Status indicator invalid"), /**
   * Service Indicator Invalid for OPPS Pricer.
   */
  STATUS_INDICATOR_INVALID_FOR_OPPS_41(41, "STATUS INDICATOR INVALID FOR OPPS", "Status indicator invalid for OPPS"), /**
   * APC equal to '00000' OR Packaging Flag = '1' or '2' or '4'.
   */
  INVALID_APC_OR_PACKAGING_FLAG_42(42, "INVALID APC OR PACKAGING FLAG", "APC equal to \'00000\' OR Packaging Flag = \'1\' or \'2\' or \'4\'"), /**
   * Payment Indicator not equal to 1 or 5 thru 9.
   */
  INVALID_PAYMENT_INDICATOR_43(43, "INVALID PAYMENT INDICATOR", "Payment Indicator not equal to 1 or 5 thru 9"), /**
   * Service Indicator equal to 'H' but Payment Indicator not equal to '6'.
   */
  INVALID_STATUS_INDICATOR_44(44, "INVALID STATUS INDICATOR", "Service Indicator equal to \'H\' but Payment Indicator not equal to \'6\'"), /**
   * Payment Indicator not equal to 1 or 5 thru 9.
   */
  PACKAGING_FLAG_NOT_ZERO_45(45, "PACKAGING FLAG NOT ZERO", "Packaging flag not zero"), /**
   * Line Item Denial/Reject Flag not equal zero AND Line Item Action Flag not equal to 1.
   */
  INVALID_DENIAL_46(46, "INVALID DENIAL", "Line Item Denial/Reject Flag not equal zero AND Line Item Action Flag not equal to 1"), /**
   * Line Item Action Flag equal to '2' or '3'.
   */
  INVALID_ACTION_FLAG_47(47, "INVALID ACTION FLAG", "Invalid action flag"), /**
   * Payment Adjustment Flag invalid.
   */
  INVALID_PAYMENT_ADJUSTMENT_FLAG_48(48, "INVALID PAYMENT ADJUSTMENT FLAG", "Invalid payment adjustment flag"), /**
   * Type of Bill Inclusion Flag not equal zero.
   */
  BILL_INCLUSION_FLAG_NOT_ZERO_49(49, "BILL INCLUSION FLAG NOT ZERO", "Bill inclusion flag not zero"), /**
   * Wage Index not located.
   */
  WAGE_INDEX_NOT_FOUND_50(50, "WAGE INDEX NOT FOUND", "Wage index not found"), /**
   * Wage Index equal zero.
   */
  WAGE_INDEX_EQUALS_ZERO_51(51, "WAGE INDEX EQUALS ZERO", "Wage index equals zero"), /**
   * Wage Index - Invalid Reclassification Change Code.
   */
  WAGE_INDEX_INVALID_RECLASSIFICATION_52(52, "WAGE INDEX INVALID RECLASSIFICATION", "Wage index invalid reclassification"), /**
   * Service From Date not numeric or less than OPPS Start date.
   */
  SERVICE_FROM_DATE_NOT_NUMERIC_53(53, "SERVICE FROM DATE NOT NUMERIC", "Service from date not numeric"), /**
   * Service From Date not in range with Provider Effective Date.
   */
  SERVICE_FROM_DATE_NOT_IN_RANGE_54(54, "SERVICE FROM DATE NOT IN RANGE", "Service from date not in range");
  private final int code;
  private final String desc;
  private final String exp;

  ReturnCode(int code, String desc, String exp) {
    this.code = code;
    this.desc = desc;
    this.exp = exp;
  }

  public int getCode() {
    return this.code;
  }

  public String getDescription() {
    return this.desc;
  }

  public String getExplanation() {
    return this.exp;
  }

  public ReturnCodeData toReturnCodeData() {
    final ReturnCodeData returnCodeData = new ReturnCodeData();
    final String paddedCode = StringUtils.leftPad(Integer.toString(this.getCode()), 2, "0");
    returnCodeData.setCode(paddedCode);
    returnCodeData.setDescription(this.getDescription());
    returnCodeData.setExplanation(this.getExplanation());
    return returnCodeData;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDesc() {
    return this.desc;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getExp() {
    return this.exp;
  }
}
