// Generated by delombok at Thu Nov 13 21:35:57 UTC 2025
package gov.cms.fiss.pricers.opps.core.model;

import gov.cms.fiss.pricers.opps.api.v2.IoceServiceLineData;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * LAY-UP TABLE TO PROCESS COINSURANCE CAP ROLL-UP.
 *
 * <p>(W-DOS-COIN-PTR-TABLE - W-DCP-ENTRY)
 */
public class CoinsuranceCapEntry implements Comparable<CoinsuranceCapEntry> {
  private LocalDate dateOfService; // W-DCP-DOS
  private Integer code; // W-DCP-CODE
  private String statusIndicator; // W-DCP-SRVC-IND
  /**
   * PROCEDURE / VISIT LINE NEW COINSURANCE AMOUNT.
   */
  private BigDecimal coinsurance1; // W-DCP-COIN1
  /**
   * BLOOD LINE NEW COINSURANCE AMOUNT(S).
   */
  private BigDecimal coinsurance2; // W-DCP-COIN2
  private BigDecimal nationalWageAdjustedCoinsurance; // W-DCP-WGNAT
  private IoceServiceLineData serviceLine;

  // ORDER LINES BY:
  //   1. DATE OF SERVICE (EARLIEST TO LATEST)
  //   2. DCP-CODE - TYPE OF ENTRY BASED ON SERVICE INDICATOR
  //      DCP-CODE OF 1: DAY SUMMARY
  //      DCP-CODE OF 2: BLOOD LINE
  //   THERE IS ONE TYPE 1 RECORD PER DAY; THERE MAY BE MULTIPLE
  //   TYPE 2 RECORDS PER DAY - ONE FOR EVERY BLOOD LINE
  @Override
  public int compareTo(CoinsuranceCapEntry entry) {
    final int result = dateOfService.compareTo(entry.getDateOfService());
    if (result == 0) {
      return code.compareTo(entry.getCode());
    }
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof CoinsuranceCapEntry)) return false;
    final CoinsuranceCapEntry other = (CoinsuranceCapEntry) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$code = this.getCode();
    final java.lang.Object other$code = other.getCode();
    if (this$code == null ? other$code != null : !this$code.equals(other$code)) return false;
    final java.lang.Object this$dateOfService = this.getDateOfService();
    final java.lang.Object other$dateOfService = other.getDateOfService();
    if (this$dateOfService == null ? other$dateOfService != null : !this$dateOfService.equals(other$dateOfService)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof CoinsuranceCapEntry;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $code = this.getCode();
    result = result * PRIME + ($code == null ? 43 : $code.hashCode());
    final java.lang.Object $dateOfService = this.getDateOfService();
    result = result * PRIME + ($dateOfService == null ? 43 : $dateOfService.hashCode());
    return result;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LocalDate getDateOfService() {
    return this.dateOfService;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Integer getCode() {
    return this.code;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getStatusIndicator() {
    return this.statusIndicator;
  }

  /**
   * PROCEDURE / VISIT LINE NEW COINSURANCE AMOUNT.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCoinsurance1() {
    return this.coinsurance1;
  }

  /**
   * BLOOD LINE NEW COINSURANCE AMOUNT(S).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCoinsurance2() {
    return this.coinsurance2;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getNationalWageAdjustedCoinsurance() {
    return this.nationalWageAdjustedCoinsurance;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public IoceServiceLineData getServiceLine() {
    return this.serviceLine;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDateOfService(final LocalDate dateOfService) {
    this.dateOfService = dateOfService;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCode(final Integer code) {
    this.code = code;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStatusIndicator(final String statusIndicator) {
    this.statusIndicator = statusIndicator;
  }

  /**
   * PROCEDURE / VISIT LINE NEW COINSURANCE AMOUNT.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCoinsurance1(final BigDecimal coinsurance1) {
    this.coinsurance1 = coinsurance1;
  }

  /**
   * BLOOD LINE NEW COINSURANCE AMOUNT(S).
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCoinsurance2(final BigDecimal coinsurance2) {
    this.coinsurance2 = coinsurance2;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNationalWageAdjustedCoinsurance(final BigDecimal nationalWageAdjustedCoinsurance) {
    this.nationalWageAdjustedCoinsurance = nationalWageAdjustedCoinsurance;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setServiceLine(final IoceServiceLineData serviceLine) {
    this.serviceLine = serviceLine;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "CoinsuranceCapEntry(dateOfService=" + this.getDateOfService() + ", code=" + this.getCode() + ", statusIndicator=" + this.getStatusIndicator() + ", coinsurance1=" + this.getCoinsurance1() + ", coinsurance2=" + this.getCoinsurance2() + ", nationalWageAdjustedCoinsurance=" + this.getNationalWageAdjustedCoinsurance() + ", serviceLine=" + this.getServiceLine() + ")";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public CoinsuranceCapEntry() {
  }
}
