/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.api.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.NumberSerializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScaleInfo;
import java.io.IOException;
import java.math.BigDecimal;

public class ScaledBigDecimalSerializer
extends StdScalarSerializer<BigDecimal>
implements ContextualSerializer {
    private final NumberSerializer serializer;
    private BigDecimalScaleInfo scaleInfo = null;

    public ScaledBigDecimalSerializer(NumberSerializer serializer) {
        super(BigDecimal.class);
        this.serializer = serializer;
    }

    private ScaledBigDecimalSerializer(NumberSerializer serializer, BigDecimalScaleInfo scaleInfo) {
        this(serializer);
        this.scaleInfo = scaleInfo;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty property) {
        BigDecimalScale annotation = property.getMember().getAnnotation(BigDecimalScale.class);
        if (annotation == null) {
            return this.serializer;
        }
        return new ScaledBigDecimalSerializer(this.serializer, new BigDecimalScaleInfo(annotation.scale(), annotation.roundingMode()));
    }

    @Override
    public void serialize(BigDecimal bigDecimal, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        BigDecimal value = bigDecimal;
        if (value != null) {
            value = value.setScale(this.scaleInfo.getScale(), this.scaleInfo.getRoundingMode());
        }
        jsonGenerator.writeNumber(value);
    }
}

