/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.model;

import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.opps.api.v2.IoceServiceLineData;
import gov.cms.fiss.pricers.opps.core.model.APCCalculationData;
import java.math.BigDecimal;
import java.time.LocalDate;
import lombok.Generated;

public class DeductibleLine {
    private static final BigDecimal ZERO = BigDecimalUtils.ZERO;
    private IoceServiceLineData serviceLine;
    private BigDecimal nationalCoinsurance;
    private BigDecimal minimumCoinsurance;
    private BigDecimal subCharge;
    private BigDecimal apcPayment;
    private BigDecimal wageIndex;
    private Integer apcRank;
    private Integer bloodRank;
    private BigDecimal reimbursementRate;
    private BigDecimal discountRate;
    private Integer serviceUnits = 0;
    private BigDecimal reducedCoinsurance = ZERO;
    private LocalDate dateOfService;

    private DeductibleLine() {
    }

    public DeductibleLine(IoceServiceLineData serviceLineData, APCCalculationData apcData, BigDecimal apcPayment, BigDecimal wageIndex, BigDecimal discountRate) {
        this.setServiceLine(serviceLineData);
        this.setNationalCoinsurance(apcData.getNationalCoinsurance());
        this.setMinimumCoinsurance(apcData.getMinimumCoinsurance());
        this.setSubCharge(serviceLineData.getCoveredCharges());
        this.setApcPayment(apcPayment);
        this.setWageIndex(wageIndex);
        this.setApcRank(apcData.getRank());
        this.setReimbursementRate(apcData.getRate());
        this.setDiscountRate(discountRate);
        this.setServiceUnits(serviceLineData.getApcServiceUnits());
    }

    public DeductibleLine(DeductibleLine copyOf) {
        this.serviceLine = copyOf.getServiceLine();
        this.nationalCoinsurance = copyOf.getNationalCoinsurance();
        this.minimumCoinsurance = copyOf.getMinimumCoinsurance();
        this.subCharge = copyOf.getSubCharge();
        this.apcPayment = copyOf.getApcPayment();
        this.wageIndex = copyOf.getWageIndex();
        this.apcRank = copyOf.getApcRank();
        this.bloodRank = copyOf.getBloodRank();
        this.reimbursementRate = copyOf.getReimbursementRate();
        this.discountRate = copyOf.getDiscountRate();
        this.serviceUnits = copyOf.getServiceUnits();
        this.reducedCoinsurance = copyOf.getReducedCoinsurance();
        this.dateOfService = copyOf.getDateOfService();
    }

    public static int compareByApcRank(DeductibleLine line1, DeductibleLine line2) {
        return line1.getApcRank().compareTo(line2.getApcRank());
    }

    public static int compareByDosThenBloodRank(DeductibleLine line1, DeductibleLine line2) {
        if (line1.getDateOfService().isEqual(line2.getDateOfService())) {
            return line1.getBloodRank() - line2.getBloodRank();
        }
        if (line1.getDateOfService().isBefore(line2.getDateOfService())) {
            return -1;
        }
        return 1;
    }

    @Generated
    public IoceServiceLineData getServiceLine() {
        return this.serviceLine;
    }

    @Generated
    public BigDecimal getNationalCoinsurance() {
        return this.nationalCoinsurance;
    }

    @Generated
    public BigDecimal getMinimumCoinsurance() {
        return this.minimumCoinsurance;
    }

    @Generated
    public BigDecimal getSubCharge() {
        return this.subCharge;
    }

    @Generated
    public BigDecimal getApcPayment() {
        return this.apcPayment;
    }

    @Generated
    public BigDecimal getWageIndex() {
        return this.wageIndex;
    }

    @Generated
    public Integer getApcRank() {
        return this.apcRank;
    }

    @Generated
    public Integer getBloodRank() {
        return this.bloodRank;
    }

    @Generated
    public BigDecimal getReimbursementRate() {
        return this.reimbursementRate;
    }

    @Generated
    public BigDecimal getDiscountRate() {
        return this.discountRate;
    }

    @Generated
    public Integer getServiceUnits() {
        return this.serviceUnits;
    }

    @Generated
    public BigDecimal getReducedCoinsurance() {
        return this.reducedCoinsurance;
    }

    @Generated
    public LocalDate getDateOfService() {
        return this.dateOfService;
    }

    @Generated
    public void setServiceLine(IoceServiceLineData serviceLine) {
        this.serviceLine = serviceLine;
    }

    @Generated
    public void setNationalCoinsurance(BigDecimal nationalCoinsurance) {
        this.nationalCoinsurance = nationalCoinsurance;
    }

    @Generated
    public void setMinimumCoinsurance(BigDecimal minimumCoinsurance) {
        this.minimumCoinsurance = minimumCoinsurance;
    }

    @Generated
    public void setSubCharge(BigDecimal subCharge) {
        this.subCharge = subCharge;
    }

    @Generated
    public void setApcPayment(BigDecimal apcPayment) {
        this.apcPayment = apcPayment;
    }

    @Generated
    public void setWageIndex(BigDecimal wageIndex) {
        this.wageIndex = wageIndex;
    }

    @Generated
    public void setApcRank(Integer apcRank) {
        this.apcRank = apcRank;
    }

    @Generated
    public void setBloodRank(Integer bloodRank) {
        this.bloodRank = bloodRank;
    }

    @Generated
    public void setReimbursementRate(BigDecimal reimbursementRate) {
        this.reimbursementRate = reimbursementRate;
    }

    @Generated
    public void setDiscountRate(BigDecimal discountRate) {
        this.discountRate = discountRate;
    }

    @Generated
    public void setServiceUnits(Integer serviceUnits) {
        this.serviceUnits = serviceUnits;
    }

    @Generated
    public void setReducedCoinsurance(BigDecimal reducedCoinsurance) {
        this.reducedCoinsurance = reducedCoinsurance;
    }

    @Generated
    public void setDateOfService(LocalDate dateOfService) {
        this.dateOfService = dateOfService;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeductibleLine)) {
            return false;
        }
        DeductibleLine other = (DeductibleLine)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$apcRank = this.getApcRank();
        Integer other$apcRank = other.getApcRank();
        if (this$apcRank == null ? other$apcRank != null : !((Object)this$apcRank).equals(other$apcRank)) {
            return false;
        }
        Integer this$bloodRank = this.getBloodRank();
        Integer other$bloodRank = other.getBloodRank();
        if (this$bloodRank == null ? other$bloodRank != null : !((Object)this$bloodRank).equals(other$bloodRank)) {
            return false;
        }
        Integer this$serviceUnits = this.getServiceUnits();
        Integer other$serviceUnits = other.getServiceUnits();
        if (this$serviceUnits == null ? other$serviceUnits != null : !((Object)this$serviceUnits).equals(other$serviceUnits)) {
            return false;
        }
        IoceServiceLineData this$serviceLine = this.getServiceLine();
        IoceServiceLineData other$serviceLine = other.getServiceLine();
        if (this$serviceLine == null ? other$serviceLine != null : !((Object)this$serviceLine).equals(other$serviceLine)) {
            return false;
        }
        BigDecimal this$nationalCoinsurance = this.getNationalCoinsurance();
        BigDecimal other$nationalCoinsurance = other.getNationalCoinsurance();
        if (this$nationalCoinsurance == null ? other$nationalCoinsurance != null : !((Object)this$nationalCoinsurance).equals(other$nationalCoinsurance)) {
            return false;
        }
        BigDecimal this$minimumCoinsurance = this.getMinimumCoinsurance();
        BigDecimal other$minimumCoinsurance = other.getMinimumCoinsurance();
        if (this$minimumCoinsurance == null ? other$minimumCoinsurance != null : !((Object)this$minimumCoinsurance).equals(other$minimumCoinsurance)) {
            return false;
        }
        BigDecimal this$subCharge = this.getSubCharge();
        BigDecimal other$subCharge = other.getSubCharge();
        if (this$subCharge == null ? other$subCharge != null : !((Object)this$subCharge).equals(other$subCharge)) {
            return false;
        }
        BigDecimal this$apcPayment = this.getApcPayment();
        BigDecimal other$apcPayment = other.getApcPayment();
        if (this$apcPayment == null ? other$apcPayment != null : !((Object)this$apcPayment).equals(other$apcPayment)) {
            return false;
        }
        BigDecimal this$wageIndex = this.getWageIndex();
        BigDecimal other$wageIndex = other.getWageIndex();
        if (this$wageIndex == null ? other$wageIndex != null : !((Object)this$wageIndex).equals(other$wageIndex)) {
            return false;
        }
        BigDecimal this$reimbursementRate = this.getReimbursementRate();
        BigDecimal other$reimbursementRate = other.getReimbursementRate();
        if (this$reimbursementRate == null ? other$reimbursementRate != null : !((Object)this$reimbursementRate).equals(other$reimbursementRate)) {
            return false;
        }
        BigDecimal this$discountRate = this.getDiscountRate();
        BigDecimal other$discountRate = other.getDiscountRate();
        if (this$discountRate == null ? other$discountRate != null : !((Object)this$discountRate).equals(other$discountRate)) {
            return false;
        }
        BigDecimal this$reducedCoinsurance = this.getReducedCoinsurance();
        BigDecimal other$reducedCoinsurance = other.getReducedCoinsurance();
        if (this$reducedCoinsurance == null ? other$reducedCoinsurance != null : !((Object)this$reducedCoinsurance).equals(other$reducedCoinsurance)) {
            return false;
        }
        LocalDate this$dateOfService = this.getDateOfService();
        LocalDate other$dateOfService = other.getDateOfService();
        return !(this$dateOfService == null ? other$dateOfService != null : !((Object)this$dateOfService).equals(other$dateOfService));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DeductibleLine;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $apcRank = this.getApcRank();
        result = result * 59 + ($apcRank == null ? 43 : ((Object)$apcRank).hashCode());
        Integer $bloodRank = this.getBloodRank();
        result = result * 59 + ($bloodRank == null ? 43 : ((Object)$bloodRank).hashCode());
        Integer $serviceUnits = this.getServiceUnits();
        result = result * 59 + ($serviceUnits == null ? 43 : ((Object)$serviceUnits).hashCode());
        IoceServiceLineData $serviceLine = this.getServiceLine();
        result = result * 59 + ($serviceLine == null ? 43 : ((Object)$serviceLine).hashCode());
        BigDecimal $nationalCoinsurance = this.getNationalCoinsurance();
        result = result * 59 + ($nationalCoinsurance == null ? 43 : ((Object)$nationalCoinsurance).hashCode());
        BigDecimal $minimumCoinsurance = this.getMinimumCoinsurance();
        result = result * 59 + ($minimumCoinsurance == null ? 43 : ((Object)$minimumCoinsurance).hashCode());
        BigDecimal $subCharge = this.getSubCharge();
        result = result * 59 + ($subCharge == null ? 43 : ((Object)$subCharge).hashCode());
        BigDecimal $apcPayment = this.getApcPayment();
        result = result * 59 + ($apcPayment == null ? 43 : ((Object)$apcPayment).hashCode());
        BigDecimal $wageIndex = this.getWageIndex();
        result = result * 59 + ($wageIndex == null ? 43 : ((Object)$wageIndex).hashCode());
        BigDecimal $reimbursementRate = this.getReimbursementRate();
        result = result * 59 + ($reimbursementRate == null ? 43 : ((Object)$reimbursementRate).hashCode());
        BigDecimal $discountRate = this.getDiscountRate();
        result = result * 59 + ($discountRate == null ? 43 : ((Object)$discountRate).hashCode());
        BigDecimal $reducedCoinsurance = this.getReducedCoinsurance();
        result = result * 59 + ($reducedCoinsurance == null ? 43 : ((Object)$reducedCoinsurance).hashCode());
        LocalDate $dateOfService = this.getDateOfService();
        result = result * 59 + ($dateOfService == null ? 43 : ((Object)$dateOfService).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DeductibleLine(serviceLine=" + this.getServiceLine() + ", nationalCoinsurance=" + this.getNationalCoinsurance() + ", minimumCoinsurance=" + this.getMinimumCoinsurance() + ", subCharge=" + this.getSubCharge() + ", apcPayment=" + this.getApcPayment() + ", wageIndex=" + this.getWageIndex() + ", apcRank=" + this.getApcRank() + ", bloodRank=" + this.getBloodRank() + ", reimbursementRate=" + this.getReimbursementRate() + ", discountRate=" + this.getDiscountRate() + ", serviceUnits=" + this.getServiceUnits() + ", reducedCoinsurance=" + this.getReducedCoinsurance() + ", dateOfService=" + this.getDateOfService() + ")";
    }
}

