/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimPricingRequest;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimPricingResponse;
import gov.cms.fiss.pricers.opps.core.OppsPricerContext;
import java.math.RoundingMode;

public class CalculateDeductibleBloodPercentage
implements CalculationRule<OppsClaimPricingRequest, OppsClaimPricingResponse, OppsPricerContext> {
    @Override
    public void calculate(OppsPricerContext calculationContext) {
        if (BigDecimalUtils.isGreaterThanZero(calculationContext.getBloodProductCharges())) {
            calculationContext.setBloodProductPercentage(calculationContext.getBloodProductCharges().divide(calculationContext.getTotalBloodCharges(), 4, RoundingMode.HALF_UP));
        }
    }
}

