/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimPricingRequest;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimPricingResponse;
import gov.cms.fiss.pricers.opps.core.OppsPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CalculatePassThroughDeviceOffsets
implements CalculationRule<OppsClaimPricingRequest, OppsClaimPricingResponse, OppsPricerContext> {
    @Override
    public void calculate(OppsPricerContext calculationContext) {
        calculationContext.setQnWageAdjustedPassThroughDeviceOffset(this.calculateWageAdjustedOffset(BigDecimalUtils.defaultValue(calculationContext.getClaimData().getPayerOnlyValueCodeOffsets().getApcDeviceOffsetAmountQn()), calculationContext.getWageIndex()));
        calculationContext.setQoWageAdjustedPassThroughDeviceOffset(this.calculateWageAdjustedOffset(BigDecimalUtils.defaultValue(calculationContext.getClaimData().getPayerOnlyValueCodeOffsets().getApcDeviceOffsetAmountQo()), calculationContext.getWageIndex()));
    }

    protected BigDecimal calculateWageAdjustedOffset(BigDecimal valueCodeAmount, BigDecimal wageIndex) {
        return valueCodeAmount.multiply(new BigDecimal(".60")).multiply(wageIndex).add(valueCodeAmount.multiply(new BigDecimal(".40"))).setScale(2, RoundingMode.HALF_UP);
    }
}

