/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.rules.calculate_deductible_lines.calculate_standard_payment;

import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.opps.core.DeductibleLineContext;
import gov.cms.fiss.pricers.opps.core.model.DeductibleLine;
import gov.cms.fiss.pricers.opps.core.model.LineCalculation;
import gov.cms.fiss.pricers.opps.core.rules.calculate_deductible_lines.calculate_standard_payment.AbstractDeductibleLineRule;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class AdjustMaximumNationalReducedCoinsurance
extends AbstractDeductibleLineRule {
    @Override
    public void calculate(DeductibleLineContext calculationContext) {
        LineCalculation lineCalculation = calculationContext.getLineCalculation();
        DeductibleLine deductibleLine = lineCalculation.getDeductibleLine();
        BigDecimal maximumCoinsurance = calculationContext.getPricerContext().getInpatientDeductibleLimit().multiply(new BigDecimal(deductibleLine.getServiceUnits())).multiply(deductibleLine.getDiscountRate()).setScale(2, RoundingMode.HALF_UP);
        lineCalculation.setReducedCoinsurance(deductibleLine.getReducedCoinsurance());
        if (BigDecimalUtils.isGreaterThanZero(lineCalculation.getReducedCoinsurance()) && BigDecimalUtils.isGreaterThan(lineCalculation.getMinimumCoinsurance(), lineCalculation.getReducedCoinsurance())) {
            lineCalculation.setReducedCoinsurance(lineCalculation.getMinimumCoinsurance());
        } else if (BigDecimalUtils.isGreaterThan(lineCalculation.getNationalCoinsurance(), lineCalculation.getReducedCoinsurance()) && BigDecimalUtils.isGreaterThan(lineCalculation.getReducedCoinsurance(), lineCalculation.getMinimumCoinsurance()) && BigDecimalUtils.isGreaterThan(lineCalculation.getReducedCoinsurance(), maximumCoinsurance)) {
            lineCalculation.setReimbursement(lineCalculation.getReimbursement().add(lineCalculation.getReducedCoinsurance().subtract(maximumCoinsurance)));
        }
        if (BigDecimalUtils.isGreaterThan(lineCalculation.getNationalCoinsurance(), maximumCoinsurance) && BigDecimalUtils.isZero(lineCalculation.getReducedCoinsurance())) {
            lineCalculation.setReimbursement(lineCalculation.getReimbursement().add(lineCalculation.getNationalCoinsurance().subtract(maximumCoinsurance)));
            lineCalculation.setNationalCoinsurance(maximumCoinsurance);
        }
    }
}

