/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.rules.calculate_deductible_lines.calculate_standard_payment;

import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.opps.core.DeductibleLineContext;
import gov.cms.fiss.pricers.opps.core.OppsPricerContext;
import gov.cms.fiss.pricers.opps.core.codes.PaymentAdjustmentFlag;
import gov.cms.fiss.pricers.opps.core.model.DeductibleLine;
import gov.cms.fiss.pricers.opps.core.model.LineCalculation;
import gov.cms.fiss.pricers.opps.core.rules.calculate_deductible_lines.calculate_standard_payment.AbstractDeductibleLineRule;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CalculateDeviceCredit
extends AbstractDeductibleLineRule {
    @Override
    public void calculate(DeductibleLineContext calculationContext) {
        OppsPricerContext pricerContext = calculationContext.getPricerContext();
        LineCalculation lineCalculation = calculationContext.getLineCalculation();
        BigDecimal claimDeviceCreditAmount = pricerContext.getClaimDeviceCreditAmount();
        BigDecimal totalDeviceCreditPayments = pricerContext.getTotalDeviceCreditPayments();
        if (PaymentAdjustmentFlag.DEVICE_CREDIT_17.is(lineCalculation.getLineInput().getPaymentAdjustmentFlags())) {
            if (BigDecimalUtils.isLessThanOrEqualToZero(claimDeviceCreditAmount) || BigDecimalUtils.isLessThanOrEqualToZero(totalDeviceCreditPayments)) {
                return;
            }
            DeductibleLine deductibleLine = lineCalculation.getDeductibleLine();
            BigDecimal deviceCreditPaymentRate = deductibleLine.getApcPayment().divide(totalDeviceCreditPayments, 4, RoundingMode.HALF_UP);
            lineCalculation.setDeviceCreditAmount(claimDeviceCreditAmount.multiply(deviceCreditPaymentRate).setScale(2, RoundingMode.HALF_UP));
        }
    }
}

