/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.rules.calculate_deductible_lines.calculate_standard_payment.calculate_status_indicator_payments;

import gov.cms.fiss.pricers.common.api.OutpatientProviderData;
import gov.cms.fiss.pricers.opps.core.DeductibleLineContext;
import gov.cms.fiss.pricers.opps.core.OppsPricerContext;
import gov.cms.fiss.pricers.opps.core.codes.StatusIndicator;
import gov.cms.fiss.pricers.opps.core.model.LineCalculation;
import gov.cms.fiss.pricers.opps.core.rules.calculate_deductible_lines.calculate_standard_payment.calculate_status_indicator_payments.AbstractStatusIndicatorPayments2024;
import java.util.stream.Stream;

public class ProceduresServicesAndVisits
extends AbstractStatusIndicatorPayments2024 {
    @Override
    public boolean shouldExecute(DeductibleLineContext context) {
        return this.isProcedureServiceOrVisit(context.getStatusIndicator());
    }

    @Override
    public void calculate(DeductibleLineContext calculationContext) {
        LineCalculation lineCalculation = calculationContext.getLineCalculation();
        OppsPricerContext pricerContext = calculationContext.getPricerContext();
        OutpatientProviderData providerData = pricerContext.getProviderData();
        String billType = pricerContext.getClaimData().getTypeOfBill();
        this.calculateWageAdjustedPaymentAndSchAdj(pricerContext, providerData, lineCalculation, billType);
        pricerContext.setBeneficiaryDeductible(this.calculateBeneficiaryDeductible(lineCalculation, pricerContext.getBeneficiaryDeductible()));
    }

    private boolean isProcedureServiceOrVisit(String statusIndicator) {
        return Stream.of(StatusIndicator.P_PARTIAL_HOSPITALIZATION, StatusIndicator.S_PROCEDURE_NOT_DISCOUNTED, StatusIndicator.T_PROCEDURE_REDUCIBLE, StatusIndicator.V_EMERGENCY, StatusIndicator.X_ANCILLARY, StatusIndicator.J1_COMPREHENSIVE_APC_OUTPATIENT, StatusIndicator.J2_COMPREHENSIVE_APC_HOSPITAL).anyMatch(si -> si.is(statusIndicator));
    }
}

