/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.rules.initialize_and_validate_claim;

import gov.cms.fiss.pricers.common.api.OutpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimData;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimPricingRequest;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimPricingResponse;
import gov.cms.fiss.pricers.opps.core.OppsPricerContext;
import gov.cms.fiss.pricers.opps.core.codes.ReturnCode;
import java.time.LocalDate;
import org.apache.commons.lang3.StringUtils;

public class SetInitialValues
implements CalculationRule<OppsClaimPricingRequest, OppsClaimPricingResponse, OppsPricerContext> {
    @Override
    public void calculate(OppsPricerContext calculationContext) {
        OppsClaimData claimData = calculationContext.getClaimData();
        OutpatientProviderData providerData = calculationContext.getProviderData();
        ((OppsClaimPricingResponse)calculationContext.getOutput()).setCalculationVersion(calculationContext.getCalculationVersion());
        if (this.isBadServiceDate(claimData.getServiceFromDate(), providerData)) {
            calculationContext.applyClaimReturnCode(ReturnCode.SERVICE_FROM_DATE_NOT_IN_RANGE_54);
            return;
        }
        providerData.setPaymentCbsa(StringUtils.trimToEmpty(providerData.getPaymentCbsa()));
        calculationContext.setBeneficiaryDeductible(claimData.getPatientDeductible());
        calculationContext.setBeneficiaryBloodPintsUsed(claimData.getBloodPintsRemaining());
    }

    protected boolean isBadServiceDate(LocalDate serviceDate, OutpatientProviderData providerData) {
        LocalDate terminationDate = providerData.getTerminationDate();
        return serviceDate.isBefore(providerData.getEffectiveDate()) || terminationDate != null && serviceDate.isAfter(terminationDate);
    }
}

