/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.rules.initialize_and_validate_claim;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimPricingRequest;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimPricingResponse;
import gov.cms.fiss.pricers.opps.core.OppsPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class WageIndexQuartileAdjustment
implements CalculationRule<OppsClaimPricingRequest, OppsClaimPricingResponse, OppsPricerContext> {
    @Override
    public void calculate(OppsPricerContext calculationContext) {
        BigDecimal wageIndex = calculationContext.getWageIndex();
        BigDecimal quartileWageIndex = calculationContext.getWageIndexQuartile();
        if (BigDecimalUtils.isGreaterThan(quartileWageIndex, wageIndex)) {
            BigDecimal adjustedWageIndex = quartileWageIndex.subtract(wageIndex).divide(new BigDecimal("2.00"), RoundingMode.HALF_UP).add(wageIndex);
            calculationContext.setWageIndex(adjustedWageIndex);
        }
    }
}

