/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.rules.initialize_and_validate_lines;

import gov.cms.fiss.pricers.opps.api.v2.IoceServiceLineData;
import gov.cms.fiss.pricers.opps.core.OppsPricerContext;
import gov.cms.fiss.pricers.opps.core.ServiceLineContext;
import gov.cms.fiss.pricers.opps.core.codes.PaymentAdjustmentFlag;
import gov.cms.fiss.pricers.opps.core.codes.PaymentMethodFlag;
import gov.cms.fiss.pricers.opps.core.codes.ReturnCode;
import gov.cms.fiss.pricers.opps.core.codes.StatusIndicator;
import gov.cms.fiss.pricers.opps.core.rules.initialize_and_validate_lines.AbstractLineCalculationRule;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class PerformApcAdjustments
extends AbstractLineCalculationRule {
    @Override
    public void calculate(ServiceLineContext calculationContext) {
        OppsPricerContext pricerContext = calculationContext.getPricerContext();
        IoceServiceLineData ioceServiceLine = (IoceServiceLineData)calculationContext.getInput();
        List<String> paymentAdjustmentFlags = ioceServiceLine.getPaymentAdjustmentFlags();
        String paymentMethodFlag = ioceServiceLine.getPaymentMethodFlag();
        if (this.isFeeScheduleReducible(paymentMethodFlag)) {
            pricerContext.setApcPayment(pricerContext.getApcPayment().multiply(pricerContext.getPhysicianFeeScheduleReduction()).setScale(2, RoundingMode.HALF_UP));
        }
        if (OppsPricerContext.isSection603(paymentMethodFlag) || PaymentMethodFlag.RADIATION_ONCOLOGY_MODEL_B.is(paymentMethodFlag)) {
            BigDecimal coinsurance = pricerContext.getApcPayment().multiply(OppsPricerContext.PFS_REDUCTION_COINSURANCE_RATE).setScale(2, RoundingMode.HALF_UP);
            pricerContext.getApcCalculationData().setRate(OppsPricerContext.PFS_REDUCTION_REIMBURSEMENT_RATE);
            pricerContext.getApcCalculationData().setMinimumCoinsurance(coinsurance);
            pricerContext.getApcCalculationData().setNationalCoinsurance(coinsurance);
        }
        if (PaymentMethodFlag.OFF_CAMPUS_CLINIC_A.is(ioceServiceLine.getPaymentMethodFlag())) {
            pricerContext.setApcPayment(pricerContext.getApcPayment().multiply(pricerContext.getPaymentMethodFlagAReduction()).setScale(2, RoundingMode.HALF_UP));
        }
        if (PaymentAdjustmentFlag.CT_SCAN_14.is(paymentAdjustmentFlags)) {
            pricerContext.setApcPayment(pricerContext.getApcPayment().multiply(pricerContext.getCTScanReduction()).setScale(2, RoundingMode.HALF_UP));
        }
        if (this.isXRayAdjustment(paymentAdjustmentFlags)) {
            pricerContext.setApcPayment(pricerContext.getApcPayment().multiply(pricerContext.getXRayFilmReduction()).setScale(2, RoundingMode.HALF_UP));
        }
        if (this.isComputedRadiologyAdjustment(paymentAdjustmentFlags)) {
            pricerContext.setApcPayment(pricerContext.getApcPayment().multiply(pricerContext.getXRayCRTReduction()).setScale(2, RoundingMode.HALF_UP));
        }
        if (this.isEligibleForAPCReduction(ioceServiceLine, pricerContext.getProviderData().getHospitalQualityIndicator())) {
            pricerContext.setApcPayment(pricerContext.getApcPayment().multiply(pricerContext.getApcQualityReduction()).setScale(2, RoundingMode.HALF_UP));
            calculationContext.applyLineReturnCode(ReturnCode.ABSENT_QUALITY_REPORTING_11);
        }
    }

    private boolean isEligibleForAPCReduction(String statusIndicator, String apc) {
        int numericAPC = Integer.parseInt(apc);
        if (!OppsPricerContext.isSeparatelyPayable(statusIndicator) || apc.length() != 5) {
            return false;
        }
        if (StatusIndicator.S_PROCEDURE_NOT_DISCOUNTED.is(statusIndicator)) {
            return !(numericAPC >= 1491 && numericAPC <= 1537 || numericAPC >= 1575 && numericAPC <= 1585 || numericAPC >= 1901 && numericAPC <= 1908 || numericAPC >= 6073 && numericAPC <= 6105);
        }
        if (StatusIndicator.T_PROCEDURE_REDUCIBLE.is(statusIndicator)) {
            return !(numericAPC >= 1539 && numericAPC <= 1574 || numericAPC >= 1589 && numericAPC <= 1599 || numericAPC >= 1901 && numericAPC <= 1908);
        }
        return true;
    }

    protected boolean isEligibleForAPCReduction(IoceServiceLineData ioceServiceLine, String hospitalQualityIndicator) {
        return !OppsPricerContext.isSection603(ioceServiceLine.getPaymentMethodFlag()) && !PaymentMethodFlag.RADIATION_ONCOLOGY_MODEL_B.is(ioceServiceLine.getPaymentMethodFlag()) && StringUtils.isEmpty(StringUtils.trimToEmpty(hospitalQualityIndicator)) && this.isEligibleForAPCReduction(ioceServiceLine.getStatusIndicator(), ioceServiceLine.getPaymentApc());
    }

    private boolean isXRayAdjustment(List<String> paymentAdjustmentFlags) {
        return Stream.of(PaymentAdjustmentFlag.X_RAY_21, PaymentAdjustmentFlag.X_RAY_NO_COINSURANCE_23).anyMatch(paf -> paf.is(paymentAdjustmentFlags));
    }

    private boolean isComputedRadiologyAdjustment(List<String> paymentAdjustmentFlag) {
        return Stream.of(PaymentAdjustmentFlag.COMPUTED_RADIOLOGY_22, PaymentAdjustmentFlag.COMPUTED_RADIOLOGY_NO_COINSURANCE_24).anyMatch(paf -> paf.is(paymentAdjustmentFlag));
    }

    private boolean isFeeScheduleReducible(String paymentMethodFlag) {
        return Stream.of(PaymentMethodFlag.SECTION603_REDUCTION_8, PaymentMethodFlag.CONTRACTOR_BYPASS_SECTION_603_REDUCTION_Y).anyMatch(pmf -> pmf.is(paymentMethodFlag));
    }
}

