/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.opps.OppsPricerConfiguration;
import gov.cms.fiss.pricers.opps.core.tables.ApcRateHistoryEntry;
import gov.cms.fiss.pricers.opps.core.tables.ApcRateHistoryLookupGenerator;
import gov.cms.fiss.pricers.opps.core.tables.BloodRankEntry;
import gov.cms.fiss.pricers.opps.core.tables.BloodRankLookupGenerator;
import gov.cms.fiss.pricers.opps.core.tables.CbsaWageIndexEntry;
import gov.cms.fiss.pricers.opps.core.tables.CbsaWageIndexLookupGenerator;
import gov.cms.fiss.pricers.opps.core.tables.OutMigrationAdjustmentEntry;
import gov.cms.fiss.pricers.opps.core.tables.OutMigrationAdjustmentLookupGenerator;
import gov.cms.fiss.pricers.opps.core.tables.PreviousYearWageIndexEntry;
import gov.cms.fiss.pricers.opps.core.tables.PreviousYearWageIndexLookupGenerator;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;

public class DataTables {
    private static final Map<Integer, DataTables> YEAR_LOOKUP = new ConcurrentHashMap<Integer, DataTables>();
    private final Map<String, NavigableMap<LocalDate, ApcRateHistoryEntry>> apcRateHistory;
    private final Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> cbsaTable;
    private final Map<Integer, NavigableMap<LocalDate, OutMigrationAdjustmentEntry>> outMigrationAdjustmentMap;
    private final Map<String, PreviousYearWageIndexEntry> previousYearWageIndexMap;
    private final Map<String, BloodRankEntry> bloodRankMap;

    public DataTables(Map<String, NavigableMap<LocalDate, ApcRateHistoryEntry>> apcRateHistory, Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> cbsaTable, Map<String, BloodRankEntry> bloodRankMap, Map<Integer, NavigableMap<LocalDate, OutMigrationAdjustmentEntry>> outMigrationAdjustmentMap, Map<String, PreviousYearWageIndexEntry> previousYearWageIndexMap) {
        this.apcRateHistory = apcRateHistory;
        this.cbsaTable = cbsaTable;
        this.bloodRankMap = bloodRankMap;
        this.outMigrationAdjustmentMap = outMigrationAdjustmentMap;
        this.previousYearWageIndexMap = previousYearWageIndexMap;
    }

    public static DataTables forYear(int pricerYear) {
        return YEAR_LOOKUP.get(pricerYear);
    }

    public static void loadDataTables(OppsPricerConfiguration pricerConfiguration) {
        CsvIngestionConfiguration csvIngestionConfiguration = pricerConfiguration.getCsvIngestionConfiguration();
        ApcRateHistoryLookupGenerator apcRateHistoryLookupGenerator = new ApcRateHistoryLookupGenerator(csvIngestionConfiguration);
        CbsaWageIndexLookupGenerator cbsaWageIndexLookupGenerator = new CbsaWageIndexLookupGenerator(csvIngestionConfiguration);
        BloodRankLookupGenerator bloodRankLookupGenerator = new BloodRankLookupGenerator(csvIngestionConfiguration);
        OutMigrationAdjustmentLookupGenerator outMigrationAdjustmentLookupGenerator = new OutMigrationAdjustmentLookupGenerator(csvIngestionConfiguration);
        Map<String, PreviousYearWageIndexEntry> previousYearWageIndexMap = pricerConfiguration.getPreviousYearWageIndexOverride() != null ? new PreviousYearWageIndexLookupGenerator(csvIngestionConfiguration).generate(pricerConfiguration.getPreviousYearWageIndexOverride()) : new PreviousYearWageIndexLookupGenerator(csvIngestionConfiguration).generate();
        for (int pricerYear : pricerConfiguration.getSupportedYears()) {
            YEAR_LOOKUP.put(pricerYear, new DataTables(apcRateHistoryLookupGenerator.generate(pricerYear), cbsaWageIndexLookupGenerator.generate(pricerYear), bloodRankLookupGenerator.generate(pricerYear), outMigrationAdjustmentLookupGenerator.generate(pricerYear), previousYearWageIndexMap));
        }
    }

    public Map<String, NavigableMap<LocalDate, ApcRateHistoryEntry>> getApcRateHistoryTable() {
        return this.apcRateHistory;
    }

    public NavigableMap<LocalDate, ApcRateHistoryEntry> getApcRateHistoryEntry(String paymentApc) {
        return this.apcRateHistory.get(paymentApc);
    }

    public NavigableMap<LocalDate, CbsaWageIndexEntry> getCbsaWageIndexEntries(String cbsa) {
        return this.cbsaTable.get(cbsa);
    }

    public Integer getBloodRank(String hcpcsCode) {
        BloodRankEntry entry = this.bloodRankMap.get(hcpcsCode);
        return entry == null ? null : entry.getRank();
    }

    public boolean isBloodHcpcsDeductible(String hcpcs) {
        return this.bloodRankMap.containsKey(hcpcs);
    }

    public OutMigrationAdjustmentEntry getOutMigrationAdjustment(int countyCode, LocalDate serviceDate) {
        NavigableMap<LocalDate, OutMigrationAdjustmentEntry> map = this.outMigrationAdjustmentMap.get(countyCode);
        if (map == null) {
            return null;
        }
        Map.Entry<LocalDate, OutMigrationAdjustmentEntry> mapEntry = map.floorEntry(serviceDate);
        if (mapEntry == null) {
            return null;
        }
        OutMigrationAdjustmentEntry entry = mapEntry.getValue();
        if (entry.getEffectiveDate().getYear() == serviceDate.getYear()) {
            return entry.copyBuilder().build();
        }
        return null;
    }

    public BigDecimal getPriorYearWageIndex(String providerNumber) {
        PreviousYearWageIndexEntry entry = this.previousYearWageIndexMap.get(providerNumber);
        if (entry == null) {
            return null;
        }
        return entry.getWageIndex();
    }

    @Generated
    public Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> getCbsaTable() {
        return this.cbsaTable;
    }
}

