/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.web.conf;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.dropwizard.core.setup.Environment;
import io.dropwizard.jetty.setup.ServletEnvironment;
import io.dropwizard.util.Duration;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.FilterRegistration;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jetty.servlets.CrossOriginFilter;

public class CorsFilterFactory {
    @JsonProperty
    private List<String> allowedOrigins;
    @JsonProperty
    private List<String> allowedTimingOrigins;
    @JsonProperty
    private List<String> allowedMethods;
    @JsonProperty
    private List<String> allowedHeaders;
    @JsonProperty
    private Duration preflightMaxAge;
    @JsonProperty
    private Boolean allowCredentials;
    @JsonProperty
    private List<String> exposedHeaders;
    @JsonProperty
    private Boolean chainPreflight;

    public List<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public void setAllowedOrigins(List<String> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
    }

    public List<String> getAllowedTimingOrigins() {
        return this.allowedTimingOrigins;
    }

    public void setAllowedTimingOrigins(List<String> allowedTimingOrigins) {
        this.allowedTimingOrigins = allowedTimingOrigins;
    }

    public List<String> getAllowedMethods() {
        return this.allowedMethods;
    }

    public void setAllowedMethods(List<String> allowedMethods) {
        this.allowedMethods = allowedMethods;
    }

    public List<String> getAllowedHeaders() {
        return this.allowedHeaders;
    }

    public void setAllowedHeaders(List<String> allowedHeaders) {
        this.allowedHeaders = allowedHeaders;
    }

    public Duration getPreflightMaxAge() {
        return this.preflightMaxAge;
    }

    public void setPreflightMaxAge(Duration preflightMaxAge) {
        this.preflightMaxAge = preflightMaxAge;
    }

    public boolean isAllowCredentials() {
        return this.allowCredentials;
    }

    public void setAllowCredentials(boolean allowCredentials) {
        this.allowCredentials = allowCredentials;
    }

    public List<String> getExposedHeaders() {
        return this.exposedHeaders;
    }

    public void setExposedHeaders(List<String> exposedHeaders) {
        this.exposedHeaders = exposedHeaders;
    }

    public boolean isChainPreflight() {
        return this.chainPreflight;
    }

    public void setChainPreflight(boolean chainPreflight) {
        this.chainPreflight = chainPreflight;
    }

    public void build(Environment environment, String urlPattern) {
        HashMap<String, String> builder = new HashMap<String, String>();
        if (this.allowedOrigins != null && !this.allowedOrigins.isEmpty()) {
            builder.put("allowedOrigins", String.join((CharSequence)",", this.allowedOrigins));
        }
        if (this.allowedTimingOrigins != null && !this.allowedTimingOrigins.isEmpty()) {
            builder.put("allowedTimingOrigins", String.join((CharSequence)",", this.allowedTimingOrigins));
        }
        if (this.allowedMethods != null && !this.allowedMethods.isEmpty()) {
            builder.put("allowedMethods", String.join((CharSequence)",", this.allowedMethods));
        }
        if (this.allowedHeaders != null && !this.allowedHeaders.isEmpty()) {
            builder.put("allowedHeaders", String.join((CharSequence)",", this.allowedHeaders));
        }
        if (this.preflightMaxAge != null) {
            builder.put("preflightMaxAge", String.valueOf(this.preflightMaxAge.toSeconds()));
        }
        if (this.allowCredentials != null) {
            builder.put("allowCredentials", String.valueOf(this.allowCredentials));
        }
        if (this.exposedHeaders != null && !this.exposedHeaders.isEmpty()) {
            builder.put("exposedHeaders", String.join((CharSequence)",", this.exposedHeaders));
        }
        if (this.chainPreflight != null) {
            builder.put("chainPreflight", String.valueOf(this.chainPreflight));
        }
        ServletEnvironment servlets = environment.servlets();
        FilterRegistration.Dynamic cors = servlets.addFilter("cross-origin-filter", CrossOriginFilter.class);
        cors.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), true, urlPattern);
        cors.setInitParameters(Collections.unmodifiableMap(builder));
    }
}

