/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.api.v2;

import gov.cms.fiss.pricers.common.api.PaymentData;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithTwoFractionDigits;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.opps.api.v2.ServiceLinePaymentData;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.util.List;
import lombok.Generated;

@Schema(description="The claim payment result.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="A-ADDITIONAL-VARIABLES", value="<structure>")})})
public class OppsPaymentData
extends PaymentData {
    @BigDecimalScale
    @NotNull
    @Schema(description="The total of all line blood deductible amounts.", example="39084.23", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="A-BLOOD-DEDUCT-DUE", value="PIC 9(05)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal bloodDeductibleDue = BigDecimalUtils.ZERO;
    @Max(value=9L)
    @Min(value=0L)
    @NotNull
    @Schema(description="The number of blood pints used for blood deductibles on claim.", example="2", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="A-BLOOD-PINTS-USED", value="PIC 9(01)")})})
    private @Max(value=9L) @Min(value=0L) @NotNull int bloodPintsUsed;
    @BigDecimalScale
    @NotNull
    @Schema(description="The total of all line device credit amounts.", example="97834.47", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="A-DEVICE-CREDIT-QD", value="PIC 9(09)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal deviceCreditQd = BigDecimalUtils.ZERO;
    @ArraySchema(arraySchema=@Schema(description="The service line payments.", required=true), uniqueItems=true, extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="A-LINE-ITEMS", value="<structure>")})})
    @NotEmpty
    @Size(max=450)
    @Valid
    private @NotEmpty @Size(max=450) @Valid List<@NotNull ServiceLinePaymentData> serviceLinePayments;
    @BigDecimalScale
    @NotNull
    @Schema(description="The total of all line charge amounts.", example="17023.23", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="A-TOT-CLM-CHRG", value="PIC 9(09)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal totalClaimCharges = BigDecimalUtils.ZERO;
    @BigDecimalScale
    @NotNull
    @Schema(description="The total of all line deductible amounts.", example="198.00", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="A-TOTAL-CLM-DEDUCT", value="PIC 9(03)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal totalClaimDeductible = BigDecimalUtils.ZERO;
    @BigDecimalScale
    @NotNull
    @Schema(description="The total of all line outlier payment amounts.", example="1456.62", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="A-OUTLIER-PYMT", value="PIC 9(09)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal totalClaimOutlierPayment = BigDecimalUtils.ZERO;

    @Generated
    public BigDecimal getBloodDeductibleDue() {
        return this.bloodDeductibleDue;
    }

    @Generated
    public int getBloodPintsUsed() {
        return this.bloodPintsUsed;
    }

    @Generated
    public BigDecimal getDeviceCreditQd() {
        return this.deviceCreditQd;
    }

    @Generated
    public List<@NotNull ServiceLinePaymentData> getServiceLinePayments() {
        return this.serviceLinePayments;
    }

    @Generated
    public BigDecimal getTotalClaimCharges() {
        return this.totalClaimCharges;
    }

    @Generated
    public BigDecimal getTotalClaimDeductible() {
        return this.totalClaimDeductible;
    }

    @Generated
    public BigDecimal getTotalClaimOutlierPayment() {
        return this.totalClaimOutlierPayment;
    }

    @Generated
    public void setBloodDeductibleDue(BigDecimal bloodDeductibleDue) {
        this.bloodDeductibleDue = bloodDeductibleDue;
    }

    @Generated
    public void setBloodPintsUsed(int bloodPintsUsed) {
        this.bloodPintsUsed = bloodPintsUsed;
    }

    @Generated
    public void setDeviceCreditQd(BigDecimal deviceCreditQd) {
        this.deviceCreditQd = deviceCreditQd;
    }

    @Generated
    public void setServiceLinePayments(List<@NotNull ServiceLinePaymentData> serviceLinePayments) {
        this.serviceLinePayments = serviceLinePayments;
    }

    @Generated
    public void setTotalClaimCharges(BigDecimal totalClaimCharges) {
        this.totalClaimCharges = totalClaimCharges;
    }

    @Generated
    public void setTotalClaimDeductible(BigDecimal totalClaimDeductible) {
        this.totalClaimDeductible = totalClaimDeductible;
    }

    @Generated
    public void setTotalClaimOutlierPayment(BigDecimal totalClaimOutlierPayment) {
        this.totalClaimOutlierPayment = totalClaimOutlierPayment;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OppsPaymentData)) {
            return false;
        }
        OppsPaymentData other = (OppsPaymentData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getBloodPintsUsed() != other.getBloodPintsUsed()) {
            return false;
        }
        BigDecimal this$bloodDeductibleDue = this.getBloodDeductibleDue();
        BigDecimal other$bloodDeductibleDue = other.getBloodDeductibleDue();
        if (this$bloodDeductibleDue == null ? other$bloodDeductibleDue != null : !((Object)this$bloodDeductibleDue).equals(other$bloodDeductibleDue)) {
            return false;
        }
        BigDecimal this$deviceCreditQd = this.getDeviceCreditQd();
        BigDecimal other$deviceCreditQd = other.getDeviceCreditQd();
        if (this$deviceCreditQd == null ? other$deviceCreditQd != null : !((Object)this$deviceCreditQd).equals(other$deviceCreditQd)) {
            return false;
        }
        List<ServiceLinePaymentData> this$serviceLinePayments = this.getServiceLinePayments();
        List<ServiceLinePaymentData> other$serviceLinePayments = other.getServiceLinePayments();
        if (this$serviceLinePayments == null ? other$serviceLinePayments != null : !((Object)this$serviceLinePayments).equals(other$serviceLinePayments)) {
            return false;
        }
        BigDecimal this$totalClaimCharges = this.getTotalClaimCharges();
        BigDecimal other$totalClaimCharges = other.getTotalClaimCharges();
        if (this$totalClaimCharges == null ? other$totalClaimCharges != null : !((Object)this$totalClaimCharges).equals(other$totalClaimCharges)) {
            return false;
        }
        BigDecimal this$totalClaimDeductible = this.getTotalClaimDeductible();
        BigDecimal other$totalClaimDeductible = other.getTotalClaimDeductible();
        if (this$totalClaimDeductible == null ? other$totalClaimDeductible != null : !((Object)this$totalClaimDeductible).equals(other$totalClaimDeductible)) {
            return false;
        }
        BigDecimal this$totalClaimOutlierPayment = this.getTotalClaimOutlierPayment();
        BigDecimal other$totalClaimOutlierPayment = other.getTotalClaimOutlierPayment();
        return !(this$totalClaimOutlierPayment == null ? other$totalClaimOutlierPayment != null : !((Object)this$totalClaimOutlierPayment).equals(other$totalClaimOutlierPayment));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OppsPaymentData;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getBloodPintsUsed();
        BigDecimal $bloodDeductibleDue = this.getBloodDeductibleDue();
        result = result * 59 + ($bloodDeductibleDue == null ? 43 : ((Object)$bloodDeductibleDue).hashCode());
        BigDecimal $deviceCreditQd = this.getDeviceCreditQd();
        result = result * 59 + ($deviceCreditQd == null ? 43 : ((Object)$deviceCreditQd).hashCode());
        List<ServiceLinePaymentData> $serviceLinePayments = this.getServiceLinePayments();
        result = result * 59 + ($serviceLinePayments == null ? 43 : ((Object)$serviceLinePayments).hashCode());
        BigDecimal $totalClaimCharges = this.getTotalClaimCharges();
        result = result * 59 + ($totalClaimCharges == null ? 43 : ((Object)$totalClaimCharges).hashCode());
        BigDecimal $totalClaimDeductible = this.getTotalClaimDeductible();
        result = result * 59 + ($totalClaimDeductible == null ? 43 : ((Object)$totalClaimDeductible).hashCode());
        BigDecimal $totalClaimOutlierPayment = this.getTotalClaimOutlierPayment();
        result = result * 59 + ($totalClaimOutlierPayment == null ? 43 : ((Object)$totalClaimOutlierPayment).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "OppsPaymentData(bloodDeductibleDue=" + this.getBloodDeductibleDue() + ", bloodPintsUsed=" + this.getBloodPintsUsed() + ", deviceCreditQd=" + this.getDeviceCreditQd() + ", serviceLinePayments=" + this.getServiceLinePayments() + ", totalClaimCharges=" + this.getTotalClaimCharges() + ", totalClaimDeductible=" + this.getTotalClaimDeductible() + ", totalClaimOutlierPayment=" + this.getTotalClaimOutlierPayment() + ")";
    }

    @Generated
    public OppsPaymentData() {
    }
}

