/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.api.v2;

import gov.cms.fiss.pricers.common.api.ReturnCodeData;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithTwoFractionDigits;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import lombok.Generated;

@Schema(description="The calculated results for a service line.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="A-LINE-ITEMS", value="<structure>")})})
public class ServiceLinePaymentData {
    @BigDecimalScale
    @NotNull
    @Schema(description="The blood deductible amount.", example="39084.23", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="A-BLOOD-LN-DEDUCT", value="PIC 9(05)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal bloodDeductible = BigDecimalUtils.ZERO;
    @BigDecimalScale
    @NotNull
    @Schema(description="The adjusted coinsurance amount.", example="76834.98", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="A-ADJ-COIN", value="PIC 9(09)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal coinsuranceAmount = BigDecimalUtils.ZERO;
    @Max(value=450L)
    @Min(value=1L)
    @NotNull
    @Schema(description="The line number corresponding to the IOCE service line that was priced.", example="2")
    private @Max(value=450L) @Min(value=1L) @NotNull int lineNumber;
    @BigDecimalScale
    @NotNull
    @Schema(description="The line payment.", example="108975.47", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="A-LITEM-PYMT", value="PIC 9(09)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal payment = BigDecimalUtils.ZERO;
    @BigDecimalScale
    @NotNull
    @Schema(description="The reduced coinsurance amount.", example="65434.58", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="A-RED-COIN", value="PIC 9(09)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal reducedCoinsurance = BigDecimalUtils.ZERO;
    @BigDecimalScale
    @NotNull
    @Schema(description="The reimbursement amount.", example="89734.47", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="A-LITEM-REIM", value="PIC 9(09)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal reimbursementAmount = BigDecimalUtils.ZERO;
    @NotNull
    @Valid
    private ReturnCodeData returnCode;
    @BigDecimalScale
    @NotNull
    @Schema(description="The deductible amount.", example="983.00", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="A-TOTAL-LN-DEDUCT", value="PIC 9(03)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal totalDeductible = BigDecimalUtils.ZERO;

    @Generated
    public BigDecimal getBloodDeductible() {
        return this.bloodDeductible;
    }

    @Generated
    public BigDecimal getCoinsuranceAmount() {
        return this.coinsuranceAmount;
    }

    @Generated
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Generated
    public BigDecimal getPayment() {
        return this.payment;
    }

    @Generated
    public BigDecimal getReducedCoinsurance() {
        return this.reducedCoinsurance;
    }

    @Generated
    public BigDecimal getReimbursementAmount() {
        return this.reimbursementAmount;
    }

    @Generated
    public ReturnCodeData getReturnCode() {
        return this.returnCode;
    }

    @Generated
    public BigDecimal getTotalDeductible() {
        return this.totalDeductible;
    }

    @Generated
    public void setBloodDeductible(BigDecimal bloodDeductible) {
        this.bloodDeductible = bloodDeductible;
    }

    @Generated
    public void setCoinsuranceAmount(BigDecimal coinsuranceAmount) {
        this.coinsuranceAmount = coinsuranceAmount;
    }

    @Generated
    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    @Generated
    public void setPayment(BigDecimal payment) {
        this.payment = payment;
    }

    @Generated
    public void setReducedCoinsurance(BigDecimal reducedCoinsurance) {
        this.reducedCoinsurance = reducedCoinsurance;
    }

    @Generated
    public void setReimbursementAmount(BigDecimal reimbursementAmount) {
        this.reimbursementAmount = reimbursementAmount;
    }

    @Generated
    public void setReturnCode(ReturnCodeData returnCode) {
        this.returnCode = returnCode;
    }

    @Generated
    public void setTotalDeductible(BigDecimal totalDeductible) {
        this.totalDeductible = totalDeductible;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceLinePaymentData)) {
            return false;
        }
        ServiceLinePaymentData other = (ServiceLinePaymentData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLineNumber() != other.getLineNumber()) {
            return false;
        }
        BigDecimal this$bloodDeductible = this.getBloodDeductible();
        BigDecimal other$bloodDeductible = other.getBloodDeductible();
        if (this$bloodDeductible == null ? other$bloodDeductible != null : !((Object)this$bloodDeductible).equals(other$bloodDeductible)) {
            return false;
        }
        BigDecimal this$coinsuranceAmount = this.getCoinsuranceAmount();
        BigDecimal other$coinsuranceAmount = other.getCoinsuranceAmount();
        if (this$coinsuranceAmount == null ? other$coinsuranceAmount != null : !((Object)this$coinsuranceAmount).equals(other$coinsuranceAmount)) {
            return false;
        }
        BigDecimal this$payment = this.getPayment();
        BigDecimal other$payment = other.getPayment();
        if (this$payment == null ? other$payment != null : !((Object)this$payment).equals(other$payment)) {
            return false;
        }
        BigDecimal this$reducedCoinsurance = this.getReducedCoinsurance();
        BigDecimal other$reducedCoinsurance = other.getReducedCoinsurance();
        if (this$reducedCoinsurance == null ? other$reducedCoinsurance != null : !((Object)this$reducedCoinsurance).equals(other$reducedCoinsurance)) {
            return false;
        }
        BigDecimal this$reimbursementAmount = this.getReimbursementAmount();
        BigDecimal other$reimbursementAmount = other.getReimbursementAmount();
        if (this$reimbursementAmount == null ? other$reimbursementAmount != null : !((Object)this$reimbursementAmount).equals(other$reimbursementAmount)) {
            return false;
        }
        ReturnCodeData this$returnCode = this.getReturnCode();
        ReturnCodeData other$returnCode = other.getReturnCode();
        if (this$returnCode == null ? other$returnCode != null : !((Object)this$returnCode).equals(other$returnCode)) {
            return false;
        }
        BigDecimal this$totalDeductible = this.getTotalDeductible();
        BigDecimal other$totalDeductible = other.getTotalDeductible();
        return !(this$totalDeductible == null ? other$totalDeductible != null : !((Object)this$totalDeductible).equals(other$totalDeductible));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ServiceLinePaymentData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLineNumber();
        BigDecimal $bloodDeductible = this.getBloodDeductible();
        result = result * 59 + ($bloodDeductible == null ? 43 : ((Object)$bloodDeductible).hashCode());
        BigDecimal $coinsuranceAmount = this.getCoinsuranceAmount();
        result = result * 59 + ($coinsuranceAmount == null ? 43 : ((Object)$coinsuranceAmount).hashCode());
        BigDecimal $payment = this.getPayment();
        result = result * 59 + ($payment == null ? 43 : ((Object)$payment).hashCode());
        BigDecimal $reducedCoinsurance = this.getReducedCoinsurance();
        result = result * 59 + ($reducedCoinsurance == null ? 43 : ((Object)$reducedCoinsurance).hashCode());
        BigDecimal $reimbursementAmount = this.getReimbursementAmount();
        result = result * 59 + ($reimbursementAmount == null ? 43 : ((Object)$reimbursementAmount).hashCode());
        ReturnCodeData $returnCode = this.getReturnCode();
        result = result * 59 + ($returnCode == null ? 43 : ((Object)$returnCode).hashCode());
        BigDecimal $totalDeductible = this.getTotalDeductible();
        result = result * 59 + ($totalDeductible == null ? 43 : ((Object)$totalDeductible).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ServiceLinePaymentData(bloodDeductible=" + this.getBloodDeductible() + ", coinsuranceAmount=" + this.getCoinsuranceAmount() + ", lineNumber=" + this.getLineNumber() + ", payment=" + this.getPayment() + ", reducedCoinsurance=" + this.getReducedCoinsurance() + ", reimbursementAmount=" + this.getReimbursementAmount() + ", returnCode=" + this.getReturnCode() + ", totalDeductible=" + this.getTotalDeductible() + ")";
    }

    @Generated
    public ServiceLinePaymentData() {
    }
}

