/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core;

import gov.cms.fiss.pricers.common.application.rules.CalculationContext;
import gov.cms.fiss.pricers.opps.api.v2.IoceServiceLineData;
import gov.cms.fiss.pricers.opps.api.v2.ServiceLinePaymentData;
import gov.cms.fiss.pricers.opps.core.OppsPricerContext;
import gov.cms.fiss.pricers.opps.core.OutlierPaymentInfo;
import gov.cms.fiss.pricers.opps.core.codes.ReturnCode;
import gov.cms.fiss.pricers.opps.core.model.DeductibleLine;
import gov.cms.fiss.pricers.opps.core.model.LineCalculation;
import lombok.Generated;

public class DeductibleLineContext
extends CalculationContext<DeductibleLine, ServiceLinePaymentData> {
    private final OppsPricerContext pricerContext;
    private final LineCalculation lineCalculation;
    private final OutlierPaymentInfo outlierPaymentInfo;
    private boolean standardPaymentCalculationCompleted;

    public DeductibleLineContext(OppsPricerContext pricerContext, DeductibleLine input) {
        this(pricerContext, input, new OutlierPaymentInfo());
    }

    public DeductibleLineContext(OppsPricerContext pricerContext, DeductibleLine input, OutlierPaymentInfo outlierPaymentInfo) {
        super(input, pricerContext.getServiceLinePaymentByLineNumber(input.getServiceLine().getLineNumber()));
        this.pricerContext = pricerContext;
        this.lineCalculation = new LineCalculation(input.getServiceLine(), (ServiceLinePaymentData)this.getOutput(), input);
        this.outlierPaymentInfo = outlierPaymentInfo;
    }

    public void applyLineReturnCode(ReturnCode returnCode) {
        this.setCalculationCompleted();
        ((ServiceLinePaymentData)this.getOutput()).setReturnCode(returnCode.toReturnCodeData());
    }

    public boolean isStandardPaymentCalculationCompleted() {
        return this.standardPaymentCalculationCompleted;
    }

    public void completeStandardPaymentCalculation() {
        this.standardPaymentCalculationCompleted = true;
    }

    public boolean isPackagedBloodDeductibleLine() {
        IoceServiceLineData lineInput = ((DeductibleLine)this.getInput()).getServiceLine();
        return OppsPricerContext.isComprehensiveBloodDeductible(lineInput.getStatusIndicator(), lineInput.getPaymentAdjustmentFlags(), this.getPricerContext().getComprehensiveApcClaimStatus()) && this.getPricerContext().getDataTables().isBloodHcpcsDeductible(lineInput.getHcpcsCode());
    }

    public String getStatusIndicator() {
        IoceServiceLineData ioceServiceLine = this.getLineCalculation().getLineInput();
        return ioceServiceLine.getStatusIndicator();
    }

    @Generated
    public OppsPricerContext getPricerContext() {
        return this.pricerContext;
    }

    @Generated
    public LineCalculation getLineCalculation() {
        return this.lineCalculation;
    }

    @Generated
    public OutlierPaymentInfo getOutlierPaymentInfo() {
        return this.outlierPaymentInfo;
    }
}

