/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core;

import gov.cms.fiss.pricers.opps.api.v2.OppsClaimPricingRequest;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimPricingResponse;
import gov.cms.fiss.pricers.opps.core.OppsPricerContext;
import gov.cms.fiss.pricers.opps.core.codes.PackageFlag;
import gov.cms.fiss.pricers.opps.core.codes.StatusIndicator;
import gov.cms.fiss.pricers.opps.core.tables.DataTables;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Stream;

public class Opps2025PricerContext
extends OppsPricerContext {
    public static final String CALCULATION_VERSION = "2025.4";

    public Opps2025PricerContext(OppsClaimPricingRequest input, OppsClaimPricingResponse output, DataTables dataTables) {
        super(input, output, dataTables);
    }

    @Override
    public String getCalculationVersion() {
        return CALCULATION_VERSION;
    }

    @Override
    public BigDecimal getXRayCRTReduction() {
        return new BigDecimal("0.90");
    }

    @Override
    public BigDecimal getInpatientDeductibleCap() {
        return new BigDecimal("1676");
    }

    @Override
    public BigDecimal getApcQualityReduction() {
        return new BigDecimal("0.9806");
    }

    @Override
    public BigDecimal getWageIndexQuartile() {
        return new BigDecimal("0.9009");
    }

    @Override
    public BigDecimal getLinePaymentOutlierOffset() {
        return new BigDecimal("7175");
    }

    @Override
    public BigDecimal getColonialProcedureCap() {
        return new BigDecimal("0.15");
    }

    @Override
    public boolean notEligibleForOutlierPayment(String statusIndicator, String packageFlag, String paymentMethodFlag, List<String> paymentAdjustmentFlags) {
        return Stream.of(StatusIndicator.H_PASS_THROUGH_DEVICE, StatusIndicator.H1_NON_OPIOID_MEDICAL_DEVICE, StatusIndicator.N_PACKAGED_INTO_APC).anyMatch(si -> si.is(statusIndicator)) || PackageFlag.DRUG_ADMINISTRATION_4.is(packageFlag) || Opps2025PricerContext.isSection603(paymentMethodFlag) || Opps2025PricerContext.isComprehensiveBloodDeductible(statusIndicator, paymentAdjustmentFlags, this.getComprehensiveApcClaimStatus());
    }

    @Override
    public boolean isREHStatusIndicatorExclusion(String statusIndicator) {
        return Stream.of(StatusIndicator.A_NOT_PAID_OPPS, StatusIndicator.F_CORNEAL_TISSUE, StatusIndicator.G_DRUG_PASS_THROUGH, StatusIndicator.K_NON_PASS_THROUGH_DRUG, StatusIndicator.K1_NON_OPIOID_DRUG, StatusIndicator.L_FLU_PPV_VACCINES).anyMatch(si -> si.is(statusIndicator));
    }
}

