/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.rules.initialize_and_validate_claim;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimPricingRequest;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimPricingResponse;
import gov.cms.fiss.pricers.opps.core.OppsPricerContext;
import gov.cms.fiss.pricers.opps.core.tables.CbsaWageIndexEntry;
import java.time.LocalDate;
import java.util.Map;
import java.util.NavigableMap;

public class WageIndexImputedFloorAdjustment
implements CalculationRule<OppsClaimPricingRequest, OppsClaimPricingResponse, OppsPricerContext> {
    @Override
    public void calculate(OppsPricerContext calculationContext) {
        String stateCode = calculationContext.getProviderData().getStateCode();
        LocalDate serviceDate = calculationContext.getClaimData().getServiceFromDate();
        NavigableMap<LocalDate, CbsaWageIndexEntry> wageIndices = calculationContext.getDataTables().getCbsaWageIndexEntries(stateCode);
        if (wageIndices == null) {
            return;
        }
        Map.Entry<LocalDate, CbsaWageIndexEntry> entry = wageIndices.floorEntry(serviceDate);
        if (entry == null) {
            return;
        }
        CbsaWageIndexEntry cbsaWageIndexEntry = entry.getValue().copyBuilder().build();
        if (cbsaWageIndexEntry.getImputedFloorWageIndex() != null && BigDecimalUtils.isGreaterThanZero(cbsaWageIndexEntry.getImputedFloorWageIndex()) && BigDecimalUtils.isGreaterThan(cbsaWageIndexEntry.getImputedFloorWageIndex(), calculationContext.getWageIndex())) {
            calculationContext.setWageIndex(cbsaWageIndexEntry.getImputedFloorWageIndex());
        }
    }
}

