/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.rules.initialize_and_validate_claim;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimPricingRequest;
import gov.cms.fiss.pricers.opps.api.v2.OppsClaimPricingResponse;
import gov.cms.fiss.pricers.opps.core.OppsPricerContext;
import gov.cms.fiss.pricers.opps.core.codes.ReturnCode;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;

public class WageIndexTransitionAdjustment2023
implements CalculationRule<OppsClaimPricingRequest, OppsClaimPricingResponse, OppsPricerContext> {
    @Override
    public boolean shouldExecute(OppsPricerContext calculationContext) {
        return "1".equals(calculationContext.getProviderData().getSupplementalWageIndexIndicator());
    }

    @Override
    public void calculate(OppsPricerContext calculationContext) {
        BigDecimal supplementalWageIndex = calculationContext.getProviderData().getSupplementalWageIndex();
        if (BigDecimalUtils.isLessThanOrEqualToZero(supplementalWageIndex)) {
            calculationContext.applyClaimReturnCode(ReturnCode.WAGE_INDEX_NOT_FOUND_50);
            return;
        }
        LocalDate effectiveDate = calculationContext.getProviderData().getEffectiveDate();
        LocalDate serviceDate = calculationContext.getClaimData().getServiceFromDate();
        if (effectiveDate.getYear() != serviceDate.getYear()) {
            calculationContext.applyClaimReturnCode(ReturnCode.WAGE_INDEX_NOT_FOUND_50);
            return;
        }
        calculationContext.setWageIndex(this.applyWageIndexTransitionAdjustment(calculationContext));
    }

    private BigDecimal applyWageIndexTransitionAdjustment(OppsPricerContext calculationContext) {
        BigDecimal supplementalWageIndex = calculationContext.getProviderData().getSupplementalWageIndex();
        BigDecimal wageIndex = calculationContext.getWageIndex();
        if (BigDecimalUtils.isLessThan(wageIndex.subtract(supplementalWageIndex).divide(supplementalWageIndex, RoundingMode.HALF_UP), calculationContext.getWageIndexPercentReduction())) {
            return supplementalWageIndex.multiply(calculationContext.getWageIndexPercentAdjustment()).setScale(4, RoundingMode.HALF_UP);
        }
        return wageIndex;
    }
}

