/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.rules.initialize_and_validate_lines;

import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.opps.api.v2.IoceServiceLineData;
import gov.cms.fiss.pricers.opps.core.OppsPricerContext;
import gov.cms.fiss.pricers.opps.core.ServiceLineContext;
import gov.cms.fiss.pricers.opps.core.rules.initialize_and_validate_lines.AbstractLineCalculationRule;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CalculateDiscountRate
extends AbstractLineCalculationRule {
    @Override
    public void calculate(ServiceLineContext calculationContext) {
        calculationContext.getPricerContext().setDiscountRate(this.calculateDiscountRate((IoceServiceLineData)calculationContext.getInput()));
    }

    protected BigDecimal calculateDiscountRate(IoceServiceLineData ioceServiceLine) {
        int serviceUnits = ioceServiceLine.getApcServiceUnits();
        switch (ioceServiceLine.getDiscountingFormula()) {
            case 1: {
                return BigDecimal.ONE;
            }
            case 2: {
                int minusOne = serviceUnits - 1;
                return OppsPricerContext.DISCOUNT_FRACTION.multiply(new BigDecimal(minusOne)).add(BigDecimal.ONE).divide(new BigDecimal(serviceUnits), 8, RoundingMode.DOWN);
            }
            case 3: {
                return OppsPricerContext.TERMINATION_PROCEDURE_DISCOUNT.divide(new BigDecimal(serviceUnits), 8, RoundingMode.DOWN);
            }
            case 4: {
                return OppsPricerContext.DISCOUNT_FRACTION.add(BigDecimal.ONE).divide(new BigDecimal(serviceUnits), 8, RoundingMode.DOWN);
            }
            case 5: {
                return OppsPricerContext.DISCOUNT_FRACTION;
            }
            case 6: {
                return OppsPricerContext.TERMINATION_PROCEDURE_DISCOUNT.multiply(OppsPricerContext.DISCOUNT_FRACTION).divide(new BigDecimal(serviceUnits), 8, RoundingMode.DOWN);
            }
            case 7: {
                return OppsPricerContext.DISCOUNT_FRACTION.add(BigDecimal.ONE).multiply(OppsPricerContext.DISCOUNT_FRACTION).divide(new BigDecimal(serviceUnits), 8, RoundingMode.DOWN);
            }
            case 8: {
                return new BigDecimal("2.00000000");
            }
            case 9: {
                return BigDecimal.ONE.divide(new BigDecimal(serviceUnits), 8, RoundingMode.DOWN);
            }
        }
        return BigDecimalUtils.ZERO;
    }
}

