/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics.common;

import com.codahale.metrics.CsvReporter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.metrics.common.BaseFormattedReporterFactory;
import java.io.File;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

@JsonTypeName(value="csv")
public class CsvReporterFactory
extends BaseFormattedReporterFactory {
    private @Nullable File file;

    @JsonProperty
    public @Nullable File getFile() {
        return this.file;
    }

    @JsonProperty
    public void setFile(@Nullable File file) {
        this.file = file;
    }

    @Override
    public ScheduledReporter build(MetricRegistry registry) {
        File directory = Objects.requireNonNull(this.getFile(), "File is not set");
        boolean creation = directory.mkdirs();
        if (!creation && !directory.exists()) {
            throw new RuntimeException("Failed to create" + directory.getAbsolutePath());
        }
        return CsvReporter.forRegistry(registry).convertDurationsTo(this.getDurationUnit()).convertRatesTo(this.getRateUnit()).filter(this.getFilter()).formatFor(this.getLocale()).build(directory);
    }
}

