/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.validation.internal;

import jakarta.annotation.PostConstruct;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorFactory;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import org.glassfish.jersey.server.validation.internal.InjectingConstraintValidatorFactory;
import org.glassfish.jersey.server.validation.internal.hibernate.HibernateInjectingConstraintValidatorFactory;

public class CompositeInjectingConstraintValidatorFactory
implements ConstraintValidatorFactory {
    @Context
    private ResourceContext resourceContext;
    private InjectingConstraintValidatorFactory jerseyVF;
    private HibernateInjectingConstraintValidatorFactory hibernateVF;

    @PostConstruct
    void postConstruct() {
        this.jerseyVF = this.resourceContext.getResource(InjectingConstraintValidatorFactory.class);
        this.hibernateVF = this.resourceContext.getResource(HibernateInjectingConstraintValidatorFactory.class);
    }

    @Override
    public <T extends ConstraintValidator<?, ?>> T getInstance(Class<T> key) {
        T jerseyInstance = this.jerseyVF.getInstance(key);
        if (jerseyInstance == null) {
            return this.hibernateVF.getInstance(key);
        }
        return jerseyInstance;
    }

    @Override
    public void releaseInstance(ConstraintValidator<?, ?> instance) {
    }
}

