*pbp_b16_dental.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b16;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	pbp_b16a_bendesc_yn              $1
	pbp_b16a_bendesc_ehc             $4
	pbp_b16a_bendesc_amo_oe          $1
	pbp_b16a_bendesc_lim_oe          $1
	pbp_b16a_bendesc_per_oe          $1
	pbp_b16a_bendesc_amo_pc          $1
	pbp_b16a_bendesc_lim_pc          $1
	pbp_b16a_bendesc_per_pc          $1
	pbp_b16a_bendesc_amo_ft          $1
	pbp_b16a_bendesc_lim_ft          $1
	pbp_b16a_bendesc_per_ft          $1
	pbp_b16a_bendesc_amo_dx          $1
	pbp_b16a_bendesc_lim_dx          $1
	pbp_b16a_bendesc_per_dx          $1
	pbp_b16a_maxplan_yn              $1
	pbp_b16a_maxplan_in_oon          $1
	pbp_b16a_maxplan_per             $1
	pbp_b16a_maxenr_yn               $1
	pbp_b16a_maxenr_per              $1
	pbp_b16a_coins_yn                $1
	pbp_b16a_coins_ehc               $4
	pbp_b16a_coins_cserv_sc_pov_yn   $1
	pbp_b16a_coins_cserv_sc_pov      $4
	pbp_b16a_ded_yn                  $1
	pbp_b16a_copay_yn                $1
	pbp_b16a_copay_ehc               $4
	pbp_b16a_copay_cserv_sc_pov_yn   $1
	pbp_b16a_copay_cserv_sc_pov      $4
	pbp_b16a_auth_yn                 $1
	pbp_b16a_refer_yn                $1
	pbp_b16b_bendesc_yn              $1
	pbp_b16b_bendesc_ehc             $7
	pbp_b16b_bendesc_amo_es          $1
	pbp_b16b_bendesc_lim_es          $1
	pbp_b16b_bendesc_per_es          $1
	pbp_b16b_bendesc_amo_ds          $1
	pbp_b16b_bendesc_lim_ds          $1
	pbp_b16b_bendesc_per_ds          $1
	pbp_b16b_bendesc_amo_rs          $1
	pbp_b16b_bendesc_lim_rs          $1
	pbp_b16b_bendesc_per_rs          $1
	pbp_b16b_bendesc_amo_end         $1
	pbp_b16b_bendesc_lim_end         $1
	pbp_b16b_bendesc_per_end         $1
	pbp_b16b_bendesc_amo_peri        $1
	pbp_b16b_bendesc_lim_peri        $1
	pbp_b16b_bendesc_per_peri        $1
	pbp_b16b_bendesc_amo_ext         $1
	pbp_b16b_bendesc_lim_ext         $1
	pbp_b16b_bendesc_per_ext         $1
	pbp_b16b_bendesc_amo_poo         $1
	pbp_b16b_bendesc_lim_poo         $1
	pbp_b16b_bendesc_per_poo         $1
	pbp_b16b_maxplan_yn              $1
	pbp_b16b_maxplan_in_oon          $1
	pbp_b16b_maxbene_type            $1
	pbp_b16b_maxplan_per             $1
	pbp_b16b_maxenr_yn               $1
	pbp_b16b_maxenr_type             $1
	pbp_b16b_maxenr_per              $1
	pbp_b16b_coins_yn                $1
	pbp_b16b_coins_ehc               $8
	pbp_b16b_ded_yn                  $1
	pbp_b16b_copay_yn                $1
	pbp_b16b_copay_ehc               $8
	pbp_b16b_auth_yn                 $1
	pbp_b16b_refer_yn                $1
;

infile '.\pbp\pbp_b16_dental.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	pbp_b16a_bendesc_yn
	pbp_b16a_bendesc_ehc
	pbp_b16a_bendesc_amo_oe
	pbp_b16a_bendesc_lim_oe
	pbp_b16a_bendesc_numv_oe
	pbp_b16a_bendesc_per_oe
	pbp_b16a_bendesc_amo_pc
	pbp_b16a_bendesc_lim_pc
	pbp_b16a_bendesc_numv_pc
	pbp_b16a_bendesc_per_pc
	pbp_b16a_bendesc_amo_ft
	pbp_b16a_bendesc_lim_ft
	pbp_b16a_bendesc_numv_ft
	pbp_b16a_bendesc_per_ft
	pbp_b16a_bendesc_amo_dx
	pbp_b16a_bendesc_lim_dx
	pbp_b16a_bendesc_numv_dx
	pbp_b16a_bendesc_per_dx
	pbp_b16a_maxplan_yn
	pbp_b16a_maxplan_in_oon
	pbp_b16a_maxplan_amt
	pbp_b16a_maxplan_per
	pbp_b16a_maxenr_yn
	pbp_b16a_maxenr_amt
	pbp_b16a_maxenr_per
	pbp_b16a_coins_yn
	pbp_b16a_coins_ehc
	pbp_b16a_coins_cserv_sc_pov_yn
	pbp_b16a_coins_cserv_sc_pov
	pbp_b16a_coins_pct_minov
	pbp_b16a_coins_pct_maxov
	pbp_b16a_coins_pct_oe
	pbp_b16a_coins_pct_maxoe
	pbp_b16a_coins_pct_pc
	pbp_b16a_coins_pct_maxpc
	pbp_b16a_coins_pct_ft
	pbp_b16a_coins_pct_maxft
	pbp_b16a_coins_pct_dx
	pbp_b16a_coins_pct_maxdx
	pbp_b16a_ded_yn
	pbp_b16a_ded_amt
	pbp_b16a_copay_yn
	pbp_b16a_copay_ehc
	pbp_b16a_copay_cserv_sc_pov_yn
	pbp_b16a_copay_cserv_sc_pov
	pbp_b16a_copay_amt_ovmin
	pbp_b16a_copay_amt_ovmax
	pbp_b16a_copay_amt_oemin
	pbp_b16a_copay_amt_oemax
	pbp_b16a_copay_amt_pcmin
	pbp_b16a_copay_amt_pcmax
	pbp_b16a_copay_amt_ftmin
	pbp_b16a_copay_amt_ftmax
	pbp_b16a_copay_amt_dxmin
	pbp_b16a_copay_amt_dxmax
	pbp_b16a_auth_yn
	pbp_b16a_refer_yn
	pbp_b16b_bendesc_yn
	pbp_b16b_bendesc_ehc
	pbp_b16b_bendesc_amo_es
	pbp_b16b_bendesc_lim_es
	pbp_b16b_bendesc_numv_es
	pbp_b16b_bendesc_per_es
	pbp_b16b_bendesc_amo_ds
	pbp_b16b_bendesc_lim_ds
	pbp_b16b_bendesc_numv_ds
	pbp_b16b_bendesc_per_ds
	pbp_b16b_bendesc_amo_rs
	pbp_b16b_bendesc_lim_rs
	pbp_b16b_bendesc_numv_rs
	pbp_b16b_bendesc_per_rs
	pbp_b16b_bendesc_amo_end
	pbp_b16b_bendesc_lim_end
	pbp_b16b_bendesc_num_end
	pbp_b16b_bendesc_per_end
	pbp_b16b_bendesc_amo_peri
	pbp_b16b_bendesc_lim_peri
	pbp_b16b_bendesc_num_peri
	pbp_b16b_bendesc_per_peri
	pbp_b16b_bendesc_amo_ext
	pbp_b16b_bendesc_lim_ext
	pbp_b16b_bendesc_num_ext
	pbp_b16b_bendesc_per_ext
	pbp_b16b_bendesc_amo_poo
	pbp_b16b_bendesc_lim_poo
	pbp_b16b_bendesc_numv_poo
	pbp_b16b_bendesc_per_poo
	pbp_b16b_maxplan_yn
	pbp_b16b_maxplan_in_oon
	pbp_b16b_maxbene_type
	pbp_b16b_maxplan_amt
	pbp_b16b_maxplan_per
	pbp_b16b_maxenr_yn
	pbp_b16b_maxenr_type
	pbp_b16b_maxenr_amt
	pbp_b16b_maxenr_per
	pbp_b16b_coins_yn
	pbp_b16b_coins_ehc
	pbp_b16b_coins_pct_mc_min
	pbp_b16b_coins_pct_mc_max
	pbp_b16b_coins_pct_es_min
	pbp_b16b_coins_pct_es_max
	pbp_b16b_coins_pct_ds_min
	pbp_b16b_coins_pct_ds_max
	pbp_b16b_coins_pct_rs_min
	pbp_b16b_coins_pct_rs_max
	pbp_b16b_coins_pct_end_min
	pbp_b16b_coins_pct_end_max
	pbp_b16b_coins_pct_peri_min
	pbp_b16b_coins_pct_peri_max
	pbp_b16b_coins_pct_ext_min
	pbp_b16b_coins_pct_ext_max
	pbp_b16b_coins_pct_poo_min
	pbp_b16b_coins_pct_poo_max
	pbp_b16b_ded_yn
	pbp_b16b_ded_amt
	pbp_b16b_copay_yn
	pbp_b16b_copay_ehc
	pbp_b16b_copay_amt_mc_min
	pbp_b16b_copay_amt_mc_max
	pbp_b16b_copay_amt_es_min
	pbp_b16b_copay_amt_es_max
	pbp_b16b_copay_amt_ds_min
	pbp_b16b_copay_amt_ds_max
	pbp_b16b_copay_amt_rs_min
	pbp_b16b_copay_amt_rs_max
	pbp_b16b_copay_amt_end_min
	pbp_b16b_copay_amt_end_max
	pbp_b16b_copay_amt_peri_min
	pbp_b16b_copay_amt_peri_max
	pbp_b16b_copay_amt_ext_min
	pbp_b16b_copay_amt_ext_max
	pbp_b16b_copay_amt_poo_min
	pbp_b16b_copay_amt_poo_max
	pbp_b16b_auth_yn
	pbp_b16b_refer_yn
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	pbp_b16a_bendesc_yn              = 'Dental Prev Ben Desc YN'
	pbp_b16a_bendesc_ehc             = 'Dental Prev Ben Desc Enhance'
	pbp_b16a_bendesc_amo_oe          = 'Dental Prev OE Ben Desc AMO'
	pbp_b16a_bendesc_lim_oe          = 'Dental Prev OE Ben Desc Lim YN'
	pbp_b16a_bendesc_numv_oe         = 'Dental Prev OE Ben Desc Num'
	pbp_b16a_bendesc_per_oe          = 'Dental Prev OE Ben Desc Per'
	pbp_b16a_bendesc_amo_pc          = 'Dental Prev PC Ben Desc AMO'
	pbp_b16a_bendesc_lim_pc          = 'Dental Prev PC Ben Desc Lim YN'
	pbp_b16a_bendesc_numv_pc         = 'Dental Prev PC Ben Desc Num'
	pbp_b16a_bendesc_per_pc          = 'Dental Prev PC Ben Desc Per'
	pbp_b16a_bendesc_amo_ft          = 'Dental Prev FT Ben Desc AMO'
	pbp_b16a_bendesc_lim_ft          = 'Dental Prev FT Ben Desc Lim YN'
	pbp_b16a_bendesc_numv_ft         = 'Dental Prev FT Ben Desc Num'
	pbp_b16a_bendesc_per_ft          = 'Dental Prev FT Ben Desc Per'
	pbp_b16a_bendesc_amo_dx          = 'Dental Prev DX Ben Desc AMO'
	pbp_b16a_bendesc_lim_dx          = 'Dental Prev DX Ben Desc Lim YN'
	pbp_b16a_bendesc_numv_dx         = 'Dental Prev DX Ben Desc Num'
	pbp_b16a_bendesc_per_dx          = 'Dental Prev DX Ben Desc Per'
	pbp_b16a_maxplan_yn              = 'Dental Prev Max Plan YN'
	pbp_b16a_maxplan_in_oon          = 'In or Out'
	pbp_b16a_maxplan_amt             = 'Dental Prev Max Plan Amt'
	pbp_b16a_maxplan_per             = 'Dental Prev Max Plan Per'
	pbp_b16a_maxenr_yn               = 'Dental Prev Max Enr YN'
	pbp_b16a_maxenr_amt              = 'Dental Prev Max Enr Amt'
	pbp_b16a_maxenr_per              = 'Dental Prev Max Enr Per'
	pbp_b16a_coins_yn                = 'Dental Prev Coinsurance YN'
	pbp_b16a_coins_ehc               = 'Preventive Dental Srvcs Coins'
	pbp_b16a_coins_cserv_sc_pov_yn   = 'Dental Prev CServ SC OV YN'
	pbp_b16a_coins_cserv_sc_pov      = 'Dental Prev CServ SC POV'
	pbp_b16a_coins_pct_minov         = 'Dental Prev OV Min Coins Pct'
	pbp_b16a_coins_pct_maxov         = 'Dental Prev OV Max Coins Pct'
	pbp_b16a_coins_pct_oe            = 'Dental Prev OE Min Coins Pct'
	pbp_b16a_coins_pct_maxoe         = 'Dental Prev OE Max Coins Pct'
	pbp_b16a_coins_pct_pc            = 'Dental Prev PC Min Coins Pct'
	pbp_b16a_coins_pct_maxpc         = 'Dental Prev PC Max Coins Pct'
	pbp_b16a_coins_pct_ft            = 'Dental Prev FT Min Coins Pct'
	pbp_b16a_coins_pct_maxft         = 'Dental Prev FT Max Coins Pct'
	pbp_b16a_coins_pct_dx            = 'Dental Prev DX Min Coins Pct'
	pbp_b16a_coins_pct_maxdx         = 'Dental Prev DX Max Coins Pct'
	pbp_b16a_ded_yn                  = 'Dental Prev Deductible YN'
	pbp_b16a_ded_amt                 = 'Dental Prev Deductible Amt'
	pbp_b16a_copay_yn                = 'Dental Prev Copayment YN'
	pbp_b16a_copay_ehc               = 'Preventive Dental Srvcs Copay'
	pbp_b16a_copay_cserv_sc_pov_yn   = 'Dental Prev CServ Copay OV YN'
	pbp_b16a_copay_cserv_sc_pov      = 'Dental Prev CServ Copay SC POV'
	pbp_b16a_copay_amt_ovmin         = 'Dental Prev Min OV Copay Amt'
	pbp_b16a_copay_amt_ovmax         = 'Dental Prev Max OV Copay Amt'
	pbp_b16a_copay_amt_oemin         = 'Dental Prev OE Min Copay Amt'
	pbp_b16a_copay_amt_oemax         = 'Dental Prev OE Max Copay Amt'
	pbp_b16a_copay_amt_pcmin         = 'Dental Prev PC Min Copay Amt'
	pbp_b16a_copay_amt_pcmax         = 'Dental Prev PC Max Copay Amt'
	pbp_b16a_copay_amt_ftmin         = 'Dental Prev FT Min Copay Amt'
	pbp_b16a_copay_amt_ftmax         = 'Dental Prev FT Max Copay Amt'
	pbp_b16a_copay_amt_dxmin         = 'Dental Prev DX Min Copay Amt'
	pbp_b16a_copay_amt_dxmax         = 'Dental Prev DX Max Copay Amt'
	pbp_b16a_auth_yn                 = 'Prevent Dental Enrollee Auth'
	pbp_b16a_refer_yn                = 'Prevent Dental Referral YN'
	pbp_b16b_bendesc_yn              = 'Dental Comp Ben Desc YN'
	pbp_b16b_bendesc_ehc             = 'Dental Comp Ben Desc Enhance'
	pbp_b16b_bendesc_amo_es          = 'Dental Comp NR Ben Desc AMO'
	pbp_b16b_bendesc_lim_es          = 'Dental Comp NR Ben Desc Lim YN'
	pbp_b16b_bendesc_numv_es         = 'Dental Comp NR Ben Desc Num'
	pbp_b16b_bendesc_per_es          = 'Dental Comp NR Ben Desc Per'
	pbp_b16b_bendesc_amo_ds          = 'Dental Comp DS Ben Desc AMO'
	pbp_b16b_bendesc_lim_ds          = 'Dental Comp DS Ben Desc Lim YN'
	pbp_b16b_bendesc_numv_ds         = 'Dental Comp DS Ben Desc Num'
	pbp_b16b_bendesc_per_ds          = 'Dental Comp DS Ben Desc Per'
	pbp_b16b_bendesc_amo_rs          = 'Dental Comp RS Ben Desc AMO'
	pbp_b16b_bendesc_lim_rs          = 'Dental Comp RS Ben Desc Lim YN'
	pbp_b16b_bendesc_numv_rs         = 'Dental Comp RS Ben Desc Num'
	pbp_b16b_bendesc_per_rs          = 'Dental Comp RS Ben Desc Per'
	pbp_b16b_bendesc_amo_end         = 'B16b endodontics Ben Desc AMO'
	pbp_b16b_bendesc_lim_end         = 'B16b endodontic Ben Dsc Lim YN'
	pbp_b16b_bendesc_num_end         = 'B16b endodontics Ben Desc Num'
	pbp_b16b_bendesc_per_end         = 'B16b endodontics Ben Desc Per'
	pbp_b16b_bendesc_amo_peri        = 'B16b periodontics Ben Desc AMO'
	pbp_b16b_bendesc_lim_peri        = 'B16b periodon Ben Dsc Lim YN'
	pbp_b16b_bendesc_num_peri        = 'B16b periodontics Ben Desc Num'
	pbp_b16b_bendesc_per_peri        = 'B16b periodontics Ben Desc Per'
	pbp_b16b_bendesc_amo_ext         = 'B16b extractions Ben Desc AMO'
	pbp_b16b_bendesc_lim_ext         = 'B16b extraction Ben Dsc Lim YN'
	pbp_b16b_bendesc_num_ext         = 'B16b extractions Ben Desc Num'
	pbp_b16b_bendesc_per_ext         = 'B16b extractions Ben Desc Per'
	pbp_b16b_bendesc_amo_poo         = 'Dental Comp POO Ben Desc AMO'
	pbp_b16b_bendesc_lim_poo         = 'Dental Comp POO Ben Dsc Lim YN'
	pbp_b16b_bendesc_numv_poo        = 'Dental Comp POO Ben Desc Num'
	pbp_b16b_bendesc_per_poo         = 'Dental Comp POO Ben Desc Per'
	pbp_b16b_maxplan_yn              = 'Dental Comp Max Plan YN'
	pbp_b16b_maxplan_in_oon          = 'In or Out'
	pbp_b16b_maxbene_type            = 'Dental Comp Max Plan Type'
	pbp_b16b_maxplan_amt             = 'Dental Comp Max Plan Amt'
	pbp_b16b_maxplan_per             = 'Dental Comp Max Plan Per'
	pbp_b16b_maxenr_yn               = 'Dental Comp Max Enr YN'
	pbp_b16b_maxenr_type             = 'Dental Comp Max Enr Type'
	pbp_b16b_maxenr_amt              = 'Dental Comp Max Enr Amt'
	pbp_b16b_maxenr_per              = 'Dental Comp Max Enr Per'
	pbp_b16b_coins_yn                = 'Dental Comp Coinsurance YN'
	pbp_b16b_coins_ehc               = 'Comp Dental Srvcs Coins'
	pbp_b16b_coins_pct_mc_min        = 'Dental Comp MC Min Coins Pct'
	pbp_b16b_coins_pct_mc_max        = 'Dental Comp MC Max Coins Pct'
	pbp_b16b_coins_pct_es_min        = 'Dental Comp NR Min Coins Pct'
	pbp_b16b_coins_pct_es_max        = 'Dental Comp NR Max Coins Pct'
	pbp_b16b_coins_pct_ds_min        = 'Dental Comp DS Min Coins Pct'
	pbp_b16b_coins_pct_ds_max        = 'Dental Comp DS Max Coins Pct'
	pbp_b16b_coins_pct_rs_min        = 'Dental Comp RS Min Coins Pct'
	pbp_b16b_coins_pct_rs_max        = 'Dental Comp RS Max Coins Pct'
	pbp_b16b_coins_pct_end_min       = 'B16b endodon Min Coins Pct'
	pbp_b16b_coins_pct_end_max       = 'B16b endodon Max Coins Pct'
	pbp_b16b_coins_pct_peri_min      = 'B16b periodontic Min Coins Pct'
	pbp_b16b_coins_pct_peri_max      = 'B16b periodontic Max Coins Pct'
	pbp_b16b_coins_pct_ext_min       = 'B16b extractions Min Coins Pct'
	pbp_b16b_coins_pct_ext_max       = 'B16b extractions Max Coins Pct'
	pbp_b16b_coins_pct_poo_min       = 'Dental Comp POO Min Coins Pct'
	pbp_b16b_coins_pct_poo_max       = 'Dental Comp POO Max Coins Pct'
	pbp_b16b_ded_yn                  = 'Dental Comp Deductible YN'
	pbp_b16b_ded_amt                 = 'Dental Comp Deductible Amt'
	pbp_b16b_copay_yn                = 'Dental Comp Copayment YN'
	pbp_b16b_copay_ehc               = 'Comp Dental Srvcs Copay'
	pbp_b16b_copay_amt_mc_min        = 'Dental Comp MC Min Copay Amt'
	pbp_b16b_copay_amt_mc_max        = 'Dental Comp MC Max Copay Amt'
	pbp_b16b_copay_amt_es_min        = 'Dental Comp NR Min Copay Amt'
	pbp_b16b_copay_amt_es_max        = 'Dental Comp NR Max Copay Amt'
	pbp_b16b_copay_amt_ds_min        = 'Dental Comp DS Min Copay Amt'
	pbp_b16b_copay_amt_ds_max        = 'Dental Comp DS Max Copay Amt'
	pbp_b16b_copay_amt_rs_min        = 'Dental Comp RS Min Copay Amt'
	pbp_b16b_copay_amt_rs_max        = 'Dental Comp RS Max Copay Amt'
	pbp_b16b_copay_amt_end_min       = 'B16b endodontic Min Copay Amt'
	pbp_b16b_copay_amt_end_max       = 'B16b endodontic Max Copay Amt'
	pbp_b16b_copay_amt_peri_min      = 'B16b periodontic Min Copay Amt'
	pbp_b16b_copay_amt_peri_max      = 'B16b periodontic Max Copay Amt'
	pbp_b16b_copay_amt_ext_min       = 'B16b extraction Min Copay Amt'
	pbp_b16b_copay_amt_ext_max       = 'B16b extraction Max Copay Amt'
	pbp_b16b_copay_amt_poo_min       = 'Dental Comp POO Min Copay Amt'
	pbp_b16b_copay_amt_poo_max       = 'Dental Comp POO Max Copay Amt'
	pbp_b16b_auth_yn                 = 'Dental Comp Enrollee Auth'
	pbp_b16b_refer_yn                = 'Dental Comp Referral YN'
;

run;

proc sort data = pbp_b16 out=out.pbp_b16;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_b16(obs = 10);
  title 'pbp_b16_dental file ';
run;

proc means data = out.pbp_b16;
  title 'pbp_b16_dental file ';
run;

proc freq data = out.pbp_b16;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	pbp_b16a_bendesc_yn
	pbp_b16a_bendesc_ehc
	pbp_b16a_bendesc_amo_oe
	pbp_b16a_bendesc_lim_oe
	pbp_b16a_bendesc_per_oe
	pbp_b16a_bendesc_amo_pc
	pbp_b16a_bendesc_lim_pc
	pbp_b16a_bendesc_per_pc
	pbp_b16a_bendesc_amo_ft
	pbp_b16a_bendesc_lim_ft
	pbp_b16a_bendesc_per_ft
	pbp_b16a_bendesc_amo_dx
	pbp_b16a_bendesc_lim_dx
	pbp_b16a_bendesc_per_dx
	pbp_b16a_maxplan_yn
	pbp_b16a_maxplan_in_oon
	pbp_b16a_maxplan_per
	pbp_b16a_maxenr_yn
	pbp_b16a_maxenr_per
	pbp_b16a_coins_yn
	pbp_b16a_coins_ehc
	pbp_b16a_coins_cserv_sc_pov_yn
	pbp_b16a_coins_cserv_sc_pov
	pbp_b16a_ded_yn
	pbp_b16a_copay_yn
	pbp_b16a_copay_ehc
	pbp_b16a_copay_cserv_sc_pov_yn
	pbp_b16a_copay_cserv_sc_pov
	pbp_b16a_auth_yn
	pbp_b16a_refer_yn
	pbp_b16b_bendesc_yn
	pbp_b16b_bendesc_amo_es
	pbp_b16b_bendesc_lim_es
	pbp_b16b_bendesc_per_es
	pbp_b16b_bendesc_amo_ds
	pbp_b16b_bendesc_lim_ds
	pbp_b16b_bendesc_per_ds
	pbp_b16b_bendesc_amo_rs
	pbp_b16b_bendesc_lim_rs
	pbp_b16b_bendesc_per_rs
	pbp_b16b_bendesc_amo_end
	pbp_b16b_bendesc_lim_end
	pbp_b16b_bendesc_per_end
	pbp_b16b_bendesc_amo_peri
	pbp_b16b_bendesc_lim_peri
	pbp_b16b_bendesc_per_peri
	pbp_b16b_bendesc_amo_ext
	pbp_b16b_bendesc_lim_ext
	pbp_b16b_bendesc_per_ext
	pbp_b16b_bendesc_amo_poo
	pbp_b16b_bendesc_lim_poo
	pbp_b16b_bendesc_per_poo
	pbp_b16b_maxplan_yn
	pbp_b16b_maxplan_in_oon
	pbp_b16b_maxbene_type
	pbp_b16b_maxplan_per
	pbp_b16b_maxenr_yn
	pbp_b16b_maxenr_type
	pbp_b16b_maxenr_per
	pbp_b16b_coins_yn
	pbp_b16b_ded_yn
	pbp_b16b_copay_yn
	pbp_b16b_auth_yn
	pbp_b16b_refer_yn
/ missing;
run;

proc contents data = out.pbp_b16;
  title 'pbp_b16 data';
run;