*pbp_b7_b19b_health_prof_vbid_uf.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b7_vbid;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	pbp_vbid_group_id                $2
	pbp_b7b_bendesc_yn               $1
	pbp_b7b_bendesc_ehc              $2
	pbp_b7b_bendesc_amo_rc           $1
	pbp_b7b_bendesc_lim_rc           $1
	pbp_b7b_bendesc_per_rc           $1
	pbp_b7b_combined_ben             $1
	pbp_b7b_comb_ben_ehc             $2
	pbp_b7b_addl_service_other       $144
	pbp_b7b_bendesc_amo_other        $1
	pbp_b7b_bendesc_lim_other        $1
	pbp_b7b_bendesc_per_other        $1
	pbp_b7b_maxplan_yn               $1
	pbp_b7b_maxplan_per              $1
	pbp_b7b_maxenr_yn                $1
	pbp_b7b_maxenr_per               $1
	pbp_b7b_coins_yn                 $1
	pbp_b7b_coins_ehc                $3
	pbp_b7b_copay_yn                 $1
	pbp_b7b_copay_ehc                $3
	pbp_b7b_ded_yn                   $1
	pbp_b7b_auth_yn                  $1
	pbp_b7b_refer_yn                 $1
	pbp_b7f_bendesc_yn               $1
	pbp_b7f_bendesc_rf               $1
	pbp_b7f_bendesc_amo_rf           $1
	pbp_b7f_bendesc_lim_rf           $1
	pbp_b7f_bendesc_per_rf           $1
	pbp_b7f_maxplan_yn               $1
	pbp_b7f_maxplan_per              $1
	pbp_b7f_maxenr_yn                $1
	pbp_b7f_maxenr_per               $1
	pbp_b7f_coins_yn                 $1
	pbp_b7f_coins_ehc                $2
	pbp_b7f_ded_yn                   $1
	pbp_b7f_copay_yn                 $1
	pbp_b7f_copay_ehc                $2
	pbp_b7f_auth_yn                  $1
	pbp_b7f_refer_yn                 $1
;

infile '.\pbp\pbp_b7_b19b_health_prof_vbid_uf.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	pbp_vbid_group_id
	version
	pbp_b7b_bendesc_yn
	pbp_b7b_bendesc_ehc
	pbp_b7b_bendesc_amo_rc
	pbp_b7b_bendesc_lim_rc
	pbp_b7b_bendesc_num_rc
	pbp_b7b_bendesc_per_rc
	pbp_b7b_combined_ben
	pbp_b7b_comb_ben_ehc
	pbp_b7b_addl_service_other
	pbp_b7b_bendesc_amo_other
	pbp_b7b_bendesc_lim_other
	pbp_b7b_bendesc_num_other
	pbp_b7b_bendesc_per_other
	pbp_b7b_maxplan_yn
	pbp_b7b_maxplan_amt
	pbp_b7b_maxplan_per
	pbp_b7b_maxenr_yn
	pbp_b7b_maxenr_amt
	pbp_b7b_maxenr_per
	pbp_b7b_coins_yn
	pbp_b7b_coins_ehc
	pbp_b7b_coins_pct_mc_min
	pbp_b7b_coins_pct_mc_max
	pbp_b7b_coins_pct_rc_min
	pbp_b7b_coins_pct_rc_max
	pbp_b7b_coins_pct_other_min
	pbp_b7b_coins_pct_other_max
	pbp_b7b_copay_yn
	pbp_b7b_copay_ehc
	pbp_b7b_copay_mc_amt_min
	pbp_b7b_copay_mc_amt_max
	pbp_b7b_copay_rc_amt_min
	pbp_b7b_copay_rc_amt_max
	pbp_b7b_copay_other_amt_min
	pbp_b7b_copay_other_amt_max
	pbp_b7b_ded_yn
	pbp_b7b_ded_amt
	pbp_b7b_auth_yn
	pbp_b7b_refer_yn
	pbp_b7f_bendesc_yn
	pbp_b7f_bendesc_rf
	pbp_b7f_bendesc_amo_rf
	pbp_b7f_bendesc_lim_rf
	pbp_b7f_bendesc_amt_rf
	pbp_b7f_bendesc_per_rf
	pbp_b7f_maxplan_yn
	pbp_b7f_maxplan_amt
	pbp_b7f_maxplan_per
	pbp_b7f_maxenr_yn
	pbp_b7f_maxenr_amt
	pbp_b7f_maxenr_per
	pbp_b7f_coins_yn
	pbp_b7f_coins_ehc
	pbp_b7f_coins_pct_mc_min
	pbp_b7f_coins_pct_mc_max
	pbp_b7f_coins_pct_rf_min
	pbp_b7f_coins_pct_rf_max
	pbp_b7f_ded_yn
	pbp_b7f_ded_amt
	pbp_b7f_copay_yn
	pbp_b7f_copay_ehc
	pbp_b7f_copay_mc_amt_min
	pbp_b7f_copay_mc_amt_max
	pbp_b7f_copay_rf_amt_min
	pbp_b7f_copay_rf_amt_max
	pbp_b7f_auth_yn
	pbp_b7f_refer_yn
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	pbp_vbid_group_id                = 'B19 VBID Group (Package) ID'
	pbp_b7b_bendesc_yn               = 'Chiropractic Ben Desc YN'
	pbp_b7b_bendesc_ehc              = 'Chiropractic Ben Desc Enhance'
	pbp_b7b_bendesc_amo_rc           = 'B7b routine care Ben Desc AMO'
	pbp_b7b_bendesc_lim_rc           = 'Chiropractic Ben Desc Lim'
	pbp_b7b_bendesc_num_rc           = 'Chiropractic Ben Desc Num'
	pbp_b7b_bendesc_per_rc           = 'B7b routine care Ben Desc Per'
	pbp_b7b_combined_ben             = 'B7 Comb Ben YN'
	pbp_b7b_comb_ben_ehc             = 'B7b comb ben selection'
	pbp_b7b_addl_service_other       = 'B7b other service name'
	pbp_b7b_bendesc_amo_other        = 'B7b Other Ben Desc AMO'
	pbp_b7b_bendesc_lim_other        = 'B7b other Ben Desc Lim'
	pbp_b7b_bendesc_num_other        = 'B7b other Ben Desc Num'
	pbp_b7b_bendesc_per_other        = 'B7b other Ben Desc Per'
	pbp_b7b_maxplan_yn               = 'Chiropractic Max Plan YN'
	pbp_b7b_maxplan_amt              = 'Chiropractic Max Plan Amt'
	pbp_b7b_maxplan_per              = 'Chiropractic Max Plan Per'
	pbp_b7b_maxenr_yn                = 'Chiropractic Max Enr YN'
	pbp_b7b_maxenr_amt               = 'Chiropractic Max Enr Amt'
	pbp_b7b_maxenr_per               = 'Chiropractic Max Enr Per'
	pbp_b7b_coins_yn                 = 'Chiropractic Coinsurance YN'
	pbp_b7b_coins_ehc                = 'Chiro Coins Enhance Benefits'
	pbp_b7b_coins_pct_mc_min         = 'Chiropractic MC Min Coins Pct'
	pbp_b7b_coins_pct_mc_max         = 'Chiropractic MC Max Coins Pct'
	pbp_b7b_coins_pct_rc_min         = 'B7b RC Min Coins Pct'
	pbp_b7b_coins_pct_rc_max         = 'B7b RC Max Coins Pct'
	pbp_b7b_coins_pct_other_min      = 'B7b Other Min Coins Pct'
	pbp_b7b_coins_pct_other_max      = 'B7b Other Max Coins Pct'
	pbp_b7b_copay_yn                 = 'Chiropractic Copayment YN'
	pbp_b7b_copay_ehc                = 'Chiro Copay Enhanc Benefits'
	pbp_b7b_copay_mc_amt_min         = 'Chiropractic MC Min Copay Amt'
	pbp_b7b_copay_mc_amt_max         = 'Chiropractic MC Max Copay Amt'
	pbp_b7b_copay_rc_amt_min         = 'Chiropractic RC Min Copay Amt'
	pbp_b7b_copay_rc_amt_max         = 'Chiropractic RC Max Copay Amt'
	pbp_b7b_copay_other_amt_min      = 'B7b Other Min Copay Amt'
	pbp_b7b_copay_other_amt_max      = 'B7b RC Max Copay Amt'
	pbp_b7b_ded_yn                   = 'Chiropractic Deductible YN'
	pbp_b7b_ded_amt                  = 'Chiropractic Deductible Amt'
	pbp_b7b_auth_yn                  = 'Chiropractic Auth'
	pbp_b7b_refer_yn                 = 'Chiropractic Referral YN'
	pbp_b7f_bendesc_yn               = 'Podiatrist Ben Desc YN'
	pbp_b7f_bendesc_rf               = 'Podiatrist RF Ben Desc Enhance'
	pbp_b7f_bendesc_amo_rf           = 'Podiatrist RF Ben Desc AMO'
	pbp_b7f_bendesc_lim_rf           = 'Podiatrist RF Ben Desc Lim YN'
	pbp_b7f_bendesc_amt_rf           = 'Podiatrist RF Ben Desc Amt'
	pbp_b7f_bendesc_per_rf           = 'Podiatrist RF Ben Desc Per'
	pbp_b7f_maxplan_yn               = 'Podiatrist Max Plan YN'
	pbp_b7f_maxplan_amt              = 'Podiatrist Max Plan Amt'
	pbp_b7f_maxplan_per              = 'Podiatrist Max Plan Per'
	pbp_b7f_maxenr_yn                = 'Podiatrist Max Enr YN'
	pbp_b7f_maxenr_amt               = 'Podiatrist Max Enr Amt'
	pbp_b7f_maxenr_per               = 'Podiatrist Max Enr Per'
	pbp_b7f_coins_yn                 = 'Podiatrist Coinsurance YN'
	pbp_b7f_coins_ehc                = 'Podiatry Services Coinsurance'
	pbp_b7f_coins_pct_mc_min         = 'Podiatrist MC Min Coins Pct'
	pbp_b7f_coins_pct_mc_max         = 'Podiatrist MC Max Coins Pct'
	pbp_b7f_coins_pct_rf_min         = 'Podiatry RF Min Coins Pct'
	pbp_b7f_coins_pct_rf_max         = 'Podiatry RF Max Coins Pct'
	pbp_b7f_ded_yn                   = 'Podiatrist Deductible YN'
	pbp_b7f_ded_amt                  = 'Podiatrist Deductible Amt'
	pbp_b7f_copay_yn                 = 'Podiatrist Copayment YN'
	pbp_b7f_copay_ehc                = 'Podiatry Services have a Copay'
	pbp_b7f_copay_mc_amt_min         = 'Podiatrist MC Min Copay Amt'
	pbp_b7f_copay_mc_amt_max         = 'Podiatrist MC Max Copay Amt'
	pbp_b7f_copay_rf_amt_min         = 'Podiatrist RF Min Copay Amt'
	pbp_b7f_copay_rf_amt_max         = 'Podiatrist RF Max Copay Amt'
	pbp_b7f_auth_yn                  = 'Podiatrist Enrollee Auth'
	pbp_b7f_refer_yn                 = 'Podiatrist Referral YN'
;

run;

proc sort data = pbp_b7_vbid out=out.pbp_b7_vbid;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_b7_vbid(obs = 10);
  title 'pbp_b7_b19b_health_prof_vbid_uf file ';
run;

proc means data = out.pbp_b7_vbid;
  title 'pbp_b7_b19b_health_prof_vbid_uf file ';
run;

proc freq data = out.pbp_b7_vbid;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	pbp_vbid_group_id
	pbp_b7b_bendesc_yn
	pbp_b7b_bendesc_ehc
	pbp_b7b_bendesc_amo_rc
	pbp_b7b_bendesc_lim_rc
	pbp_b7b_bendesc_per_rc
	pbp_b7b_combined_ben
	pbp_b7b_comb_ben_ehc
	pbp_b7b_bendesc_amo_other
	pbp_b7b_bendesc_lim_other
	pbp_b7b_bendesc_per_other
	pbp_b7b_maxplan_yn
	pbp_b7b_maxplan_per
	pbp_b7b_maxenr_yn
	pbp_b7b_maxenr_per
	pbp_b7b_coins_yn
	pbp_b7b_coins_ehc
	pbp_b7b_copay_yn
	pbp_b7b_copay_ehc
	pbp_b7b_ded_yn
	pbp_b7b_auth_yn
	pbp_b7b_refer_yn
	pbp_b7f_bendesc_yn
	pbp_b7f_bendesc_rf
	pbp_b7f_bendesc_amo_rf
	pbp_b7f_bendesc_lim_rf
	pbp_b7f_bendesc_per_rf
	pbp_b7f_maxplan_yn
	pbp_b7f_maxplan_per
	pbp_b7f_maxenr_yn
	pbp_b7f_maxenr_per
	pbp_b7f_coins_yn
	pbp_b7f_coins_ehc
	pbp_b7f_ded_yn
	pbp_b7f_copay_yn
	pbp_b7f_copay_ehc
	pbp_b7f_auth_yn
	pbp_b7f_refer_yn
/ missing;
run;

proc contents data = out.pbp_b7_vbid;
  title 'pbp_b7_vbid data';
run;