*pbp_mrx_vbid.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_mrx_vbid;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	part_d_model_demo                $1
	mrx_tier_group_id                $2
	mrx_tier_grp_ehc                 $11
	mrx_tier_phase                   $3
	mrx_tier_incent_yn               $1
	mrx_tier_hival_yn                $1
	mrx_tier_mod_ded_yn              $1
	mrx_group_tiers_icl              $6
	mrx_group_tiers_gap              $6
	mrx_group_tiers_oop              $6
;

infile '.\pbp\pbp_mrx_vbid.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	part_d_model_demo
	mrx_tier_group_id
	mrx_tier_grp_ehc
	mrx_tier_phase
	mrx_tier_incent_yn
	mrx_tier_hival_yn
	mrx_tier_mod_ded_yn
	mrx_tier_mod_ded_amt
	mrx_group_tiers_icl
	mrx_group_tiers_gap
	mrx_group_tiers_oop
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	part_d_model_demo                = 'Part D Model demonstration (CAT-D)'
	mrx_tier_group_id                = 'MRX VBID Group (Package) ID'
	mrx_tier_grp_ehc                 = 'Rx Vbid Disease States'
	mrx_tier_phase                   = 'Rx Vbid Phase'
	mrx_tier_incent_yn               = 'Rx Vbid Incentive Yn'
	mrx_tier_hival_yn                = 'Rx Vbid HighVal Yn'
	mrx_tier_mod_ded_yn              = 'VBID Rx deductible mod yn'
	mrx_tier_mod_ded_amt             = 'VBID Rx mod deduct amount'
	mrx_group_tiers_icl              = 'Rx vbid icl tiers'
	mrx_group_tiers_gap              = 'Rx vbid icl tiers'
	mrx_group_tiers_oop              = 'Rx vbid icl tiers'
;

run;

proc sort data = pbp_mrx_vbid out=out.pbp_mrx_vbid;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_mrx_vbid(obs = 10);
  title 'pbp_mrx_vbid file ';
run;

proc means data = out.pbp_mrx_vbid;
  title 'pbp_mrx_vbid file ';
run;

proc freq data = out.pbp_mrx_vbid;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	part_d_model_demo
	mrx_tier_group_id
	mrx_tier_phase
	mrx_tier_incent_yn
	mrx_tier_hival_yn
	mrx_tier_mod_ded_yn
/ missing;
run;

proc contents data = out.pbp_mrx_vbid;
  title 'pbp_mrx data';
run;
