*pbp_b19_model_test.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b19;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	pbp_b19a_uf_yn                   $1
	pbp_b19a_ssbci_yn                $1
	pbp_b19a_ssbci_bendesc           $2
	pbp_b19a_vbd_hospice_ben_yn      $1
	pbp_b19a_vbd_yn                  $1
	pbp_b19a_vbd_type                $2
	pbp_b19a_attestation             $1
	pbp_b19_whp_prog_type            $5
	pbp_b19_whp_prog_type_other      $200
	pbp_b19_whp_mode_of_eng          $3
	pbp_b19_whp_partc_rew_inc_yn     $1
	pbp_b19_whp_type_partc_rew       $4
	pbp_b19_whp_freq_rew             $1
	pbp_b19_whp_eligibil_crit        $200
	pbp_b19_whp_provid_incent        $1
	pbp_b19_whp_prog_connectedness   $5
	pbp_b19_c_ri_cnt                 $1
	pbp_b19_c_ri_type_1              $4
	pbp_b19_c_ri_type_note_1         $200
	pbp_b19_c_ri_freq_1              $1
	pbp_b19_c_ri_freq_desc_1         $200
	pbp_b19_c_ri_type_2              $4
	pbp_b19_c_ri_type_note_2         $200
	pbp_b19_c_ri_freq_2              $1
	pbp_b19_c_ri_freq_desc_2         $200
	pbp_b19_c_ri_type_3              $4
	pbp_b19_c_ri_type_note_3         $200
	pbp_b19_c_ri_freq_3              $1
	pbp_b19_c_ri_freq_desc_3         $200
	pbp_b19a_reduct_cost_yn          $1
	pbp_b19b_add_cost_yn             $1
	pbp_b19c_conins_enrol_yn         $1
	pbp_b19c_copay_enrol_yn          $1
	pbp_b19c_conins_resp_enrol_yn    $1
	pbp_b19c_copay_resp_enrol_yn     $1
	pbp_b19c_conins_enrol2_yn        $1
	pbp_b19c_copay_enrol2_yn         $1
	pbp_b19c_conins_resp_enrol2_yn   $1
	pbp_b19c_copay_resp_enrol2_yn    $1
	pbp_b19c_mand_supp_ben_yn        $1
	pbp_b19c_hosp_supp_ben_cont_yn   $1
	pbp_b19c_cov_hlth_rltd_yn        $1
	pbp_b19c_cov_hlth_rltd           $6
	pbp_b19c_tmp_cov_res_fac_yn      $1
	pbp_b19c_red_cost_shar_yn        $1
	pbp_b19c_oth_man_supp_ben_yn     $1
	pbp_b19c_oth_man_supp_ben        $200
;

infile '.\pbp\pbp_b19_model_test.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	pbp_b19a_uf_yn
	pbp_b19a_ssbci_yn
	pbp_b19a_ssbci_bendesc
	pbp_b19a_vbd_hospice_ben_yn
	pbp_b19a_vbd_yn
	pbp_b19a_vbd_type
	pbp_b19a_attestation
	pbp_b19_whp_prog_type
	pbp_b19_whp_prog_type_other
	pbp_b19_whp_mode_of_eng
	pbp_b19_whp_partc_rew_inc_yn
	pbp_b19_whp_type_partc_rew
	pbp_b19_whp_rew_inc_amt
	pbp_b19_whp_freq_rew
	pbp_b19_whp_eligibil_crit
	pbp_b19_whp_provid_incent
	pbp_b19_whp_prog_connectedness
	pbp_b19_whp_ben_eng_ann_amt
	pbp_b19_c_ri_cnt
	pbp_b19_c_ri_type_1
	pbp_b19_c_ri_type_note_1
	pbp_b19_c_ri_amt_1
	pbp_b19_c_ri_freq_1
	pbp_b19_c_ri_freq_desc_1
	pbp_b19_c_ri_max_1
	pbp_b19_c_ri_type_2
	pbp_b19_c_ri_type_note_2
	pbp_b19_c_ri_amt_2
	pbp_b19_c_ri_freq_2
	pbp_b19_c_ri_freq_desc_2
	pbp_b19_c_ri_max_2
	pbp_b19_c_ri_type_3
	pbp_b19_c_ri_type_note_3
	pbp_b19_c_ri_amt_3
	pbp_b19_c_ri_freq_3
	pbp_b19_c_ri_freq_desc_3
	pbp_b19_c_ri_max_3
	pbp_b19a_reduct_cost_yn
	pbp_b19a_reduct_package_num
	pbp_b19b_add_cost_yn
	pbp_b19b_add_package_num
	pbp_b19c_conins_enrol_yn
	pbp_b19c_coins_pct_minov
	pbp_b19c_coins_pct_maxov
	pbp_b19c_pres_drug_max
	pbp_b19c_copay_enrol_yn
	pbp_b19c_copay_amt_minov
	pbp_b19c_copay_amt_maxov
	pbp_b19c_conins_resp_enrol_yn
	pbp_b19c_coins_pct_resp_min
	pbp_b19c_coins_pct_resp_max
	pbp_b19c_resp_care_max
	pbp_b19c_copay_resp_enrol_yn
	pbp_b19c_copay_amt_resp_min
	pbp_b19c_copay_amt_resp_max
	pbp_b19c_conins_enrol2_yn
	pbp_b19c_coins_pct2_minov
	pbp_b19c_coins_pct2_maxov
	pbp_b19c_pres_drug2_max
	pbp_b19c_copay_enrol2_yn
	pbp_b19c_copay_amt2_minov
	pbp_b19c_copay_amt2_maxov
	pbp_b19c_conins_resp_enrol2_yn
	pbp_b19c_coins_pct_resp2_min
	pbp_b19c_coins_pct_resp2_max
	pbp_b19c_resp_care2_max
	pbp_b19c_copay_resp_enrol2_yn
	pbp_b19c_copay_amt_resp2_min
	pbp_b19c_copay_amt_resp2_max
	pbp_b19c_mand_supp_ben_yn
	pbp_b19c_max_plan_ben_amt
	pbp_b19c_hosp_supp_ben_cont_yn
	pbp_b19c_cov_hlth_rltd_yn
	pbp_b19c_cov_hlth_rltd
	pbp_b19c_tmp_cov_res_fac_yn
	pbp_b19c_red_cost_shar_yn
	pbp_b19c_oth_man_supp_ben_yn
	pbp_b19c_oth_man_supp_ben
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	pbp_b19a_uf_yn                   = 'B19A uniform flex yn'
	pbp_b19a_ssbci_yn                = 'B19A SSBCI yn'
	pbp_b19a_ssbci_bendesc           = 'B19A SSBCI type'
	pbp_b19a_vbd_hospice_ben_yn      = 'R U offrng VBID Hspce Bnft?'
	pbp_b19a_vbd_yn                  = 'Reduced or Add Ben Desc YN'
	pbp_b19a_vbd_type                = 'B19 VBID type'
	pbp_b19a_attestation             = 'VBID  Attestation'
	pbp_b19_whp_prog_type            = 'WHP Prgrm Type'
	pbp_b19_whp_prog_type_other      = 'WHP Other Program'
	pbp_b19_whp_mode_of_eng          = 'WHP Engagement Mode'
	pbp_b19_whp_partc_rew_inc_yn     = 'WHP Rew and Inc Offer'
	pbp_b19_whp_type_partc_rew       = 'WHP Rew and Inc Type'
	pbp_b19_whp_rew_inc_amt          = 'WHP Rew and Inc Amount'
	pbp_b19_whp_freq_rew             = 'WHP Rew and Inc Frequency'
	pbp_b19_whp_eligibil_crit        = 'WHP Eligibility Criteria Note'
	pbp_b19_whp_provid_incent        = 'WHP Provider Incentives'
	pbp_b19_whp_prog_connectedness   = 'WHP Connectedness'
	pbp_b19_whp_ben_eng_ann_amt      = 'WHP Number Benes Engaged'
	pbp_b19_c_ri_cnt                 = 'VBID RAI Package Number'
	pbp_b19_c_ri_type_1              = 'VBID RAI Type 1'
	pbp_b19_c_ri_type_note_1         = 'VBID RAI Type Other 1'
	pbp_b19_c_ri_amt_1               = 'VBID RAI Amount 1'
	pbp_b19_c_ri_freq_1              = 'VBID RAI Frequency 1'
	pbp_b19_c_ri_freq_desc_1         = 'VBID RAI Frequency Desc 1'
	pbp_b19_c_ri_max_1               = 'VBID RAI Max Annual Amt 1'
	pbp_b19_c_ri_type_2              = 'VBID RAI Type 2'
	pbp_b19_c_ri_type_note_2         = 'VBID RAI Type Other 2'
	pbp_b19_c_ri_amt_2               = 'VBID RAI Amount 2'
	pbp_b19_c_ri_freq_2              = 'VBID RAI Frequency 2'
	pbp_b19_c_ri_freq_desc_2         = 'VBID RAI Frequency Desc 2'
	pbp_b19_c_ri_max_2               = 'VBID RAI Max Annual Amt 2'
	pbp_b19_c_ri_type_3              = 'VBID RAI Type 3'
	pbp_b19_c_ri_type_note_3         = 'VBID RAI Type Other 3'
	pbp_b19_c_ri_amt_3               = 'VBID RAI Amount 3'
	pbp_b19_c_ri_freq_3              = 'VBID RAI Frequency 3'
	pbp_b19_c_ri_freq_desc_3         = 'VBID RAI Frequency Desc 3'
	pbp_b19_c_ri_max_3               = 'VBID RAI Max Annual Amt 3'
	pbp_b19a_reduct_cost_yn          = 'Reduced Cost Sharing YN'
	pbp_b19a_reduct_package_num      = 'Reduction Benefit Packages'
	pbp_b19b_add_cost_yn             = 'Additional Benefits YN'
	pbp_b19b_add_package_num         = 'Additional Benefit Packages'
	pbp_b19c_conins_enrol_yn         = 'Hospice INN Drugs Coins YN'
	pbp_b19c_coins_pct_minov         = 'Hospice INN Drugs Coins Min'
	pbp_b19c_coins_pct_maxov         = 'Hospice INN Drugs Coins Max'
	pbp_b19c_pres_drug_max           = 'VBID Hospice INN Max Drug Amt'
	pbp_b19c_copay_enrol_yn          = 'Hospice INN Drugs Copay YN'
	pbp_b19c_copay_amt_minov         = 'Hospice INN Drugs Copay Min'
	pbp_b19c_copay_amt_maxov         = 'Hospice INN Drugs Copay Max'
	pbp_b19c_conins_resp_enrol_yn    = 'Hospice INN Respite Coins YN'
	pbp_b19c_coins_pct_resp_min      = 'Hospice INN Respite Coins Min'
	pbp_b19c_coins_pct_resp_max      = 'Hospice INN Respite Coins Max'
	pbp_b19c_resp_care_max           = 'VBID Hospice INN Max Day Amt'
	pbp_b19c_copay_resp_enrol_yn     = 'Hospice INN Respite Copay YN'
	pbp_b19c_copay_amt_resp_min      = 'Hospice INN Respite Copay Min'
	pbp_b19c_copay_amt_resp_max      = 'Hospice INN Respite Copay Max'
	pbp_b19c_conins_enrol2_yn        = 'Hospice OON Drugs Coins YN'
	pbp_b19c_coins_pct2_minov        = 'Hospice OON Drugs Coins Min'
	pbp_b19c_coins_pct2_maxov        = 'Hospice OON Drugs Coins Max'
	pbp_b19c_pres_drug2_max          = 'VBID Hospice OON Max Drug Amt'
	pbp_b19c_copay_enrol2_yn         = 'Hospice OON Drugs Copay YN'
	pbp_b19c_copay_amt2_minov        = 'Hospice OON Drugs Copay Min'
	pbp_b19c_copay_amt2_maxov        = 'Hospice OON Drugs Copay Max'
	pbp_b19c_conins_resp_enrol2_yn   = 'Hospice OON Respite Coins YN'
	pbp_b19c_coins_pct_resp2_min     = 'Hospice OON Respite Coins Min'
	pbp_b19c_coins_pct_resp2_max     = 'Hospice OON Respite Copay Max'
	pbp_b19c_resp_care2_max          = 'VBID Hospice OON Max Day Amt'
	pbp_b19c_copay_resp_enrol2_yn    = 'Hospice OON Respite Copay YN'
	pbp_b19c_copay_amt_resp2_min     = 'Hospice OON Respite Copay Min'
	pbp_b19c_copay_amt_resp2_max     = 'Hospice OON Respite Coins Max'
	pbp_b19c_mand_supp_ben_yn        = 'Hospice Supp Ben YN'
	pbp_b19c_max_plan_ben_amt        = 'Hospice Supp Max Ben Amount'
	pbp_b19c_hosp_supp_ben_cont_yn   = 'Hospice Supp IIN Contingent YN'
	pbp_b19c_cov_hlth_rltd_yn        = 'Hospice Supp Reduce Impact'
	pbp_b19c_cov_hlth_rltd           = 'Hospice Supp Impact Items'
	pbp_b19c_tmp_cov_res_fac_yn      = 'Hospice Supp Temp Coverage YN'
	pbp_b19c_red_cost_shar_yn        = 'Hospice Supp Reduced Cost'
	pbp_b19c_oth_man_supp_ben_yn     = 'Hospice Supp Othr Mand Supp YN'
	pbp_b19c_oth_man_supp_ben        = 'Hospice Supp Other Supp Note'
;

run;

proc sort data = pbp_b19 out=out.pbp_b19;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_b19(obs = 10);
  title 'pbp_b19_model_test file ';
run;

proc means data = out.pbp_b19;
  title 'pbp_b19_model_test file ';
run;

proc freq data = out.pbp_b19;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	pbp_b19a_uf_yn
	pbp_b19a_ssbci_yn
	pbp_b19a_ssbci_bendesc
	pbp_b19a_vbd_hospice_ben_yn
	pbp_b19a_vbd_yn
	pbp_b19a_vbd_type
	pbp_b19a_attestation
	pbp_b19_whp_prog_type
	pbp_b19_whp_mode_of_eng
	pbp_b19_whp_partc_rew_inc_yn
	pbp_b19_whp_type_partc_rew
	pbp_b19_whp_freq_rew
	pbp_b19_whp_provid_incent
	pbp_b19_whp_prog_connectedness
	pbp_b19_c_ri_cnt
	pbp_b19_c_ri_type_1
	pbp_b19_c_ri_freq_1
	pbp_b19_c_ri_type_2
	pbp_b19_c_ri_freq_2
	pbp_b19_c_ri_type_3
	pbp_b19_c_ri_freq_3
	pbp_b19a_reduct_cost_yn
	pbp_b19b_add_cost_yn
	pbp_b19c_conins_enrol_yn
	pbp_b19c_copay_enrol_yn
	pbp_b19c_conins_resp_enrol_yn
	pbp_b19c_copay_resp_enrol_yn
	pbp_b19c_conins_enrol2_yn
	pbp_b19c_copay_enrol2_yn
	pbp_b19c_conins_resp_enrol2_yn
	pbp_b19c_copay_resp_enrol2_yn
	pbp_b19c_mand_supp_ben_yn
	pbp_b19c_hosp_supp_ben_cont_yn
	pbp_b19c_cov_hlth_rltd_yn
	pbp_b19c_tmp_cov_res_fac_yn
	pbp_b19c_red_cost_shar_yn
	pbp_b19c_oth_man_supp_ben_yn
/ missing;
run;

proc contents data = out.pbp_b19;
  title 'pbp_b19 data';
run;