*pbp_b18_b19b_hearing_exams_aids_vbid_uf.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b18_vbid;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	pbp_vbid_group_id                $2
	pbp_b18a_bendesc_yn              $1
	pbp_b18a_bendesc_ehc             $2
	pbp_b18a_bendesc_amo_rht         $1
	pbp_b18a_bendesc_lim_rht         $1
	pbp_b18a_bendesc_per_rht         $1
	pbp_b18a_bendesc_amo_fha         $1
	pbp_b18a_bendesc_lim_fha         $1
	pbp_b18a_bendesc_per_fha         $1
	pbp_b18a_maxplan_yn              $1
	pbp_b18a_maxplan_in_oon          $1
	pbp_b18a_maxplan_per             $1
	pbp_b18a_ded_yn                  $1
	pbp_b18a_maxenr_yn               $1
	pbp_b18a_maxenr_per              $1
	pbp_b18a_coins_yn                $1
	pbp_b18a_coins_ehc               $3
	pbp_b18a_copay_yn                $1
	pbp_b18a_copay_ehc               $3
	pbp_b18a_auth_yn                 $1
	pbp_b18a_refer_yn                $1
	pbp_b18b_bendesc_yn              $1
	pbp_b18b_bendesc_ehc             $4
	pbp_b18b_bendesc_amo_at          $1
	pbp_b18b_bendesc_lim_at          $1
	pbp_b18b_bendesc_per_at          $1
	pbp_b18b_bendesc_amo_ie          $1
	pbp_b18b_bendesc_lim_ie          $1
	pbp_b18b_bendesc_per_ie          $1
	pbp_b18b_bendesc_amo_oe          $1
	pbp_b18b_bendesc_lim_oe          $1
	pbp_b18b_bendesc_per_oe          $1
	pbp_b18b_bendesc_amo_ote         $1
	pbp_b18b_bendesc_lim_ote         $1
	pbp_b18b_bendesc_per_ote         $1
	pbp_b18b_maxplan_yn              $1
	pbp_b18b_maxplan_perear          $1
	pbp_b18b_maxplan_type            $1
	pbp_b18b_maxplan_in_oon          $1
	pbp_b18b_maxplan_per             $1
	pbp_b18b_maxenr_yn               $1
	pbp_b18b_maxenr_type             $1
	pbp_b18b_maxenr_per              $1
	pbp_b18b_coins_yn                $1
	pbp_b18b_coins_ehc               $3
	pbp_b18b_copay_yn                $1
	pbp_b18b_copay_ehc               $3
	pbp_b18b_ded_yn                  $1
	pbp_b18b_auth_yn                 $1
	pbp_b18b_refer_yn                $1
;

infile '.\pbp\pbp_b18_b19b_hearing_exams_aids_vbid_uf.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	pbp_vbid_group_id
	pbp_b18a_bendesc_yn
	pbp_b18a_bendesc_ehc
	pbp_b18a_bendesc_amo_rht
	pbp_b18a_bendesc_lim_rht
	pbp_b18a_bendesc_numv_cl
	pbp_b18a_bendesc_per_rht
	pbp_b18a_bendesc_amo_fha
	pbp_b18a_bendesc_lim_fha
	pbp_b18a_bendesc_numv_fha
	pbp_b18a_bendesc_per_fha
	pbp_b18a_maxplan_yn
	pbp_b18a_maxplan_in_oon
	pbp_b18a_maxplan_amt
	pbp_b18a_maxplan_per
	pbp_b18a_ded_yn
	pbp_b18a_ded_amt
	pbp_b18a_maxenr_yn
	pbp_b18a_maxenr_amt
	pbp_b18a_maxenr_per
	pbp_b18a_coins_yn
	pbp_b18a_coins_ehc
	pbp_b18a_med_coins_pct
	pbp_b18a_med_coins_pct_max
	pbp_b18a_coins_pct_rht
	pbp_b18a_coins_pct_max_rht
	pbp_b18a_coins_pct_fha
	pbp_b18a_coins_pct_max_fha
	pbp_b18a_copay_yn
	pbp_b18a_copay_ehc
	pbp_b18a_copay_amt
	pbp_b18a_med_copay_amt_max
	pbp_b18a_copay_amt_rht
	pbp_b18a_copay_amt_max_rht
	pbp_b18a_copay_amt_fha
	pbp_b18a_copay_amt_max_fha
	pbp_b18a_auth_yn
	pbp_b18a_refer_yn
	pbp_b18b_bendesc_yn
	pbp_b18b_bendesc_ehc
	pbp_b18b_bendesc_amo_at
	pbp_b18b_bendesc_lim_at
	pbp_b18b_bendesc_numv_at
	pbp_b18b_bendesc_per_at
	pbp_b18b_bendesc_amo_ie
	pbp_b18b_bendesc_lim_ie
	pbp_b18b_bendesc_numv_ie
	pbp_b18b_bendesc_per_ie
	pbp_b18b_bendesc_amo_oe
	pbp_b18b_bendesc_lim_oe
	pbp_b18b_bendesc_numv_oe
	pbp_b18b_bendesc_per_oe
	pbp_b18b_bendesc_amo_ote
	pbp_b18b_bendesc_lim_ote
	pbp_b18b_bendesc_numv_ote
	pbp_b18b_bendesc_per_ote
	pbp_b18b_maxplan_yn
	pbp_b18b_maxplan_perear
	pbp_b18b_maxplan_type
	pbp_b18b_maxplan_in_oon
	pbp_b18b_maxplan_amt
	pbp_b18b_maxplan_per
	pbp_b18b_maxenr_yn
	pbp_b18b_maxenr_type
	pbp_b18b_maxenr_amt
	pbp_b18b_maxenr_per
	pbp_b18b_coins_yn
	pbp_b18b_coins_ehc
	pbp_b18b_coins_pct_at_min
	pbp_b18b_coins_pct_at_max
	pbp_b18b_coins_pct_ie_min
	pbp_b18b_coins_pct_ie_max
	pbp_b18b_coins_pct_oe_min
	pbp_b18b_coins_pct_oe_max
	pbp_b18b_coins_pct_ote_min
	pbp_b18b_coins_pct_ote_max
	pbp_b18b_copay_yn
	pbp_b18b_copay_ehc
	pbp_b18b_copay_at_min_amt
	pbp_b18b_copay_at_max_amt
	pbp_b18b_copay_amt_per_ie_min
	pbp_b18b_copay_amt_per_ie_max
	pbp_b18b_copay_amt_p2_ie_min
	pbp_b18b_copay_amt_p2_ie_max
	pbp_b18b_copay_amt_per_oe_min
	pbp_b18b_copay_amt_per_oe_max
	pbp_b18b_copay_amt_p2_oe_min
	pbp_b18b_copay_amt_p2_oe_max
	pbp_b18b_copay_amt_per_ote_min
	pbp_b18b_copay_amt_per_ote_max
	pbp_b18b_copay_amt_p2_ote_min
	pbp_b18b_copay_amt_p2_ote_max
	pbp_b18b_ded_yn
	pbp_b18b_ded_amt
	pbp_b18b_auth_yn
	pbp_b18b_refer_yn
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	pbp_vbid_group_id                = 'B19 VBID Group (Package) ID'
	pbp_b18a_bendesc_yn              = 'Hearing Exams Ben Desc YN'
	pbp_b18a_bendesc_ehc             = 'Hearing Exams Ben Desc Enhance'
	pbp_b18a_bendesc_amo_rht         = 'Hearing Exams RHT Ben Desc AMO'
	pbp_b18a_bendesc_lim_rht         = 'Hearing Exams RHT Ben Desc Lim'
	pbp_b18a_bendesc_numv_cl         = 'Hearing Exams RHT Ben Desc Num'
	pbp_b18a_bendesc_per_rht         = 'Hearing Exams RHT Ben Desc Per'
	pbp_b18a_bendesc_amo_fha         = 'Hearing Exams FHA Ben Desc AMO'
	pbp_b18a_bendesc_lim_fha         = 'Hearing Exams FHA Ben Desc Lim'
	pbp_b18a_bendesc_numv_fha        = 'Hearing Exams FHA Ben Desc Num'
	pbp_b18a_bendesc_per_fha         = 'Hearing Exams FHA Ben Desc Per'
	pbp_b18a_maxplan_yn              = 'Hearing Exams Max Plan YN'
	pbp_b18a_maxplan_in_oon          = 'In or Out'
	pbp_b18a_maxplan_amt             = 'Hearing Exams Max Plan Amt'
	pbp_b18a_maxplan_per             = 'Hearing Exams Max Plan Per'
	pbp_b18a_ded_yn                  = 'Hearing Exams Deductible YN'
	pbp_b18a_ded_amt                 = 'Hearing Exams Deductible Amt'
	pbp_b18a_maxenr_yn               = 'Hearing Exams Max Enr YN'
	pbp_b18a_maxenr_amt              = 'Hearing Exams Max Enr Amt'
	pbp_b18a_maxenr_per              = 'Hearing Exams Max Enr Per'
	pbp_b18a_coins_yn                = 'Hearing Exams Coinsurance YN'
	pbp_b18a_coins_ehc               = 'Hearing Exam Benefits Coins'
	pbp_b18a_med_coins_pct           = 'Hearing Exams MC Coins Min Pct'
	pbp_b18a_med_coins_pct_max       = 'Hearing Exams MC Coins Max Pct'
	pbp_b18a_coins_pct_rht           = 'Hearing Exms RHT Min Coins Pct'
	pbp_b18a_coins_pct_max_rht       = 'Hearing Exms RHT Max Coins Pct'
	pbp_b18a_coins_pct_fha           = 'Hearing Exms FHA Min Coins Pct'
	pbp_b18a_coins_pct_max_fha       = 'Hearing Exms FHA Max Coins Pct'
	pbp_b18a_copay_yn                = 'Hearing Exams Copayment YN'
	pbp_b18a_copay_ehc               = 'Hearing Exam Benefits Copay'
	pbp_b18a_copay_amt               = 'Hearing Exams MC Min Copay Amt'
	pbp_b18a_med_copay_amt_max       = 'Hearing Exams MC Max Copay Amt'
	pbp_b18a_copay_amt_rht           = 'Hearing Exms RHT Min Copay Amt'
	pbp_b18a_copay_amt_max_rht       = 'Hearing Exms RHT Max Copay Amt'
	pbp_b18a_copay_amt_fha           = 'Hearing Exms FHA Min Copay Amt'
	pbp_b18a_copay_amt_max_fha       = 'Hearing Exms FHA Max Copay Amt'
	pbp_b18a_auth_yn                 = 'Hearing Exams Enrollee Auth'
	pbp_b18a_refer_yn                = 'Hearing Exams Referral YN'
	pbp_b18b_bendesc_yn              = 'Hearing Aids Ben Desc YN'
	pbp_b18b_bendesc_ehc             = 'Hearing Aids Ben Desc Enhance'
	pbp_b18b_bendesc_amo_at          = 'Hearing Aids AT Ben Desc AMO'
	pbp_b18b_bendesc_lim_at          = 'Hearing Aids AT Ben Desc Lim'
	pbp_b18b_bendesc_numv_at         = 'Hearing Aids AT Ben Desc Num'
	pbp_b18b_bendesc_per_at          = 'Hearing Aids AT Ben Desc Per'
	pbp_b18b_bendesc_amo_ie          = 'Hearing Aids IE Ben Desc AMO'
	pbp_b18b_bendesc_lim_ie          = 'Hearing Aids IE Ben Desc Lim'
	pbp_b18b_bendesc_numv_ie         = 'Hearing Aids IE Ben Desc Num'
	pbp_b18b_bendesc_per_ie          = 'Hearing Aids IE Ben Desc Per'
	pbp_b18b_bendesc_amo_oe          = 'Hearing Aids OE Ben Desc AMO'
	pbp_b18b_bendesc_lim_oe          = 'Hearing Aids OE Ben Desc Lim'
	pbp_b18b_bendesc_numv_oe         = 'Hearing Aids OE Ben Desc Num'
	pbp_b18b_bendesc_per_oe          = 'Hearing Aids OE Ben Desc Per'
	pbp_b18b_bendesc_amo_ote         = 'Hearing Aids OTE Ben Desc AMO'
	pbp_b18b_bendesc_lim_ote         = 'Hearing Aids OTE Ben Desc Lim'
	pbp_b18b_bendesc_numv_ote        = 'Hearing Aids OTE Ben Desc Num'
	pbp_b18b_bendesc_per_ote         = 'Hearing Aids OTE Ben Desc Per'
	pbp_b18b_maxplan_yn              = 'Hearing Aids Max Plan YN'
	pbp_b18b_maxplan_perear          = 'B18B Maxplan Per Ear'
	pbp_b18b_maxplan_type            = 'Hearing Aids Max Plan Type'
	pbp_b18b_maxplan_in_oon          = 'In or Out'
	pbp_b18b_maxplan_amt             = 'Hearing Aids Max Plan Amt'
	pbp_b18b_maxplan_per             = 'Hearing Aids Max Plan Per'
	pbp_b18b_maxenr_yn               = 'Hearing Aids Max Enr YN'
	pbp_b18b_maxenr_type             = 'Hearing Aids Max Enr Type'
	pbp_b18b_maxenr_amt              = 'Hearing Aids Max Enr Amt'
	pbp_b18b_maxenr_per              = 'Hearing Aids Max Enr Per'
	pbp_b18b_coins_yn                = 'Hearing Aids Coinsurance YN'
	pbp_b18b_coins_ehc               = 'Hearing Aids Benefits Coins'
	pbp_b18b_coins_pct_at_min        = 'Hear Aids AT Min Coins Pct'
	pbp_b18b_coins_pct_at_max        = 'Hear Aids AT Max Coins Pct'
	pbp_b18b_coins_pct_ie_min        = 'Hearing Aids IE Min Coins Pct'
	pbp_b18b_coins_pct_ie_max        = 'Hearing Aids IE Max Coins Pct'
	pbp_b18b_coins_pct_oe_min        = 'Hearing Aids IE Min Coins Pct'
	pbp_b18b_coins_pct_oe_max        = 'Hearing Aids IE Max Coins Pct'
	pbp_b18b_coins_pct_ote_min       = 'Hearing Aids OTE Min Coins Pct'
	pbp_b18b_coins_pct_ote_max       = 'Hearing Aids OTE Max Coins Pct'
	pbp_b18b_copay_yn                = 'Hearing Aids Copayment YN'
	pbp_b18b_copay_ehc               = 'Hearing Aids Benefits Copay'
	pbp_b18b_copay_at_min_amt        = 'Hearing Aids AT Min Copay Amt'
	pbp_b18b_copay_at_max_amt        = 'Hearing Aids AT Max Copay Amt'
	pbp_b18b_copay_amt_per_ie_min    = 'Hearing Aids IE Min Copay Amt'
	pbp_b18b_copay_amt_per_ie_max    = 'Hearing Aids IE Max Copay Amt'
	pbp_b18b_copay_amt_p2_ie_min     = 'Hear Aids 2 IE Min Copay Amt'
	pbp_b18b_copay_amt_p2_ie_max     = 'Hear Aids 2 IE Max Copay Amt'
	pbp_b18b_copay_amt_per_oe_min    = 'Hearing Aids OE Min Copay Amt'
	pbp_b18b_copay_amt_per_oe_max    = 'Hearing Aids OE Max Copay Amt'
	pbp_b18b_copay_amt_p2_oe_min     = 'Hear Aids 2 OE Min Copay Amt'
	pbp_b18b_copay_amt_p2_oe_max     = 'Hear Aids 2 OE Max Copay Amt'
	pbp_b18b_copay_amt_per_ote_min   = 'Hearing Aids OTE Min Copay Amt'
	pbp_b18b_copay_amt_per_ote_max   = 'Hearing Aids OTE Max Copay Amt'
	pbp_b18b_copay_amt_p2_ote_min    = 'Hear Aids 2 OTE Min Copay Amt'
	pbp_b18b_copay_amt_p2_ote_max    = 'Hear Aids 2 OTE Max Copay Amt'
	pbp_b18b_ded_yn                  = 'Hearing Aids Deductible YN'
	pbp_b18b_ded_amt                 = 'Hearing Aids Deductible Amt'
	pbp_b18b_auth_yn                 = 'Hearing Aids Enrollee Auth'
	pbp_b18b_refer_yn                = 'Hearing Aids Referral YN'
;

run;

proc sort data = pbp_b18_vbid out=out.pbp_b18_vbid;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_b18_vbid(obs = 10);
  title 'pbp_b18_b19b_hearing_exams_aids_vbid_uf file ';
run;

proc means data = out.pbp_b18_vbid;
  title 'pbp_b18_b19b_hearing_exams_aids_vbid_uf file ';
run;

proc freq data = out.pbp_b18_vbid;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	pbp_vbid_group_id
	pbp_b18a_bendesc_yn
	pbp_b18a_bendesc_ehc
	pbp_b18a_bendesc_amo_rht
	pbp_b18a_bendesc_lim_rht
	pbp_b18a_bendesc_per_rht
	pbp_b18a_bendesc_amo_fha
	pbp_b18a_bendesc_lim_fha
	pbp_b18a_bendesc_per_fha
	pbp_b18a_maxplan_yn
	pbp_b18a_maxplan_in_oon
	pbp_b18a_maxplan_per
	pbp_b18a_ded_yn
	pbp_b18a_maxenr_yn
	pbp_b18a_maxenr_per
	pbp_b18a_coins_yn
	pbp_b18a_coins_ehc
	pbp_b18a_copay_yn
	pbp_b18a_copay_ehc
	pbp_b18a_auth_yn
	pbp_b18a_refer_yn
	pbp_b18b_bendesc_yn
	pbp_b18b_bendesc_ehc
	pbp_b18b_bendesc_amo_at
	pbp_b18b_bendesc_lim_at
	pbp_b18b_bendesc_per_at
	pbp_b18b_bendesc_amo_ie
	pbp_b18b_bendesc_lim_ie
	pbp_b18b_bendesc_per_ie
	pbp_b18b_bendesc_amo_oe
	pbp_b18b_bendesc_lim_oe
	pbp_b18b_bendesc_per_oe
	pbp_b18b_bendesc_amo_ote
	pbp_b18b_bendesc_lim_ote
	pbp_b18b_bendesc_per_ote
	pbp_b18b_maxplan_yn
	pbp_b18b_maxplan_perear
	pbp_b18b_maxplan_type
	pbp_b18b_maxplan_in_oon
	pbp_b18b_maxplan_per
	pbp_b18b_maxenr_yn
	pbp_b18b_maxenr_type
	pbp_b18b_maxenr_per
	pbp_b18b_coins_yn
	pbp_b18b_coins_ehc
	pbp_b18b_copay_yn
	pbp_b18b_copay_ehc
	pbp_b18b_ded_yn
	pbp_b18b_auth_yn
	pbp_b18b_refer_yn
/ missing;
run;

proc contents data = out.pbp_b18_vbid;
  title 'pbp_b18_vbid data';
run;