*pbp_mrx_ssm.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_mrx_ssm;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	part_d_model_demo                $1
	part_d_enhncd_cvrg_demo          $1
	mrx_ssm_corridor_yn              $1
	mrx_ssm_rai_yn                   $1
	mrx_ssm_rewards_cnt_rdo          $1
	mrx_ssm_ri_type_1_chk            $3
	mrx_ssm_ri_type_1_other          $200
	mrx_ssm_ri_elig_1_rdo            $1
	mrx_ssm_elig_freq_1_other        $200
	mrx_ssm_eligcrit_1_chk           $5
	mrx_ssm_eligcrit_1_other         $200
	mrx_ssm_adher_1_goal             $1
	mrx_ssm_adher_goal_1_desc        $200
	mrx_ssm_ri_type_2_chk            $3
	mrx_ssm_ri_type_2_other          $200
	mrx_ssm_ri_elig_2_rdo            $1
	mrx_ssm_elig_freq_2_other        $200
	mrx_ssm_eligcrit_2_chk           $5
	mrx_ssm_eligcrit_2_other         $200
	mrx_ssm_adher_2_goal             $1
	mrx_ssm_adher_goal_2_desc        $200
	mrx_ssm_insulin_yn               $1
	mrx_ssm_cohorts_cnt_rdo          $1
	mrx_ssm_srcs_chk                 $3
	mrx_ssm_prcs_chk                 $3
	mrx_ssm_oonp_chk                 $2
	mrx_ssm_smocs_chk                $3
	mrx_ssm_pmocs_chk                $3
	mrx_ssm_ltcp_chk                 $1
	mrx_ssm_cui_tiers_1_chk          $7
	mrx_ssm_cui_tiers_2_chk          $7
	mrx_ssm_cui_tiers_3_chk          $7
	mrx_ssm_cui_tiers_4_chk          $7
	mrx_ssm_cui_tiers_5_chk          $7
;

infile '.\pbp\pbp_mrx_ssm.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	part_d_model_demo
	part_d_enhncd_cvrg_demo
	mrx_ssm_corridor_yn
	mrx_ssm_rai_yn
	mrx_ssm_rewards_cnt_rdo
	mrx_ssm_ri_type_1_chk
	mrx_ssm_ri_type_1_other
	mrx_ssm_ri_1_amt
	mrx_ssm_ri_elig_1_rdo
	mrx_ssm_elig_freq_1_other
	mrx_ssm_ri_max_1_amt
	mrx_ssm_eligcrit_1_chk
	mrx_ssm_eligcrit_1_other
	mrx_ssm_adher_1_goal
	mrx_ssm_adher_goal_1_desc
	mrx_ssm_ri_type_2_chk
	mrx_ssm_ri_type_2_other
	mrx_ssm_ri_2_amt
	mrx_ssm_ri_elig_2_rdo
	mrx_ssm_elig_freq_2_other
	mrx_ssm_ri_max_2_amt
	mrx_ssm_eligcrit_2_chk
	mrx_ssm_eligcrit_2_other
	mrx_ssm_adher_2_goal
	mrx_ssm_adher_goal_2_desc
	mrx_ssm_insulin_yn
	mrx_ssm_cohorts_cnt_rdo
	mrx_ssm_srcs_chk
	mrx_ssm_prcs_chk
	mrx_ssm_oonp_chk
	mrx_ssm_smocs_chk
	mrx_ssm_pmocs_chk
	mrx_ssm_ltcp_chk
	mrx_ssm_cui_tiers_1_chk
	mrx_ssm_srcs_copay_1m_1_num
	mrx_ssm_srcs_coins_1m_1_num
	mrx_ssm_srcs_copay_2m_1_num
	mrx_ssm_srcs_coins_2m_1_num
	mrx_ssm_srcs_copay_3m_1_num
	mrx_ssm_srcs_coins_3m_1_num
	mrx_ssm_prcs_copay_1m_1_num
	mrx_ssm_prcs_coins_1m_1_num
	mrx_ssm_prcs_copay_2m_1_num
	mrx_ssm_prcs_coins_2m_1_num
	mrx_ssm_prcs_copay_3m_1_num
	mrx_ssm_prcs_coins_3m_1_num
	mrx_ssm_oonp_copay_1m_1_num
	mrx_ssm_oonp_coins_1m_1_num
	mrx_ssm_oonp_copay_oth_1_num
	mrx_ssm_oonp_coins_oth_1_num
	mrx_ssm_smocs_copay_1m_1_num
	mrx_ssm_smocs_coins_1m_1_num
	mrx_ssm_smocs_copay_2m_1_num
	mrx_ssm_smocs_coins_2m_1_num
	mrx_ssm_smocs_copay_3m_1_num
	mrx_ssm_smocs_coins_3m_1_num
	mrx_ssm_pmocs_copay_1m_1_num
	mrx_ssm_pmocs_coins_1m_1_num
	mrx_ssm_pmocs_copay_2m_1_num
	mrx_ssm_pmocs_coins_2m_1_num
	mrx_ssm_pmocs_copay_3m_1_num
	mrx_ssm_pmocs_coins_3m_1_num
	mrx_ssm_ltcp_copay_1m_1_num
	mrx_ssm_ltcp_coins_1m_1_num
	mrx_ssm_cui_tiers_2_chk
	mrx_ssm_srcs_copay_1m_2_num
	mrx_ssm_srcs_coins_1m_2_num
	mrx_ssm_srcs_copay_2m_2_num
	mrx_ssm_srcs_coins_2m_2_num
	mrx_ssm_srcs_copay_3m_2_num
	mrx_ssm_srcs_coins_3m_2_num
	mrx_ssm_prcs_copay_1m_2_num
	mrx_ssm_prcs_coins_1m_2_num
	mrx_ssm_prcs_copay_2m_2_num
	mrx_ssm_prcs_coins_2m_2_num
	mrx_ssm_prcs_copay_3m_2_num
	mrx_ssm_prcs_coins_3m_2_num
	mrx_ssm_oonp_copay_1m_2_num
	mrx_ssm_oonp_coins_1m_2_num
	mrx_ssm_oonp_copay_oth_2_num
	mrx_ssm_oonp_coins_oth_2_num
	mrx_ssm_smocs_copay_1m_2_num
	mrx_ssm_smocs_coins_1m_2_num
	mrx_ssm_smocs_copay_2m_2_num
	mrx_ssm_smocs_coins_2m_2_num
	mrx_ssm_smocs_copay_3m_2_num
	mrx_ssm_smocs_coins_3m_2_num
	mrx_ssm_pmocs_copay_1m_2_num
	mrx_ssm_pmocs_coins_1m_2_num
	mrx_ssm_pmocs_copay_2m_2_num
	mrx_ssm_pmocs_coins_2m_2_num
	mrx_ssm_pmocs_copay_3m_2_num
	mrx_ssm_pmocs_coins_3m_2_num
	mrx_ssm_ltcp_copay_1m_2_num
	mrx_ssm_ltcp_coins_1m_2_num
	mrx_ssm_cui_tiers_3_chk
	mrx_ssm_srcs_copay_1m_3_num
	mrx_ssm_srcs_coins_1m_3_num
	mrx_ssm_srcs_copay_2m_3_num
	mrx_ssm_srcs_coins_2m_3_num
	mrx_ssm_srcs_copay_3m_3_num
	mrx_ssm_srcs_coins_3m_3_num
	mrx_ssm_prcs_copay_1m_3_num
	mrx_ssm_prcs_coins_1m_3_num
	mrx_ssm_prcs_copay_2m_3_num
	mrx_ssm_prcs_coins_2m_3_num
	mrx_ssm_prcs_copay_3m_3_num
	mrx_ssm_prcs_coins_3m_3_num
	mrx_ssm_oonp_copay_1m_3_num
	mrx_ssm_oonp_coins_1m_3_num
	mrx_ssm_oonp_copay_oth_3_num
	mrx_ssm_oonp_coins_oth_3_num
	mrx_ssm_smocs_copay_1m_3_num
	mrx_ssm_smocs_coins_1m_3_num
	mrx_ssm_smocs_copay_2m_3_num
	mrx_ssm_smocs_coins_2m_3_num
	mrx_ssm_smocs_copay_3m_3_num
	mrx_ssm_smocs_coins_3m_3_num
	mrx_ssm_pmocs_copay_1m_3_num
	mrx_ssm_pmocs_coins_1m_3_num
	mrx_ssm_pmocs_copay_2m_3_num
	mrx_ssm_pmocs_coins_2m_3_num
	mrx_ssm_pmocs_copay_3m_3_num
	mrx_ssm_pmocs_coins_3m_3_num
	mrx_ssm_ltcp_copay_1m_3_num
	mrx_ssm_ltcp_coins_1m_3_num
	mrx_ssm_cui_tiers_4_chk
	mrx_ssm_srcs_copay_1m_4_num
	mrx_ssm_srcs_coins_1m_4_num
	mrx_ssm_srcs_copay_2m_4_num
	mrx_ssm_srcs_coins_2m_4_num
	mrx_ssm_srcs_copay_3m_4_num
	mrx_ssm_srcs_coins_3m_4_num
	mrx_ssm_prcs_copay_1m_4_num
	mrx_ssm_prcs_coins_1m_4_num
	mrx_ssm_prcs_copay_2m_4_num
	mrx_ssm_prcs_coins_2m_4_num
	mrx_ssm_prcs_copay_3m_4_num
	mrx_ssm_prcs_coins_3m_4_num
	mrx_ssm_oonp_copay_1m_4_num
	mrx_ssm_oonp_coins_1m_4_num
	mrx_ssm_oonp_copay_oth_4_num
	mrx_ssm_oonp_coins_oth_4_num
	mrx_ssm_smocs_copay_1m_4_num
	mrx_ssm_smocs_coins_1m_4_num
	mrx_ssm_smocs_copay_2m_4_num
	mrx_ssm_smocs_coins_2m_4_num
	mrx_ssm_smocs_copay_3m_4_num
	mrx_ssm_smocs_coins_3m_4_num
	mrx_ssm_pmocs_copay_1m_4_num
	mrx_ssm_pmocs_coins_1m_4_num
	mrx_ssm_pmocs_copay_2m_4_num
	mrx_ssm_pmocs_coins_2m_4_num
	mrx_ssm_pmocs_copay_3m_4_num
	mrx_ssm_pmocs_coins_3m_4_num
	mrx_ssm_ltcp_copay_1m_4_num
	mrx_ssm_ltcp_coins_1m_4_num
	mrx_ssm_cui_tiers_5_chk
	mrx_ssm_srcs_copay_1m_5_num
	mrx_ssm_srcs_coins_1m_5_num
	mrx_ssm_srcs_copay_2m_5_num
	mrx_ssm_srcs_coins_2m_5_num
	mrx_ssm_srcs_copay_3m_5_num
	mrx_ssm_srcs_coins_3m_5_num
	mrx_ssm_prcs_copay_1m_5_num
	mrx_ssm_prcs_coins_1m_5_num
	mrx_ssm_prcs_copay_2m_5_num
	mrx_ssm_prcs_coins_2m_5_num
	mrx_ssm_prcs_copay_3m_5_num
	mrx_ssm_prcs_coins_3m_5_num
	mrx_ssm_oonp_copay_1m_5_num
	mrx_ssm_oonp_coins_1m_5_num
	mrx_ssm_oonp_copay_oth_5_num
	mrx_ssm_oonp_coins_oth_5_num
	mrx_ssm_smocs_copay_1m_5_num
	mrx_ssm_smocs_coins_1m_5_num
	mrx_ssm_smocs_copay_2m_5_num
	mrx_ssm_smocs_coins_2m_5_num
	mrx_ssm_smocs_copay_3m_5_num
	mrx_ssm_smocs_coins_3m_5_num
	mrx_ssm_pmocs_copay_1m_5_num
	mrx_ssm_pmocs_coins_1m_5_num
	mrx_ssm_pmocs_copay_2m_5_num
	mrx_ssm_pmocs_coins_2m_5_num
	mrx_ssm_pmocs_copay_3m_5_num
	mrx_ssm_pmocs_coins_3m_5_num
	mrx_ssm_ltcp_copay_1m_5_num
	mrx_ssm_ltcp_coins_1m_5_num
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	part_d_model_demo                = 'Part D Model Demo'
	part_d_enhncd_cvrg_demo          = 'Part D Senior Savings Model'
	mrx_ssm_corridor_yn              = 'PDSS 1st Risk Corridor'
	mrx_ssm_rai_yn                   = 'PDSS Offering RAI'
	mrx_ssm_rewards_cnt_rdo          = 'SSM R&I Cnt'
	mrx_ssm_ri_type_1_chk            = 'PDSS RAI Type'
	mrx_ssm_ri_type_1_other          = 'PDSS RAI Other Type'
	mrx_ssm_ri_1_amt                 = 'PDSS RAI Amount'
	mrx_ssm_ri_elig_1_rdo            = 'PDSS RAI Frequency'
	mrx_ssm_elig_freq_1_other        = 'PDSS RAI Freq Other'
	mrx_ssm_ri_max_1_amt             = 'PDSS RAI Max Amount'
	mrx_ssm_eligcrit_1_chk           = 'PDSS Elig Type'
	mrx_ssm_eligcrit_1_other         = 'PDSS Elig Other'
	mrx_ssm_adher_1_goal             = 'PDSS Meets Goal'
	mrx_ssm_adher_goal_1_desc        = 'PDSS Goal Desc'
	mrx_ssm_ri_type_2_chk            = 'PDSS RAI Type'
	mrx_ssm_ri_type_2_other          = 'PDSS RAI Other Type'
	mrx_ssm_ri_2_amt                 = 'PDSS RAI Amount'
	mrx_ssm_ri_elig_2_rdo            = 'PDSS RAI Frequency'
	mrx_ssm_elig_freq_2_other        = 'PDSS RAI Freq Other'
	mrx_ssm_ri_max_2_amt             = 'PDSS RAI Max Amount'
	mrx_ssm_eligcrit_2_chk           = 'PDSS Elig Type'
	mrx_ssm_eligcrit_2_other         = 'PDSS Elig Other'
	mrx_ssm_adher_2_goal             = 'PDSS Meets Goal'
	mrx_ssm_adher_goal_2_desc        = 'PDSS Goal Desc'
	mrx_ssm_insulin_yn               = 'PDSS Insulin'
	mrx_ssm_cohorts_cnt_rdo          = 'PDSS Cohorts'
	mrx_ssm_srcs_chk                 = 'PDSS StdRet CS'
	mrx_ssm_prcs_chk                 = 'PDSS PrefRet CS'
	mrx_ssm_oonp_chk                 = 'PDSS OoN Pharm'
	mrx_ssm_smocs_chk                = 'PDSS Std MO'
	mrx_ssm_pmocs_chk                = 'PDSS StdPref MO'
	mrx_ssm_ltcp_chk                 = 'PDSS LTC Pharm'
	mrx_ssm_cui_tiers_1_chk          = 'PDSS RxTiers1'
	mrx_ssm_srcs_copay_1m_1_num      = 'SRCS 1m sup copay'
	mrx_ssm_srcs_coins_1m_1_num      = 'SRCS 1m sup coins'
	mrx_ssm_srcs_copay_2m_1_num      = 'SRCS 2m sup copay'
	mrx_ssm_srcs_coins_2m_1_num      = 'SRCS 2m sup coins'
	mrx_ssm_srcs_copay_3m_1_num      = 'SRCS 3m sup copay'
	mrx_ssm_srcs_coins_3m_1_num      = 'SRCS 3m sup coins'
	mrx_ssm_prcs_copay_1m_1_num      = 'PRCS 1m sup copay'
	mrx_ssm_prcs_coins_1m_1_num      = 'PRCS 1m sup coins'
	mrx_ssm_prcs_copay_2m_1_num      = 'PRCS 2m sup copay'
	mrx_ssm_prcs_coins_2m_1_num      = 'PRCS 2m sup coins'
	mrx_ssm_prcs_copay_3m_1_num      = 'PRCS 3m sup copay'
	mrx_ssm_prcs_coins_3m_1_num      = 'PRCS 3m sup coins'
	mrx_ssm_oonp_copay_1m_1_num      = 'OON Pharm 1m sup copay'
	mrx_ssm_oonp_coins_1m_1_num      = 'OON Pharm 1m sup coins'
	mrx_ssm_oonp_copay_oth_1_num     = 'OON Pharm oth sup copay'
	mrx_ssm_oonp_coins_oth_1_num     = 'OON Pharm oth sup coins'
	mrx_ssm_smocs_copay_1m_1_num     = 'Std MO CS 1m sup copay'
	mrx_ssm_smocs_coins_1m_1_num     = 'Std MO CS 1m sup coins'
	mrx_ssm_smocs_copay_2m_1_num     = 'Std MO CS 2m sup copay'
	mrx_ssm_smocs_coins_2m_1_num     = 'Std MO CS 2m sup coins'
	mrx_ssm_smocs_copay_3m_1_num     = 'Std MO CS 3m sup copay'
	mrx_ssm_smocs_coins_3m_1_num     = 'Std MO CS 3m sup coins'
	mrx_ssm_pmocs_copay_1m_1_num     = 'Pref MO CS 1m sup copay'
	mrx_ssm_pmocs_coins_1m_1_num     = 'Pref MO CS 1m sup coins'
	mrx_ssm_pmocs_copay_2m_1_num     = 'Pref MO CS 2m sup copay'
	mrx_ssm_pmocs_coins_2m_1_num     = 'Pref MO CS 2m sup coins'
	mrx_ssm_pmocs_copay_3m_1_num     = 'Pref MO CS 3m sup copay'
	mrx_ssm_pmocs_coins_3m_1_num     = 'Pref MO CS 3m sup coins'
	mrx_ssm_ltcp_copay_1m_1_num      = 'LTC Pharm 1m sup copay'
	mrx_ssm_ltcp_coins_1m_1_num      = 'LTC Pharm 1m sup coins'
	mrx_ssm_cui_tiers_2_chk          = 'PDSS RxTiers1'
	mrx_ssm_srcs_copay_1m_2_num      = 'SRCS 1m sup copay'
	mrx_ssm_srcs_coins_1m_2_num      = 'SRCS 1m sup coins'
	mrx_ssm_srcs_copay_2m_2_num      = 'SRCS 2m sup copay'
	mrx_ssm_srcs_coins_2m_2_num      = 'SRCS 2m sup coins'
	mrx_ssm_srcs_copay_3m_2_num      = 'SRCS 3m sup copay'
	mrx_ssm_srcs_coins_3m_2_num      = 'SRCS 3m sup coins'
	mrx_ssm_prcs_copay_1m_2_num      = 'PRCS 1m sup copay'
	mrx_ssm_prcs_coins_1m_2_num      = 'PRCS 1m sup coins'
	mrx_ssm_prcs_copay_2m_2_num      = 'PRCS 2m sup copay'
	mrx_ssm_prcs_coins_2m_2_num      = 'PRCS 2m sup coins'
	mrx_ssm_prcs_copay_3m_2_num      = 'PRCS 3m sup copay'
	mrx_ssm_prcs_coins_3m_2_num      = 'PRCS 3m sup coins'
	mrx_ssm_oonp_copay_1m_2_num      = 'OON Pharm 1m sup copay'
	mrx_ssm_oonp_coins_1m_2_num      = 'OON Pharm 1m sup coins'
	mrx_ssm_oonp_copay_oth_2_num     = 'OON Pharm oth sup copay'
	mrx_ssm_oonp_coins_oth_2_num     = 'OON Pharm oth sup coins'
	mrx_ssm_smocs_copay_1m_2_num     = 'Std MO CS 1m sup copay'
	mrx_ssm_smocs_coins_1m_2_num     = 'Std MO CS 1m sup coins'
	mrx_ssm_smocs_copay_2m_2_num     = 'Std MO CS 2m sup copay'
	mrx_ssm_smocs_coins_2m_2_num     = 'Std MO CS 2m sup coins'
	mrx_ssm_smocs_copay_3m_2_num     = 'Std MO CS 3m sup copay'
	mrx_ssm_smocs_coins_3m_2_num     = 'Std MO CS 3m sup coins'
	mrx_ssm_pmocs_copay_1m_2_num     = 'Pref MO CS 1m sup copay'
	mrx_ssm_pmocs_coins_1m_2_num     = 'Pref MO CS 1m sup coins'
	mrx_ssm_pmocs_copay_2m_2_num     = 'Pref MO CS 2m sup copay'
	mrx_ssm_pmocs_coins_2m_2_num     = 'Pref MO CS 2m sup coins'
	mrx_ssm_pmocs_copay_3m_2_num     = 'Pref MO CS 3m sup copay'
	mrx_ssm_pmocs_coins_3m_2_num     = 'Pref MO CS 3m sup coins'
	mrx_ssm_ltcp_copay_1m_2_num      = 'LTC Pharm 1m sup copay'
	mrx_ssm_ltcp_coins_1m_2_num      = 'LTC Pharm 1m sup coins'
	mrx_ssm_cui_tiers_3_chk          = 'PDSS RxTiers1'
	mrx_ssm_srcs_copay_1m_3_num      = 'SRCS 1m sup copay'
	mrx_ssm_srcs_coins_1m_3_num      = 'SRCS 1m sup coins'
	mrx_ssm_srcs_copay_2m_3_num      = 'SRCS 2m sup copay'
	mrx_ssm_srcs_coins_2m_3_num      = 'SRCS 2m sup coins'
	mrx_ssm_srcs_copay_3m_3_num      = 'SRCS 3m sup copay'
	mrx_ssm_srcs_coins_3m_3_num      = 'SRCS 3m sup coins'
	mrx_ssm_prcs_copay_1m_3_num      = 'PRCS 1m sup copay'
	mrx_ssm_prcs_coins_1m_3_num      = 'PRCS 1m sup coins'
	mrx_ssm_prcs_copay_2m_3_num      = 'PRCS 2m sup copay'
	mrx_ssm_prcs_coins_2m_3_num      = 'PRCS 2m sup coins'
	mrx_ssm_prcs_copay_3m_3_num      = 'PRCS 3m sup copay'
	mrx_ssm_prcs_coins_3m_3_num      = 'PRCS 3m sup coins'
	mrx_ssm_oonp_copay_1m_3_num      = 'OON Pharm 1m sup copay'
	mrx_ssm_oonp_coins_1m_3_num      = 'OON Pharm 1m sup coins'
	mrx_ssm_oonp_copay_oth_3_num     = 'OON Pharm oth sup copay'
	mrx_ssm_oonp_coins_oth_3_num     = 'OON Pharm oth sup coins'
	mrx_ssm_smocs_copay_1m_3_num     = 'Std MO CS 1m sup copay'
	mrx_ssm_smocs_coins_1m_3_num     = 'Std MO CS 1m sup coins'
	mrx_ssm_smocs_copay_2m_3_num     = 'Std MO CS 2m sup copay'
	mrx_ssm_smocs_coins_2m_3_num     = 'Std MO CS 2m sup coins'
	mrx_ssm_smocs_copay_3m_3_num     = 'Std MO CS 3m sup copay'
	mrx_ssm_smocs_coins_3m_3_num     = 'Std MO CS 3m sup coins'
	mrx_ssm_pmocs_copay_1m_3_num     = 'Pref MO CS 1m sup copay'
	mrx_ssm_pmocs_coins_1m_3_num     = 'Pref MO CS 1m sup coins'
	mrx_ssm_pmocs_copay_2m_3_num     = 'Pref MO CS 2m sup copay'
	mrx_ssm_pmocs_coins_2m_3_num     = 'Pref MO CS 2m sup coins'
	mrx_ssm_pmocs_copay_3m_3_num     = 'Pref MO CS 3m sup copay'
	mrx_ssm_pmocs_coins_3m_3_num     = 'Pref MO CS 3m sup coins'
	mrx_ssm_ltcp_copay_1m_3_num      = 'LTC Pharm 1m sup copay'
	mrx_ssm_ltcp_coins_1m_3_num      = 'LTC Pharm 1m sup coins'
	mrx_ssm_cui_tiers_4_chk          = 'PDSS RxTiers1'
	mrx_ssm_srcs_copay_1m_4_num      = 'SRCS 1m sup copay'
	mrx_ssm_srcs_coins_1m_4_num      = 'SRCS 1m sup coins'
	mrx_ssm_srcs_copay_2m_4_num      = 'SRCS 2m sup copay'
	mrx_ssm_srcs_coins_2m_4_num      = 'SRCS 2m sup coins'
	mrx_ssm_srcs_copay_3m_4_num      = 'SRCS 3m sup copay'
	mrx_ssm_srcs_coins_3m_4_num      = 'SRCS 3m sup coins'
	mrx_ssm_prcs_copay_1m_4_num      = 'PRCS 1m sup copay'
	mrx_ssm_prcs_coins_1m_4_num      = 'PRCS 1m sup coins'
	mrx_ssm_prcs_copay_2m_4_num      = 'PRCS 2m sup copay'
	mrx_ssm_prcs_coins_2m_4_num      = 'PRCS 2m sup coins'
	mrx_ssm_prcs_copay_3m_4_num      = 'PRCS 3m sup copay'
	mrx_ssm_prcs_coins_3m_4_num      = 'PRCS 3m sup coins'
	mrx_ssm_oonp_copay_1m_4_num      = 'OON Pharm 1m sup copay'
	mrx_ssm_oonp_coins_1m_4_num      = 'OON Pharm 1m sup coins'
	mrx_ssm_oonp_copay_oth_4_num     = 'OON Pharm oth sup copay'
	mrx_ssm_oonp_coins_oth_4_num     = 'OON Pharm oth sup coins'
	mrx_ssm_smocs_copay_1m_4_num     = 'Std MO CS 1m sup copay'
	mrx_ssm_smocs_coins_1m_4_num     = 'Std MO CS 1m sup coins'
	mrx_ssm_smocs_copay_2m_4_num     = 'Std MO CS 2m sup copay'
	mrx_ssm_smocs_coins_2m_4_num     = 'Std MO CS 2m sup coins'
	mrx_ssm_smocs_copay_3m_4_num     = 'Std MO CS 3m sup copay'
	mrx_ssm_smocs_coins_3m_4_num     = 'Std MO CS 3m sup coins'
	mrx_ssm_pmocs_copay_1m_4_num     = 'Pref MO CS 1m sup copay'
	mrx_ssm_pmocs_coins_1m_4_num     = 'Pref MO CS 1m sup coins'
	mrx_ssm_pmocs_copay_2m_4_num     = 'Pref MO CS 2m sup copay'
	mrx_ssm_pmocs_coins_2m_4_num     = 'Pref MO CS 2m sup coins'
	mrx_ssm_pmocs_copay_3m_4_num     = 'Pref MO CS 3m sup copay'
	mrx_ssm_pmocs_coins_3m_4_num     = 'Pref MO CS 3m sup coins'
	mrx_ssm_ltcp_copay_1m_4_num      = 'LTC Pharm 1m sup copay'
	mrx_ssm_ltcp_coins_1m_4_num      = 'LTC Pharm 1m sup coins'
	mrx_ssm_cui_tiers_5_chk          = 'PDSS RxTiers1'
	mrx_ssm_srcs_copay_1m_5_num      = 'SRCS 1m sup copay'
	mrx_ssm_srcs_coins_1m_5_num      = 'SRCS 1m sup coins'
	mrx_ssm_srcs_copay_2m_5_num      = 'SRCS 2m sup copay'
	mrx_ssm_srcs_coins_2m_5_num      = 'SRCS 2m sup coins'
	mrx_ssm_srcs_copay_3m_5_num      = 'SRCS 3m sup copay'
	mrx_ssm_srcs_coins_3m_5_num      = 'SRCS 3m sup coins'
	mrx_ssm_prcs_copay_1m_5_num      = 'PRCS 1m sup copay'
	mrx_ssm_prcs_coins_1m_5_num      = 'PRCS 1m sup coins'
	mrx_ssm_prcs_copay_2m_5_num      = 'PRCS 2m sup copay'
	mrx_ssm_prcs_coins_2m_5_num      = 'PRCS 2m sup coins'
	mrx_ssm_prcs_copay_3m_5_num      = 'PRCS 3m sup copay'
	mrx_ssm_prcs_coins_3m_5_num      = 'PRCS 3m sup coins'
	mrx_ssm_oonp_copay_1m_5_num      = 'OON Pharm 1m sup copay'
	mrx_ssm_oonp_coins_1m_5_num      = 'OON Pharm 1m sup coins'
	mrx_ssm_oonp_copay_oth_5_num     = 'OON Pharm oth sup copay'
	mrx_ssm_oonp_coins_oth_5_num     = 'OON Pharm oth sup coins'
	mrx_ssm_smocs_copay_1m_5_num     = 'Std MO CS 1m sup copay'
	mrx_ssm_smocs_coins_1m_5_num     = 'Std MO CS 1m sup coins'
	mrx_ssm_smocs_copay_2m_5_num     = 'Std MO CS 2m sup copay'
	mrx_ssm_smocs_coins_2m_5_num     = 'Std MO CS 2m sup coins'
	mrx_ssm_smocs_copay_3m_5_num     = 'Std MO CS 3m sup copay'
	mrx_ssm_smocs_coins_3m_5_num     = 'Std MO CS 3m sup coins'
	mrx_ssm_pmocs_copay_1m_5_num     = 'Pref MO CS 1m sup copay'
	mrx_ssm_pmocs_coins_1m_5_num     = 'Pref MO CS 1m sup coins'
	mrx_ssm_pmocs_copay_2m_5_num     = 'Pref MO CS 2m sup copay'
	mrx_ssm_pmocs_coins_2m_5_num     = 'Pref MO CS 2m sup coins'
	mrx_ssm_pmocs_copay_3m_5_num     = 'Pref MO CS 3m sup copay'
	mrx_ssm_pmocs_coins_3m_5_num     = 'Pref MO CS 3m sup coins'
	mrx_ssm_ltcp_copay_1m_5_num      = 'LTC Pharm 1m sup copay'
	mrx_ssm_ltcp_coins_1m_5_num      = 'LTC Pharm 1m sup coins'
;

run;

proc sort data = pbp_mrx_ssm out=out.pbp_mrx_ssm;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_mrx_ssm(obs = 10);
  title 'pbp_mrx_ssm file ';
run;

proc means data = out.pbp_mrx_ssm;
  title 'pbp_mrx_ssm file ';
run;

proc freq data = out.pbp_mrx_ssm;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	part_d_model_demo
	part_d_enhncd_cvrg_demo
	mrx_ssm_corridor_yn
	mrx_ssm_rai_yn
	mrx_ssm_rewards_cnt_rdo
	mrx_ssm_ri_type_1_chk
	mrx_ssm_ri_elig_1_rdo
	mrx_ssm_eligcrit_1_chk
	mrx_ssm_adher_1_goal
	mrx_ssm_ri_type_2_chk
	mrx_ssm_ri_elig_2_rdo
	mrx_ssm_eligcrit_2_chk
	mrx_ssm_adher_2_goal
	mrx_ssm_insulin_yn
	mrx_ssm_cohorts_cnt_rdo
	mrx_ssm_srcs_chk
	mrx_ssm_prcs_chk
	mrx_ssm_oonp_chk
	mrx_ssm_smocs_chk
	mrx_ssm_pmocs_chk
	mrx_ssm_ltcp_chk
/ missing;
run;

proc contents data = out.pbp_mrx_ssm;
  title 'pbp_mrx_ssm data';
run;