*pbp_b19b_model_test_vbid_uf.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b19b_vbid;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	pbp_vbid_group_id                $2
	pbp_b19b_package_type            $2
	pbp_b19b_tm_vbid                 $2
	pbp_b19b_states_ehc_vbd          $10
	pbp_b19b_all_dis_yn              $1
	pbp_b19b_cmb_dis_yn              $1
	pbp_b19b_lis_vbid                $5
	pbp_b19b_states_ehc_ssbci        $20
	pbp_b19b_states_ssbci_other1     $72
	pbp_b19b_states_ssbci_other2     $72
	pbp_b19b_states_ssbci_other3     $72
	pbp_b19b_states_ssbci_other4     $72
	pbp_b19b_states_ssbci_other5     $72
	pbp_b19b_states_ehc_uf           $14
	pbp_b19b_states_uf_other1        $72
	pbp_b19b_states_uf_other2        $72
	pbp_b19b_states_uf_other3        $72
	pbp_b19b_states_uf_other4        $72
	pbp_b19b_states_uf_other5        $72
	pbp_b19b_states_uf_all_yn        $1
	pbp_b19b_states_uf_cmb_yn        $1
	pbp_b19b_mmp_yn                  $1
	pbp_b19b_mmp_ehc                 $6
	pbp_b19b_add_prereq_yn           $1
	pbp_b19b_add_prereq              $3
	pbp_b19b_add_nmc_bendesc_cats    $550
	pbp_b19b_add_apply_yn            $1
	pbp_b19b_add_exempt_yn           $1
	pbp_b19b_add_exempt_nmc_cats     $550
	pbp_b19b_agg_yn                  $1
	pbp_b19b_agg_period              $1
	pbp_b19b_agg_nmc_bendesc_cats    $4000
;

infile '.\pbp\pbp_b19b_model_test_vbid_uf.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	pbp_vbid_group_id
	pbp_b19b_package_type
	pbp_b19b_tm_vbid
	pbp_b19b_states_ehc_vbd
	pbp_b19b_all_dis_yn
	pbp_b19b_cmb_dis_yn
	pbp_b19b_lis_vbid
	pbp_b19b_enr_tar_vbid
	pbp_b19b_enr_eng_vbid
	pbp_b19b_states_ehc_ssbci
	pbp_b19b_states_ssbci_other1
	pbp_b19b_states_ssbci_other2
	pbp_b19b_states_ssbci_other3
	pbp_b19b_states_ssbci_other4
	pbp_b19b_states_ssbci_other5
	pbp_b19b_states_ehc_uf
	pbp_b19b_states_uf_other1
	pbp_b19b_states_uf_other2
	pbp_b19b_states_uf_other3
	pbp_b19b_states_uf_other4
	pbp_b19b_states_uf_other5
	pbp_b19b_states_uf_all_yn
	pbp_b19b_states_uf_cmb_yn
	pbp_b19b_mmp_yn
	pbp_b19b_mmp_ehc
	pbp_b19b_add_prereq_yn
	pbp_b19b_add_prereq
	pbp_b19b_add_nmc_bendesc_cats
	pbp_b19b_add_apply_yn
	pbp_b19b_add_exempt_yn
	pbp_b19b_add_exempt_nmc_cats
	pbp_b19b_agg_yn
	pbp_b19b_agg_amt
	pbp_b19b_agg_period
	pbp_b19b_agg_nmc_bendesc_cats
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	pbp_vbid_group_id                = 'B19 VBID Group (Package) ID'
	pbp_b19b_package_type            = 'B19b package type'
	pbp_b19b_tm_vbid                 = '19b VBID Pop Target Method'
	pbp_b19b_states_ehc_vbd          = '19b VBID Pop Diseases'
	pbp_b19b_all_dis_yn              = '19b VBID Pop All Disease YN'
	pbp_b19b_cmb_dis_yn              = '19b VBID Pop Combined Disease'
	pbp_b19b_lis_vbid                = '19b VBID Pop LIS Reduction'
	pbp_b19b_enr_tar_vbid            = '19b VBID Pop # Enroll Target'
	pbp_b19b_enr_eng_vbid            = '19b VBID Pop # Enroll Engaged'
	pbp_b19b_states_ehc_ssbci        = 'SSBCI chronic condition'
	pbp_b19b_states_ssbci_other1     = 'B19B SSBCI disease other 1'
	pbp_b19b_states_ssbci_other2     = 'B19B SSBCI disease other 2'
	pbp_b19b_states_ssbci_other3     = 'B19B SSBCI disease other 3'
	pbp_b19b_states_ssbci_other4     = 'B19B SSBCI disease other 4'
	pbp_b19b_states_ssbci_other5     = 'B19B SSBCI disease other 5'
	pbp_b19b_states_ehc_uf           = 'b19b uf Disease states'
	pbp_b19b_states_uf_other1        = 'B19B UF disease other 1'
	pbp_b19b_states_uf_other2        = 'B19B UF disease other 2'
	pbp_b19b_states_uf_other3        = 'B19B UF disease other 3'
	pbp_b19b_states_uf_other4        = 'B19B UF disease other 4'
	pbp_b19b_states_uf_other5        = 'B19B UF disease other 5'
	pbp_b19b_states_uf_all_yn        = 'Need All Diseases YN'
	pbp_b19b_states_uf_cmb_yn        = 'Need Cmb Diseases YN'
	pbp_b19b_mmp_yn                  = 'B19B MMP Benefits yn'
	pbp_b19b_mmp_ehc                 = 'B19B MMP Bens Ehc'
	pbp_b19b_add_prereq_yn           = 'Additional prerequisite YN'
	pbp_b19b_add_prereq              = 'Additional prerequisite'
	pbp_b19b_add_nmc_bendesc_cats    = 'NMC Rdc Coin Benft Categories'
	pbp_b19b_add_apply_yn            = 'Apply OON/POS YN'
	pbp_b19b_add_exempt_yn           = 'Exempt deduct YN'
	pbp_b19b_add_exempt_nmc_cats     = 'NMC Rdc Coin Benft Categories'
	pbp_b19b_agg_yn                  = 'B19b max benefit amount yn'
	pbp_b19b_agg_amt                 = 'B19b max benefit amount'
	pbp_b19b_agg_period              = 'B19b max benefit period'
	pbp_b19b_agg_nmc_bendesc_cats    = 'B19b max benefit NMC cats'	
;

run;

proc sort data = pbp_b19b_vbid out=out.pbp_b19b_vbid;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_b19b_vbid(obs = 10);
  title 'pbp_b19b_model_test_vbid_uf file ';
run;

proc means data = out.pbp_b19b_vbid;
  title 'pbp_b19b_model_test_vbid_uf file ';
run;

proc freq data = out.pbp_b19b_vbid;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	pbp_vbid_group_id
	pbp_b19b_package_type
	pbp_b19b_tm_vbid
	pbp_b19b_all_dis_yn
	pbp_b19b_cmb_dis_yn
	pbp_b19b_lis_vbid
	pbp_b19b_states_uf_all_yn
	pbp_b19b_states_uf_cmb_yn
	pbp_b19b_mmp_yn
	pbp_b19b_add_prereq_yn
	pbp_b19b_add_prereq
	pbp_b19b_add_apply_yn
	pbp_b19b_add_exempt_yn
	pbp_b19b_agg_yn
	pbp_b19b_agg_period
/ missing;
run;

proc contents data = out.pbp_b19b_vbid;
  title 'pbp_b19b_vbid data';
run;