*pbp_step16b.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_step16b;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	pbp_b16b_bendesc_yn              $1
	pbp_b16b_bendesc_ehc             $7
	pbp_b16b_bendesc_amo_es          $1
	pbp_b16b_bendesc_lim_es          $1
	pbp_b16b_bendesc_per_es          $1
	pbp_b16b_bendesc_amo_ds          $1
	pbp_b16b_bendesc_lim_ds          $1
	pbp_b16b_bendesc_per_ds          $1
	pbp_b16b_bendesc_amo_rs          $1
	pbp_b16b_bendesc_lim_rs          $1
	pbp_b16b_bendesc_per_rs          $1
	pbp_b16b_bendesc_amo_end         $1
	pbp_b16b_bendesc_lim_end         $1
	pbp_b16b_bendesc_per_end         $1
	pbp_b16b_bendesc_amo_peri        $1
	pbp_b16b_bendesc_lim_peri        $1
	pbp_b16b_bendesc_per_peri        $1
	pbp_b16b_bendesc_amo_ext         $1
	pbp_b16b_bendesc_lim_ext         $1
	pbp_b16b_bendesc_per_ext         $1
	pbp_b16b_bendesc_amo_poo         $1
	pbp_b16b_bendesc_lim_poo         $1
	pbp_b16b_bendesc_per_poo         $1
	pbp_b16b_maxplan_yn              $1
	pbp_b16b_maxplan_in_oon          $1
	pbp_b16b_maxbene_type            $1
	pbp_b16b_maxplan_per             $1
	pbp_b16b_maxplan_per_desc        $200
	pbp_b16b_maxenr_yn               $1
	pbp_b16b_maxenr_type             $1
	pbp_b16b_maxenr_per              $1
	pbp_b16b_maxenr_per_desc         $200
	pbp_b16b_coins_yn                $1
	pbp_b16b_coins_ehc               $8
	pbp_b16b_ded_yn                  $1
	pbp_b16b_copay_yn                $1
	pbp_b16b_copay_ehc               $8
	pbp_b16b_auth_yn                 $1
	pbp_b16b_refer_yn                $1
	pbp_d_opt_identifier             $3
;

infile '.\pbp\pbp_step16b.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	pbp_b16b_bendesc_yn
	pbp_b16b_bendesc_ehc
	pbp_b16b_bendesc_amo_es
	pbp_b16b_bendesc_lim_es
	pbp_b16b_bendesc_numv_es
	pbp_b16b_bendesc_per_es
	pbp_b16b_bendesc_amo_ds
	pbp_b16b_bendesc_lim_ds
	pbp_b16b_bendesc_numv_ds
	pbp_b16b_bendesc_per_ds
	pbp_b16b_bendesc_amo_rs
	pbp_b16b_bendesc_lim_rs
	pbp_b16b_bendesc_numv_rs
	pbp_b16b_bendesc_per_rs
	pbp_b16b_bendesc_amo_end
	pbp_b16b_bendesc_lim_end
	pbp_b16b_bendesc_num_end
	pbp_b16b_bendesc_per_end
	pbp_b16b_bendesc_amo_peri
	pbp_b16b_bendesc_lim_peri
	pbp_b16b_bendesc_num_peri
	pbp_b16b_bendesc_per_peri
	pbp_b16b_bendesc_amo_ext
	pbp_b16b_bendesc_lim_ext
	pbp_b16b_bendesc_num_ext
	pbp_b16b_bendesc_per_ext
	pbp_b16b_bendesc_amo_poo
	pbp_b16b_bendesc_lim_poo
	pbp_b16b_bendesc_numv_poo
	pbp_b16b_bendesc_per_poo
	pbp_b16b_maxplan_yn
	pbp_b16b_maxplan_in_oon
	pbp_b16b_maxbene_type
	pbp_b16b_maxplan_amt
	pbp_b16b_maxplan_per
	pbp_b16b_maxplan_per_desc
	pbp_b16b_maxenr_yn
	pbp_b16b_maxenr_type
	pbp_b16b_maxenr_amt
	pbp_b16b_maxenr_per
	pbp_b16b_maxenr_per_desc
	pbp_b16b_coins_yn
	pbp_b16b_coins_ehc
	pbp_b16b_coins_pct_mc_min
	pbp_b16b_coins_pct_mc_max
	pbp_b16b_coins_pct_es_min
	pbp_b16b_coins_pct_es_max
	pbp_b16b_coins_pct_ds_min
	pbp_b16b_coins_pct_ds_max
	pbp_b16b_coins_pct_rs_min
	pbp_b16b_coins_pct_rs_max
	pbp_b16b_coins_pct_end_min
	pbp_b16b_coins_pct_end_max
	pbp_b16b_coins_pct_peri_min
	pbp_b16b_coins_pct_peri_max
	pbp_b16b_coins_pct_ext_min
	pbp_b16b_coins_pct_ext_max
	pbp_b16b_coins_pct_poo_min
	pbp_b16b_coins_pct_poo_max
	pbp_b16b_ded_yn
	pbp_b16b_ded_amt
	pbp_b16b_copay_yn
	pbp_b16b_copay_ehc
	pbp_b16b_copay_amt_mc_min
	pbp_b16b_copay_amt_mc_max
	pbp_b16b_copay_amt_es_min
	pbp_b16b_copay_amt_es_max
	pbp_b16b_copay_amt_ds_min
	pbp_b16b_copay_amt_ds_max
	pbp_b16b_copay_amt_rs_min
	pbp_b16b_copay_amt_rs_max
	pbp_b16b_copay_amt_end_min
	pbp_b16b_copay_amt_end_max
	pbp_b16b_copay_amt_peri_min
	pbp_b16b_copay_amt_peri_max
	pbp_b16b_copay_amt_ext_min
	pbp_b16b_copay_amt_ext_max
	pbp_b16b_copay_amt_poo_min
	pbp_b16b_copay_amt_poo_max
	pbp_b16b_auth_yn
	pbp_b16b_refer_yn
	pbp_d_opt_identifier
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	pbp_b16b_bendesc_yn              = 'Dental Comp Ben Desc YN'
	pbp_b16b_bendesc_ehc             = 'Dental Comp Ben Desc Enhance'
	pbp_b16b_bendesc_amo_es          = 'Dental Comp NR Ben Desc AMO'
	pbp_b16b_bendesc_lim_es          = 'Dental Comp NR Ben Desc Lim YN'
	pbp_b16b_bendesc_numv_es         = 'Dental Comp NR Ben Desc Num'
	pbp_b16b_bendesc_per_es          = 'Dental Comp NR Ben Desc Per'
	pbp_b16b_bendesc_amo_ds          = 'Dental Comp DS Ben Desc AMO'
	pbp_b16b_bendesc_lim_ds          = 'Dental Comp DS Ben Desc Lim YN'
	pbp_b16b_bendesc_numv_ds         = 'Dental Comp DS Ben Desc Num'
	pbp_b16b_bendesc_per_ds          = 'Dental Comp DS Ben Desc Per'
	pbp_b16b_bendesc_amo_rs          = 'Dental Comp RS Ben Desc AMO'
	pbp_b16b_bendesc_lim_rs          = 'Dental Comp RS Ben Desc Lim YN'
	pbp_b16b_bendesc_numv_rs         = 'Dental Comp RS Ben Desc Num'
	pbp_b16b_bendesc_per_rs          = 'Dental Comp RS Ben Desc Per'
	pbp_b16b_bendesc_amo_end         = 'B16b endodontics Ben Desc AMO'
	pbp_b16b_bendesc_lim_end         = 'B16b endodontic Ben Dsc Lim YN'
	pbp_b16b_bendesc_num_end         = 'B16b endodontics Ben Desc Num'
	pbp_b16b_bendesc_per_end         = 'B16b endodontics Ben Desc Per'
	pbp_b16b_bendesc_amo_peri        = 'B16b periodontics Ben Desc AMO'
	pbp_b16b_bendesc_lim_peri        = 'B16b periodon Ben Dsc Lim YN'
	pbp_b16b_bendesc_num_peri        = 'B16b periodontics Ben Desc Num'
	pbp_b16b_bendesc_per_peri        = 'B16b periodontics Ben Desc Per'
	pbp_b16b_bendesc_amo_ext         = 'B16b extractions Ben Desc AMO'
	pbp_b16b_bendesc_lim_ext         = 'B16b extraction Ben Dsc Lim YN'
	pbp_b16b_bendesc_num_ext         = 'B16b extractions Ben Desc Num'
	pbp_b16b_bendesc_per_ext         = 'B16b extractions Ben Desc Per'
	pbp_b16b_bendesc_amo_poo         = 'Dental Comp POO Ben Desc AMO'
	pbp_b16b_bendesc_lim_poo         = 'Dental Comp POO Ben Dsc Lim YN'
	pbp_b16b_bendesc_numv_poo        = 'Dental Comp POO Ben Desc Num'
	pbp_b16b_bendesc_per_poo         = 'Dental Comp POO Ben Desc Per'
	pbp_b16b_maxplan_yn              = 'Dental Comp Max Plan YN'
	pbp_b16b_maxplan_in_oon          = 'In or Out'
	pbp_b16b_maxbene_type            = 'Dental Comp Max Plan Type'
	pbp_b16b_maxplan_amt             = 'Dental Comp Max Plan Amt'
	pbp_b16b_maxplan_per             = 'Dental Comp Max Plan Per'
	pbp_b16b_maxplan_per_desc        = 'Dental Comp Max Plan Other'
	pbp_b16b_maxenr_yn               = 'Dental Comp Max Enr YN'
	pbp_b16b_maxenr_type             = 'Dental Comp Max Enr Type'
	pbp_b16b_maxenr_amt              = 'Dental Comp Max Enr Amt'
	pbp_b16b_maxenr_per              = 'Dental Comp Max Enr Per'
	pbp_b16b_maxenr_per_desc         = 'Dental Comp Max Enr Other'
	pbp_b16b_coins_yn                = 'Dental Comp Coinsurance YN'
	pbp_b16b_coins_ehc               = 'Comp Dental Srvcs Coins'
	pbp_b16b_coins_pct_mc_min        = 'Dental Comp MC Min Coins Pct'
	pbp_b16b_coins_pct_mc_max        = 'Dental Comp MC Max Coins Pct'
	pbp_b16b_coins_pct_es_min        = 'Dental Comp NR Min Coins Pct'
	pbp_b16b_coins_pct_es_max        = 'Dental Comp NR Max Coins Pct'
	pbp_b16b_coins_pct_ds_min        = 'Dental Comp DS Min Coins Pct'
	pbp_b16b_coins_pct_ds_max        = 'Dental Comp DS Max Coins Pct'
	pbp_b16b_coins_pct_rs_min        = 'Dental Comp RS Min Coins Pct'
	pbp_b16b_coins_pct_rs_max        = 'Dental Comp RS Max Coins Pct'
	pbp_b16b_coins_pct_end_min       = 'B16b endodon Min Coins Pct'
	pbp_b16b_coins_pct_end_max       = 'B16b endodon Max Coins Pct'
	pbp_b16b_coins_pct_peri_min      = 'B16b periodontic Min Coins Pct'
	pbp_b16b_coins_pct_peri_max      = 'B16b periodontic Max Coins Pct'
	pbp_b16b_coins_pct_ext_min       = 'B16b extractions Min Coins Pct'
	pbp_b16b_coins_pct_ext_max       = 'B16b extractions Max Coins Pct'
	pbp_b16b_coins_pct_poo_min       = 'Dental Comp POO Min Coins Pct'
	pbp_b16b_coins_pct_poo_max       = 'Dental Comp POO Max Coins Pct'
	pbp_b16b_ded_yn                  = 'Dental Comp Deductible YN'
	pbp_b16b_ded_amt                 = 'Dental Comp Deductible Amt'
	pbp_b16b_copay_yn                = 'Dental Comp Copayment YN'
	pbp_b16b_copay_ehc               = 'Comp Dental Srvcs Copay'
	pbp_b16b_copay_amt_mc_min        = 'Dental Comp MC Min Copay Amt'
	pbp_b16b_copay_amt_mc_max        = 'Dental Comp MC Max Copay Amt'
	pbp_b16b_copay_amt_es_min        = 'Dental Comp NR Min Copay Amt'
	pbp_b16b_copay_amt_es_max        = 'Dental Comp NR Max Copay Amt'
	pbp_b16b_copay_amt_ds_min        = 'Dental Comp DS Min Copay Amt'
	pbp_b16b_copay_amt_ds_max        = 'Dental Comp DS Max Copay Amt'
	pbp_b16b_copay_amt_rs_min        = 'Dental Comp RS Min Copay Amt'
	pbp_b16b_copay_amt_rs_max        = 'Dental Comp RS Max Copay Amt'
	pbp_b16b_copay_amt_end_min       = 'B16b endodontic Min Copay Amt'
	pbp_b16b_copay_amt_end_max       = 'B16b endodontic Max Copay Amt'
	pbp_b16b_copay_amt_peri_min      = 'B16b periodontic Min Copay Amt'
	pbp_b16b_copay_amt_peri_max      = 'B16b periodontic Max Copay Amt'
	pbp_b16b_copay_amt_ext_min       = 'B16b extraction Min Copay Amt'
	pbp_b16b_copay_amt_ext_max       = 'B16b extraction Max Copay Amt'
	pbp_b16b_copay_amt_poo_min       = 'Dental Comp POO Min Copay Amt'
	pbp_b16b_copay_amt_poo_max       = 'Dental Comp POO Max Copay Amt'
	pbp_b16b_auth_yn                 = 'Dental Comp Enrollee Auth'
	pbp_b16b_refer_yn                = 'Dental Comp Referral YN'
	pbp_d_opt_identifier             = 'Opt Sup Benefits Identifier'
;

run;

proc sort data = pbp_step16b out=out.pbp_step16b;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_step16b(obs = 10);
  title 'pbp_step16b file ';
run;

proc means data = out.pbp_step16b;
  title 'pbp_step16b file ';
run;

proc freq data = out.pbp_step16b;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	pbp_b16b_bendesc_yn
	pbp_b16b_bendesc_amo_es
	pbp_b16b_bendesc_lim_es
	pbp_b16b_bendesc_per_es
	pbp_b16b_bendesc_amo_ds
	pbp_b16b_bendesc_lim_ds
	pbp_b16b_bendesc_per_ds
	pbp_b16b_bendesc_amo_rs
	pbp_b16b_bendesc_lim_rs
	pbp_b16b_bendesc_per_rs
	pbp_b16b_bendesc_amo_end
	pbp_b16b_bendesc_lim_end
	pbp_b16b_bendesc_per_end
	pbp_b16b_bendesc_amo_peri
	pbp_b16b_bendesc_lim_peri
	pbp_b16b_bendesc_per_peri
	pbp_b16b_bendesc_amo_ext
	pbp_b16b_bendesc_lim_ext
	pbp_b16b_bendesc_per_ext
	pbp_b16b_bendesc_amo_poo
	pbp_b16b_bendesc_lim_poo
	pbp_b16b_bendesc_per_poo
	pbp_b16b_maxplan_yn
	pbp_b16b_maxplan_in_oon
	pbp_b16b_maxbene_type
	pbp_b16b_maxplan_per
	pbp_b16b_maxenr_yn
	pbp_b16b_maxenr_type
	pbp_b16b_maxenr_per
	pbp_b16b_coins_yn
	pbp_b16b_ded_yn
	pbp_b16b_copay_yn
	pbp_b16b_auth_yn
	pbp_b16b_refer_yn
	pbp_d_opt_identifier
/ missing;
run;

proc contents data = out.pbp_step16b;
  title 'pbp_step16b data';
run;