*pbp_b4_b19b_emerg_urgent_vbid_uf.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b4_vbid;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	pbp_vbid_group_id                $2
	pbp_b4c_bendesc_yn               $1
	pbp_b4c_bendesc_ehc              $3
	pbp_b4c_bendesc_amo_wec          $1
	pbp_b4c_bendesc_amo_wuc          $1
	pbp_b4c_bendesc_amo_wet          $1
	pbp_b4c_wwc_maxplan_yn           $1
	pbp_b4c_wwc_maxplan_svcs_yn      $1
	pbp_b4c_maxenr_yn                $1
	pbp_b4c_maxenr_per               $1
	pbp_b4c_maxenr_per_d             $4000
	pbp_b4c_coins_yn                 $1
	pbp_b4c_coins_ehc                $3
	pbp_b4c_coins_wav_wec_yn         $1
	pbp_b4c_coins_wav_wuc_yn         $1
	pbp_b4c_coins_wav_wet_yn         $1
	pbp_b4c_copay_yn                 $1
	pbp_b4c_copay_ehc                $3
	pbp_b4c_copay_wav_wec_yn         $1
	pbp_b4c_copay_wav_wuc_yn         $1
	pbp_b4c_copay_wav_wet_yn         $1
	pbp_b4c_ded_yn                   $1
;

infile '.\pbp\pbp_b4_b19b_emerg_urgent_vbid_uf.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	pbp_vbid_group_id
	pbp_b4c_bendesc_yn
	pbp_b4c_bendesc_ehc
	pbp_b4c_bendesc_amo_wec
	pbp_b4c_bendesc_amo_wuc
	pbp_b4c_bendesc_amo_wet
	pbp_b4c_wwc_maxplan_yn
	pbp_b4c_wwc_maxplan_svcs_yn
	pbp_b4c_wwc_maxplan_amt
	pbp_b4c_maxenr_yn
	pbp_b4c_maxenr_amt
	pbp_b4c_maxenr_per
	pbp_b4c_maxenr_per_d
	pbp_b4c_coins_yn
	pbp_b4c_coins_ehc
	pbp_b4c_coins_pct_wec_min
	pbp_b4c_coins_pct_wec_max
	pbp_b4c_coins_wav_wec_yn
	pbp_b4c_coins_pct_wuc_min
	pbp_b4c_coins_pct_wuc_max
	pbp_b4c_coins_wav_wuc_yn
	pbp_b4c_coins_pct_wet_min
	pbp_b4c_coins_pct_wet_max
	pbp_b4c_coins_wav_wet_yn
	pbp_b4c_copay_yn
	pbp_b4c_copay_ehc
	pbp_b4c_copay_amt_wec_min
	pbp_b4c_copay_amt_wec_max
	pbp_b4c_copay_wav_wec_yn
	pbp_b4c_copay_amt_wuc_min
	pbp_b4c_copay_amt_wuc_max
	pbp_b4c_copay_wav_wuc_yn
	pbp_b4c_copay_amt_wet_min
	pbp_b4c_copay_amt_wet_max
	pbp_b4c_copay_wav_wet_yn
	pbp_b4c_ded_yn
	pbp_b4c_ded_amt
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	pbp_vbid_group_id                = 'B19 VBID Group (Package) ID'
	pbp_b4c_bendesc_yn               = 'Worldwide Cov Desc YN'
	pbp_b4c_bendesc_ehc              = 'B4c ben desc'
	pbp_b4c_bendesc_amo_wec          = 'B4c emerg cov  AMO'
	pbp_b4c_bendesc_amo_wuc          = 'B4c urgent cov  AMO'
	pbp_b4c_bendesc_amo_wet          = 'B4c emerg transport AMO'
	pbp_b4c_wwc_maxplan_yn           = 'Worldwide Cov MaxPlan YN'
	pbp_b4c_wwc_maxplan_svcs_yn      = 'MAXENR_LIMIT_YN'
	pbp_b4c_wwc_maxplan_amt          = 'Worldwide Cov MaxPlan Amt'
	pbp_b4c_maxenr_yn                = 'Emerg Care Max Enr YN'
	pbp_b4c_maxenr_amt               = 'Emerg Care Max Enr Amt'
	pbp_b4c_maxenr_per               = 'Emerg Care Max Enr Per'
	pbp_b4c_maxenr_per_d             = 'Emerg Cr Max Enr Per Desc'
	pbp_b4c_coins_yn                 = 'Emerg Care Coinsurance YN'
	pbp_b4c_coins_ehc                = 'B4c coins ehc'
	pbp_b4c_coins_pct_wec_min        = 'B4c world emerg Min Coins Pct'
	pbp_b4c_coins_pct_wec_max        = 'B4c world emerg Max Coins Pct'
	pbp_b4c_coins_wav_wec_yn         = 'B4c world emerg coins waiv'
	pbp_b4c_coins_pct_wuc_min        = 'B4c urgent cov Min Coins Pct'
	pbp_b4c_coins_pct_wuc_max        = 'B4c urgent cov Max Coins Pct'
	pbp_b4c_coins_wav_wuc_yn         = 'B4c world urgent coins waiv'
	pbp_b4c_coins_pct_wet_min        = 'B4c emerg trans Min Coins Pct'
	pbp_b4c_coins_pct_wet_max        = 'B4c emerg trans Max Coins Pct'
	pbp_b4c_coins_wav_wet_yn         = 'B4c emerg trans coins waiv'
	pbp_b4c_copay_yn                 = 'Emerg Care Copayment YN'
	pbp_b4c_copay_ehc                = 'B4c copay ehc'
	pbp_b4c_copay_amt_wec_min        = 'B4c emerg cov Min Copay Amt'
	pbp_b4c_copay_amt_wec_max        = 'B4c emerg cov Max Copay Amt'
	pbp_b4c_copay_wav_wec_yn         = 'B4c world emerg copay waiv'
	pbp_b4c_copay_amt_wuc_min        = 'B4c urgent cov Min Copay Amt'
	pbp_b4c_copay_amt_wuc_max        = 'B4c urgent cov Max Copay Amt'
	pbp_b4c_copay_wav_wuc_yn         = 'B4c world urgent copay waiv'
	pbp_b4c_copay_amt_wet_min        = 'B4c emerg trans Min Copay Amt'
	pbp_b4c_copay_amt_wet_max        = 'B4c emerg trans Max Copay Amt'
	pbp_b4c_copay_wav_wet_yn         = 'B4c emerg trans copay waiv'
	pbp_b4c_ded_yn                   = 'Emerg Care Deductible YN'
	pbp_b4c_ded_amt                  = 'Emerg Care Deductible Amt'
;

run;

proc sort data = pbp_b4_vbid out=out.pbp_b4_vbid;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_b4_vbid(obs = 10);
  title 'pbp_b4_b19b_emerg_urgent_vbid_uf file ';
run;

proc means data = out.pbp_b4_vbid;
  title 'pbp_b4_b19b_emerg_urgent_vbid_uf file ';
run;

proc freq data = out.pbp_b4_vbid;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	pbp_vbid_group_id
	pbp_b4c_bendesc_yn
	pbp_b4c_bendesc_ehc
	pbp_b4c_bendesc_amo_wec
	pbp_b4c_bendesc_amo_wuc
	pbp_b4c_bendesc_amo_wet
	pbp_b4c_wwc_maxplan_yn
	pbp_b4c_wwc_maxplan_svcs_yn
	pbp_b4c_maxenr_yn
	pbp_b4c_maxenr_per
	pbp_b4c_coins_yn
	pbp_b4c_coins_ehc
	pbp_b4c_coins_wav_wec_yn
	pbp_b4c_coins_wav_wuc_yn
	pbp_b4c_coins_wav_wet_yn
	pbp_b4c_copay_yn
	pbp_b4c_copay_ehc
	pbp_b4c_copay_wav_wec_yn
	pbp_b4c_copay_wav_wuc_yn
	pbp_b4c_copay_wav_wet_yn
	pbp_b4c_ded_yn
/ missing;
run;

proc contents data = out.pbp_b4_vbid;
  title 'pbp_b4_vbid data';
run;