*pbp_mrx_tier_vbid.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_mrx_tier_vbid;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	part_d_model_demo                $1
	part_d_enhncd_cvrg_demo          $1
	mrx_tier_group_id                $2
	mrx_tier_id                      $1
	mrx_tier_type_id                 $1
	mrx_group_tiers_icl              $7
	mrx_tier_cstshr_struct_type_vb   $1
	mrx_tier_cost_share_vb           $1
	mrx_tier_part_drugs_vb           $1
	mrx_tier_part_includes_vb        $1
	mrx_tier_locat_rstd_vb           $3
	mrx_tier_locat_rsplt_vb          $3
	mrx_tier_locat_oon_vb            $2
	mrx_tier_locat_mostd_vb          $3
	mrx_tier_locat_mosplt_vb         $3
	mrx_tier_locat_ltc_vb            $1
	mrx_group_tiers_gap              $7
;

infile '.\pbp\pbp_mrx_tier_vbid.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	part_d_model_demo
	part_d_enhncd_cvrg_demo
	mrx_tier_group_id
	mrx_tier_id
	mrx_tier_type_id
	mrx_group_tiers_icl
	mrx_tier_cstshr_struct_type_vb
	mrx_tier_cost_share_vb
	mrx_tier_part_drugs_vb
	mrx_tier_part_includes_vb
	mrx_tier_locat_rstd_vb
	mrx_tier_locat_rsplt_vb
	mrx_tier_locat_oon_vb
	mrx_tier_locat_mostd_vb
	mrx_tier_locat_mosplt_vb
	mrx_tier_locat_ltc_vb
	mrx_tier_rstd_copay_1m_min
	mrx_tier_rstd_copay_1m_max
	mrx_tier_rstd_copay_2m_min
	mrx_tier_rstd_copay_2m_max
	mrx_tier_rstd_copay_3m_min
	mrx_tier_rstd_copay_3m_max
	mrx_tier_rsstd_copay_1m_min
	mrx_tier_rsstd_copay_1m_max
	mrx_tier_rsstd_copay_2m_min
	mrx_tier_rsstd_copay_2m_max
	mrx_tier_rsstd_copay_3m_min
	mrx_tier_rsstd_copay_3m_max
	mrx_tier_rspfd_copay_1m_min
	mrx_tier_rspfd_copay_1m_max
	mrx_tier_rspfd_copay_2m_min
	mrx_tier_rspfd_copay_2m_max
	mrx_tier_rspfd_copay_3m_min
	mrx_tier_rspfd_copay_3m_max
	mrx_tier_rstd_coins_1m_min
	mrx_tier_rstd_coins_1m_max
	mrx_tier_rstd_coins_2m_min
	mrx_tier_rstd_coins_2m_max
	mrx_tier_rstd_coins_3m_min
	mrx_tier_rstd_coins_3m_max
	mrx_tier_rsstd_coins_1m_min
	mrx_tier_rsstd_coins_1m_max
	mrx_tier_rsstd_coins_2m_min
	mrx_tier_rsstd_coins_2m_max
	mrx_tier_rsstd_coins_3m_min
	mrx_tier_rsstd_coins_3m_max
	mrx_tier_rspfd_coins_1m_min
	mrx_tier_rspfd_coins_1m_max
	mrx_tier_rspfd_coins_2m_min
	mrx_tier_rspfd_coins_2m_max
	mrx_tier_rspfd_coins_3m_min
	mrx_tier_rspfd_coins_3m_max
	mrx_tier_mostd_copay_1m_min
	mrx_tier_mostd_copay_1m_max
	mrx_tier_mostd_copay_2m_min
	mrx_tier_mostd_copay_2m_max
	mrx_tier_mostd_copay_3m_min
	mrx_tier_mostd_copay_3m_max
	mrx_tier_mosstd_copay_1m_min
	mrx_tier_mosstd_copay_1m_max
	mrx_tier_mosstd_copay_2m_min
	mrx_tier_mosstd_copay_2m_max
	mrx_tier_mosstd_copay_3m_min
	mrx_tier_mosstd_copay_3m_max
	mrx_tier_mospfd_copay_1m_min
	mrx_tier_mospfd_copay_1m_max
	mrx_tier_mospfd_copay_2m_min
	mrx_tier_mospfd_copay_2m_max
	mrx_tier_mospfd_copay_3m_min
	mrx_tier_mospfd_copay_3m_max
	mrx_tier_mostd_coins_1m_min
	mrx_tier_mostd_coins_1m_max
	mrx_tier_mostd_coins_2m_min
	mrx_tier_mostd_coins_2m_max
	mrx_tier_mostd_coins_3m_min
	mrx_tier_mostd_coins_3m_max
	mrx_tier_mosstd_coins_1m_min
	mrx_tier_mosstd_coins_1m_max
	mrx_tier_mosstd_coins_2m_min
	mrx_tier_mosstd_coins_2m_max
	mrx_tier_mosstd_coins_3m_min
	mrx_tier_mosstd_coins_3m_max
	mrx_tier_mospfd_coins_1m_min
	mrx_tier_mospfd_coins_1m_max
	mrx_tier_mospfd_coins_2m_min
	mrx_tier_mospfd_coins_2m_max
	mrx_tier_mospfd_coins_3m_min
	mrx_tier_mospfd_coins_3m_max
	mrx_tier_oonp_copay_1m_min
	mrx_tier_oonp_copay_1m_max
	mrx_tier_oonp_copay_oth_min
	mrx_tier_oonp_copay_oth_max
	mrx_tier_oonp_coins_1m_min
	mrx_tier_oonp_coins_1m_max
	mrx_tier_oonp_coins_oth_min
	mrx_tier_oonp_coins_oth_max
	mrx_tier_ltcp_copay_1m_min
	mrx_tier_ltcp_copay_1m_max
	mrx_tier_ltcp_coins_1m_min
	mrx_tier_ltcp_coins_1m_max
	mrx_tier_rstd_1m_num_vb
	mrx_tier_rstd_copay_daily_vb
	mrx_tier_mostd_1m_num_vb
	mrx_tier_mostd_copay_daily_vb
	mrx_tier_rsplt_1m_num_vb
	mrx_tier_rsstd_copay_daily_vb
	mrx_tier_mosplt_1m_num_vb
	mrx_tier_mosstd_copay_daily_vb
	mrx_tier_rspfd_copay_daily_vb
	mrx_tier_mospfd_copay_daily_vb
	mrx_tier_ltcp_1m_vb
	mrx_tier_ltcp_copay_daily_vb
	mrx_group_tiers_gap
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	part_d_model_demo                = 'Part D Model Demo'
	part_d_enhncd_cvrg_demo          = 'Part D Senior Savings Model'
	mrx_tier_group_id                = 'MRX VBID Group (Package) ID'
	mrx_tier_id                      = 'MRx Tier ID'
	mrx_tier_type_id                 = 'MRx Tier Type ID'
	mrx_group_tiers_icl              = 'Rx vbid icl tiers'
	mrx_tier_cstshr_struct_type_vb   = 'MRx Cost Share Tier Struct'
	mrx_tier_cost_share_vb           = 'MRx VBID Cost Share'
	mrx_tier_part_drugs_vb           = 'VBID Part Tier Drug Types'
	mrx_tier_part_includes_vb        = 'VBID Part Tier Includes'
	mrx_tier_locat_rstd_vb           = 'Standard Retail Cost-Share Loc'
	mrx_tier_locat_rsplt_vb          = 'Standard/Pref Retail Cost Loc'
	mrx_tier_locat_oon_vb            = 'Out-of-Network Loc'
	mrx_tier_locat_mostd_vb          = 'MO Pharmacy Locations'
	mrx_tier_locat_mosplt_vb         = 'MO Pre/Non-Pref Pharmacy Locat'
	mrx_tier_locat_ltc_vb            = 'LTC Pharmacy Locations'
	mrx_tier_rstd_copay_1m_min       = 'MRx vbid rstd min Copay 1M'
	mrx_tier_rstd_copay_1m_max       = 'MRx vbid rstd max Copay 1M'
	mrx_tier_rstd_copay_2m_min       = 'MRx vbid rstd min Copay 2M'
	mrx_tier_rstd_copay_2m_max       = 'MRx vbid rstd max Copay 2M'
	mrx_tier_rstd_copay_3m_min       = 'MRx vbid rstd min Copay 3M'
	mrx_tier_rstd_copay_3m_max       = 'MRx vbid rstd max Copay 3M'
	mrx_tier_rsstd_copay_1m_min      = 'MRx vbid RSSTD min Copay 1M'
	mrx_tier_rsstd_copay_1m_max      = 'MRx vbid RSSTD max Copay 1M'
	mrx_tier_rsstd_copay_2m_min      = 'MRx vbid RSSTD min Copay 2M'
	mrx_tier_rsstd_copay_2m_max      = 'MRx vbid RSSTD max Copay 2M'
	mrx_tier_rsstd_copay_3m_min      = 'MRx vbid RSSTD min Copay 3M'
	mrx_tier_rsstd_copay_3m_max      = 'MRx vbid RSSTD max Copay 3M'
	mrx_tier_rspfd_copay_1m_min      = 'MRx vbid RSPFD min Copay 1M'
	mrx_tier_rspfd_copay_1m_max      = 'MRx vbid RSPFD max Copay 1M'
	mrx_tier_rspfd_copay_2m_min      = 'MRx vbid RSPFD min Copay 2M'
	mrx_tier_rspfd_copay_2m_max      = 'MRx vbid RSPFD max Copay 2M'
	mrx_tier_rspfd_copay_3m_min      = 'MRx vbid RSPFD min Copay 3M'
	mrx_tier_rspfd_copay_3m_max      = 'MRx vbid RSPFD max Copay 3M'
	mrx_tier_rstd_coins_1m_min       = 'MRx vbid rstd min coins 1M'
	mrx_tier_rstd_coins_1m_max       = 'MRx vbid rstd max coins 1M'
	mrx_tier_rstd_coins_2m_min       = 'MRx vbid rstd min coins 2M'
	mrx_tier_rstd_coins_2m_max       = 'MRx vbid rstd max coins 2M'
	mrx_tier_rstd_coins_3m_min       = 'MRx vbid rstd min coins 3M'
	mrx_tier_rstd_coins_3m_max       = 'MRx vbid rstd max coins 3M'
	mrx_tier_rsstd_coins_1m_min      = 'MRx vbid RSSTD min coins 1M'
	mrx_tier_rsstd_coins_1m_max      = 'MRx vbid RSSTD max coins 1M'
	mrx_tier_rsstd_coins_2m_min      = 'MRx vbid RSSTD min coins 2M'
	mrx_tier_rsstd_coins_2m_max      = 'MRx vbid RSSTD max coins 2M'
	mrx_tier_rsstd_coins_3m_min      = 'MRx vbid RSSTD min coins 3M'
	mrx_tier_rsstd_coins_3m_max      = 'MRx vbid RSSTD max coins 3M'
	mrx_tier_rspfd_coins_1m_min      = 'MRx vbid RSPFD min coins 1M'
	mrx_tier_rspfd_coins_1m_max      = 'MRx vbid RSPFD max coins 1M'
	mrx_tier_rspfd_coins_2m_min      = 'MRx vbid RSPFD min coins 2M'
	mrx_tier_rspfd_coins_2m_max      = 'MRx vbid RSPFD max coins 2M'
	mrx_tier_rspfd_coins_3m_min      = 'MRx vbid RSPFD min coins 3M'
	mrx_tier_rspfd_coins_3m_max      = 'MRx vbid RSPFD max coins 3M'
	mrx_tier_mostd_copay_1m_min      = 'MRx vbid MOSTD min Copay 1M'
	mrx_tier_mostd_copay_1m_max      = 'MRx vbid MOSTD max Copay 1M'
	mrx_tier_mostd_copay_2m_min      = 'MRx vbid MOSTD min Copay 2M'
	mrx_tier_mostd_copay_2m_max      = 'MRx vbid MOSTD max Copay 2M'
	mrx_tier_mostd_copay_3m_min      = 'MRx vbid MOSTD min Copay 3M'
	mrx_tier_mostd_copay_3m_max      = 'MRx vbid MOSTD max Copay 3M'
	mrx_tier_mosstd_copay_1m_min     = 'MRx vbid MOSPLT min Copay 1M'
	mrx_tier_mosstd_copay_1m_max     = 'MRx vbid MOSPLT max Copay 1M'
	mrx_tier_mosstd_copay_2m_min     = 'MRx vbid MOSPLT min Copay 2M'
	mrx_tier_mosstd_copay_2m_max     = 'MRx vbid MOSPLT max Copay 2M'
	mrx_tier_mosstd_copay_3m_min     = 'MRx vbid MOSPLT min Copay 3M'
	mrx_tier_mosstd_copay_3m_max     = 'MRx vbid MOSPLT max Copay 3M'
	mrx_tier_mospfd_copay_1m_min     = 'MRx vbid MOSPFD min Copay 1M'
	mrx_tier_mospfd_copay_1m_max     = 'MRx vbid MOSPFD max Copay 1M'
	mrx_tier_mospfd_copay_2m_min     = 'MRx vbid MOSPFD min Copay 2M'
	mrx_tier_mospfd_copay_2m_max     = 'MRx vbid MOSPFD max Copay 2M'
	mrx_tier_mospfd_copay_3m_min     = 'MRx vbid MOSPFD min Copay 3M'
	mrx_tier_mospfd_copay_3m_max     = 'MRx vbid MOSPFD max Copay 3M'
	mrx_tier_mostd_coins_1m_min      = 'MRx vbid MOSTD min coins 1M'
	mrx_tier_mostd_coins_1m_max      = 'MRx vbid MOSTD max coins 1M'
	mrx_tier_mostd_coins_2m_min      = 'MRx vbid MOSTD min coins 2M'
	mrx_tier_mostd_coins_2m_max      = 'MRx vbid MOSTD max coins 2M'
	mrx_tier_mostd_coins_3m_min      = 'MRx vbid MOSTD min coins 3M'
	mrx_tier_mostd_coins_3m_max      = 'MRx vbid MOSTD max coins 3M'
	mrx_tier_mosstd_coins_1m_min     = 'MRx vbid MOSPLT min coins 1M'
	mrx_tier_mosstd_coins_1m_max     = 'MRx vbid MOSPLT max coins 1M'
	mrx_tier_mosstd_coins_2m_min     = 'MRx vbid MOSPLT min coins 2M'
	mrx_tier_mosstd_coins_2m_max     = 'MRx vbid MOSPLT max coins 2M'
	mrx_tier_mosstd_coins_3m_min     = 'MRx vbid MOSPLT min coins 3M'
	mrx_tier_mosstd_coins_3m_max     = 'MRx vbid MOSPLT max coins 3M'
	mrx_tier_mospfd_coins_1m_min     = 'MRx vbid MOSPFD min coins 1M'
	mrx_tier_mospfd_coins_1m_max     = 'MRx vbid MOSPFD max coins 1M'
	mrx_tier_mospfd_coins_2m_min     = 'MRx vbid MOSPFD min coins 2M'
	mrx_tier_mospfd_coins_2m_max     = 'MRx vbid MOSPFD max coins 2M'
	mrx_tier_mospfd_coins_3m_min     = 'MRx vbid MOSPFD min coins 3M'
	mrx_tier_mospfd_coins_3m_max     = 'MRx vbid MOSPFD max coins 3M'
	mrx_tier_oonp_copay_1m_min       = 'MRx vbid OONP min Copay 1M'
	mrx_tier_oonp_copay_1m_max       = 'MRx vbid OONP max Copay 1M'
	mrx_tier_oonp_copay_oth_min      = 'MRx vbid OONP min Copay oth'
	mrx_tier_oonp_copay_oth_max      = 'MRx vbid OONP max Copay oth'
	mrx_tier_oonp_coins_1m_min       = 'MRx vbid OONP min coins 1M'
	mrx_tier_oonp_coins_1m_max       = 'MRx vbid OONP max coins 1M'
	mrx_tier_oonp_coins_oth_min      = 'MRx vbid OONP min coins oth'
	mrx_tier_oonp_coins_oth_max      = 'MRx vbid OONP max coins oth'
	mrx_tier_ltcp_copay_1m_min       = 'MRx vbid LTCP min Copay 1M'
	mrx_tier_ltcp_copay_1m_max       = 'MRx vbid LTCP max Copay 1M'
	mrx_tier_ltcp_coins_1m_min       = 'MRx vbid LTCP min coins 1M'
	mrx_tier_ltcp_coins_1m_max       = 'MRx vbid LTCP max coins 1M'
	mrx_tier_rstd_1m_num_vb          = 'MRx Tier INP 1M Supply Days'
	mrx_tier_rstd_copay_daily_vb     = 'INP Daily Copay'
	mrx_tier_mostd_1m_num_vb         = 'MRx Tier MO 1M Supply Days'
	mrx_tier_mostd_copay_daily_vb    = 'MO Daily Copay'
	mrx_tier_rsplt_1m_num_vb         = 'MRx Tier INPP 1M Supply Days'
	mrx_tier_rsstd_copay_daily_vb    = 'INNPP Daily Copay'
	mrx_tier_mosplt_1m_num_vb        = 'MRx Tier MOPP 1M Supply Days'
	mrx_tier_mosstd_copay_daily_vb   = 'MONPP Daily Copay'
	mrx_tier_rspfd_copay_daily_vb    = 'INPP Daily Copay'
	mrx_tier_mospfd_copay_daily_vb   = 'MOPP Daily Copay'
	mrx_tier_ltcp_1m_vb              = 'LTC Tier 1M Num Days'
	mrx_tier_ltcp_copay_daily_vb     = 'LTCP Brand Daily Copay'
	mrx_group_tiers_gap              = 'Rx vbid icl tiers'
;

run;

proc sort data = pbp_mrx_tier_vbid out=out.pbp_mrx_tier_vbid;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_mrx_tier_vbid(obs = 10);
  title 'pbp_mrx_tier_vbid file ';
run;

proc means data = out.pbp_mrx_tier_vbid;
  title 'pbp_mrx_tier_vbid file ';
run;

proc freq data = out.pbp_mrx_tier_vbid;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	part_d_model_demo
	part_d_enhncd_cvrg_demo
	mrx_tier_group_id
	mrx_tier_id
	mrx_tier_type_id
	mrx_tier_cstshr_struct_type_vb
	mrx_tier_cost_share_vb
	mrx_tier_part_drugs_vb
	mrx_tier_part_includes_vb
	mrx_tier_locat_rstd_vb
	mrx_tier_locat_rsplt_vb
	mrx_tier_locat_oon_vb
	mrx_tier_locat_mostd_vb
	mrx_tier_locat_mosplt_vb
	mrx_tier_locat_ltc_vb
/ missing;
run;

proc contents data = out.pbp_mrx_tier_vbid;
  title 'pbp_mrx_tier_vbid data';
run;