*pbp_step9.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_step9;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	pbp_d_opt_cost_share_mand_yn     $1
	pbp_b9d_bendesc_yn               $1
	pbp_b9d_bendec                   $1
	pbp_b9d_bendesc_amo              $1
	pbp_b9d_maxenr_yn                $1
	pbp_b9d_maxenr_per               $1
	pbp_b9d_maxenr_per_d             $4000
	pbp_b9d_coins_yn                 $1
	pbp_b9d_ded_yn                   $1
	pbp_b9d_copay_yn                 $1
	pbp_b9d_auth_yn                  $1
	pbp_b9d_refer_yn                 $1
	pbp_d_opt_identifier             $3
;

infile '.\pbp\pbp_step9.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	pbp_d_opt_cost_share_mand_yn
	pbp_b9d_bendesc_yn
	pbp_b9d_bendec
	pbp_b9d_bendesc_amo
	pbp_b9d_maxenr_yn
	pbp_b9d_maxenr_amt
	pbp_b9d_maxenr_per
	pbp_b9d_maxenr_per_d
	pbp_b9d_coins_yn
	pbp_b9d_coins_pct_mc_min
	pbp_b9d_coins_pct_mc_max
	pbp_b9d_ded_yn
	pbp_b9d_ded_amt
	pbp_b9d_copay_yn
	pbp_b9d_copay_mc_amt_min
	pbp_b9d_copay_mc_amt_max
	pbp_b9d_auth_yn
	pbp_b9d_refer_yn
	pbp_d_opt_identifier
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	pbp_d_opt_cost_share_mand_yn     = 'OppSupp Cost Same INN YN'
	pbp_b9d_bendesc_yn               = 'Outpnt Blood Ben Desc YN'
	pbp_b9d_bendec                   = 'Outpnt Blood Ben Desc Enhance'
	pbp_b9d_bendesc_amo              = 'Outpnt Blood Ben Desc MO'
	pbp_b9d_maxenr_yn                = 'Outpnt Blood Max Enr YN'
	pbp_b9d_maxenr_amt               = 'Outpnt Blood Max Enr Amt'
	pbp_b9d_maxenr_per               = 'Outpnt Blood Max Enr Per'
	pbp_b9d_maxenr_per_d             = 'Outpt Bld Max Enr Per Desc'
	pbp_b9d_coins_yn                 = 'Outpnt Blood Coinsurance YN'
	pbp_b9d_coins_pct_mc_min         = 'Outpnt Blood MC Coins Min Pct'
	pbp_b9d_coins_pct_mc_max         = 'Outpnt Blood MC Coins Max Pct'
	pbp_b9d_ded_yn                   = 'Outpnt Blood Deductible YN'
	pbp_b9d_ded_amt                  = 'Outpnt Blood Deductible Amt'
	pbp_b9d_copay_yn                 = 'Outpnt Blood Copayment YN'
	pbp_b9d_copay_mc_amt_min         = 'Outpnt Blood MC Copay Min Amt'
	pbp_b9d_copay_mc_amt_max         = 'Outpnt Blood MC Copay Max Amt'
	pbp_b9d_auth_yn                  = 'Outpnt Blood Enrollee Auth'
	pbp_b9d_refer_yn                 = 'Outpnt Blood Referral YN'
	pbp_d_opt_identifier             = 'Opt Sup Benefits Identifier'
;

run;

proc sort data = pbp_step9 out=out.pbp_step9;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_step9(obs = 10);
  title 'pbp_step9 file ';
run;

proc means data = out.pbp_step9;
  title 'pbp_step9 file ';
run;

proc freq data = out.pbp_step9;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	pbp_d_opt_cost_share_mand_yn
	pbp_b9d_bendesc_yn
	pbp_b9d_bendec
	pbp_b9d_bendesc_amo
	pbp_b9d_maxenr_yn
	pbp_b9d_maxenr_per
	pbp_b9d_coins_yn
	pbp_b9d_ded_yn
	pbp_b9d_copay_yn
	pbp_b9d_auth_yn
	pbp_b9d_refer_yn
	pbp_d_opt_identifier
/ missing;
run;

proc contents data = out.pbp_step9;
  title 'pbp_step9 data';
run;