*pbp_mrx_dmodel.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_mrx_dmodel;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	part_d_model_demo                $1
	part_d_enhncd_cvrg_demo          $1
	mrx_d_pmm_yn                     $1
	mrx_d_pmm_flex_chk               $7
	mrx_d_pmm_other_desc             $4000
	mrx_d_red_cs_lisb_detail         $1
	mrx_d_ri_type_chk                $4
	mrx_d_ri_type_other              $4000
	mrx_d_ri_elig_rdo                $1
	mrx_d_elig_freq_other            $4000
	mrx_d_eligcrit_chk               $3
	mrx_d_eligcrit_other             $4000
	mrx_d_adher_goal                 $1
	mrx_d_adher_goal_desc            $4000
;

infile '.\pbp\pbp_mrx_dmodel.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	part_d_model_demo
	part_d_enhncd_cvrg_demo
	mrx_d_pmm_yn
	mrx_d_pmm_flex_chk
	mrx_d_pmm_other_desc
	mrx_d_red_cs_lisb_detail
	mrx_d_ri_type_chk
	mrx_d_ri_type_other
	mrx_d_ri_amt
	mrx_d_ri_elig_rdo
	mrx_d_elig_freq_other
	mrx_d_ri_max_amt
	mrx_d_eligcrit_chk
	mrx_d_eligcrit_other
	mrx_d_adher_goal
	mrx_d_adher_goal_desc
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	part_d_model_demo                = 'Part D Model Demo'
	part_d_enhncd_cvrg_demo          = 'Part D Senior Savings Model'
	mrx_d_pmm_yn                     = 'Part D model offered'
	mrx_d_pmm_flex_chk               = 'D model Flexibility Type'
	mrx_d_pmm_other_desc             = 'Part D Model type desc'
	mrx_d_red_cs_lisb_detail         = 'D model LIS Cst Shr Type'
	mrx_d_ri_type_chk                = 'D model RAI Type'
	mrx_d_ri_type_other              = 'D model RAI Other Type'
	mrx_d_ri_amt                     = 'D model RAE Amount'
	mrx_d_ri_elig_rdo                = 'D model RAI Frequency'
	mrx_d_elig_freq_other            = 'D model RAI Freq Other'
	mrx_d_ri_max_amt                 = 'D model RAI Max Amount'
	mrx_d_eligcrit_chk               = 'D model Elig Type'
	mrx_d_eligcrit_other             = 'D model Elig Other'
	mrx_d_adher_goal                 = 'D model Meets Goal'
	mrx_d_adher_goal_desc            = 'D model Goal Desc'
;

run;

proc sort data = pbp_mrx_dmodel out=out.pbp_mrx_dmodel;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_mrx_dmodel(obs = 10);
  title 'pbp_mrx_dmodel file ';
run;

proc means data = out.pbp_mrx_dmodel;
  title 'pbp_mrx_dmodel file ';
run;

proc freq data = out.pbp_mrx_dmodel;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	part_d_model_demo
	part_d_enhncd_cvrg_demo
	mrx_d_pmm_yn
	mrx_d_red_cs_lisb_detail
	mrx_d_ri_type_chk
	mrx_d_ri_elig_rdo
	mrx_d_eligcrit_chk
	mrx_d_adher_goal
/ missing;
run;

proc contents data = out.pbp_mrx_dmodel;
  title 'pbp_mrx_dmodel data';
run;