*pbp_b19_model_test.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b19;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	pbp_b19a_uf_yn                   $1
	pbp_b19a_ssbci_yn                $1
	pbp_b19a_ssbci_bendesc           $2
	pbp_b19a_vbd_hospice_ben_yn      $1
	pbp_b19a_vbd_yn                  $1
	pbp_b19a_attestation             $1
	pbp_b19a_reduct_cost_yn          $1
	pbp_b19b_add_cost_yn             $1
	pbp_b19c_conins_enrol_yn         $1
	pbp_b19c_copay_enrol_yn          $1
	pbp_b19c_conins_resp_enrol_yn    $1
	pbp_b19c_conins_enrol2_yn        $1
	pbp_b19c_copay_enrol2_yn         $1
	pbp_b19c_conins_resp_enrol2_yn   $1
	pbp_b19c_mand_supp_ben_yn        $1
	pbp_b19c_max_plan_ben_yn         $1
	pbp_b19c_hosp_supp_ben_cont_yn   $1
	pbp_b19c_cov_hlth_rltd_yn        $1
	pbp_b19c_cov_hlth_rltd           $6
	pbp_b19c_tmp_cov_res_fac_yn      $1
	pbp_b19c_red_cost_shar_yn        $1
	pbp_b19c_oth_man_supp_ben_yn     $1
	pbp_b19c_oth_man_supp_ben        $4000
;

infile '.\pbp\pbp_b19_model_test.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	pbp_b19a_uf_yn
	pbp_b19a_ssbci_yn
	pbp_b19a_ssbci_bendesc
	pbp_b19a_vbd_hospice_ben_yn
	pbp_b19a_vbd_yn
	pbp_b19a_attestation
	pbp_b19a_reduct_cost_yn
	pbp_b19a_reduct_package_num
	pbp_b19b_add_cost_yn
	pbp_b19b_add_package_num
	pbp_b19c_conins_enrol_yn
	pbp_b19c_coins_pct_minov
	pbp_b19c_coins_pct_maxov
	pbp_b19c_pres_drug_max
	pbp_b19c_copay_enrol_yn
	pbp_b19c_copay_amt_minov
	pbp_b19c_copay_amt_maxov
	pbp_b19c_conins_resp_enrol_yn
	pbp_b19c_coins_pct_resp_min
	pbp_b19c_coins_pct_resp_max
	pbp_b19c_resp_care_max
	pbp_b19c_conins_enrol2_yn
	pbp_b19c_coins_pct2_minov
	pbp_b19c_coins_pct2_maxov
	pbp_b19c_pres_drug2_max
	pbp_b19c_copay_enrol2_yn
	pbp_b19c_copay_amt2_minov
	pbp_b19c_copay_amt2_maxov
	pbp_b19c_conins_resp_enrol2_yn
	pbp_b19c_coins_pct_resp2_min
	pbp_b19c_coins_pct_resp2_max
	pbp_b19c_resp_care2_max
	pbp_b19c_mand_supp_ben_yn
	pbp_b19c_max_plan_ben_yn
	pbp_b19c_max_plan_ben_amt
	pbp_b19c_hosp_supp_ben_cont_yn
	pbp_b19c_cov_hlth_rltd_yn
	pbp_b19c_cov_hlth_rltd
	pbp_b19c_tmp_cov_res_fac_yn
	pbp_b19c_red_cost_shar_yn
	pbp_b19c_oth_man_supp_ben_yn
	pbp_b19c_oth_man_supp_ben
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	pbp_b19a_uf_yn                   = 'B19 Uniform flex YN'
	pbp_b19a_ssbci_yn                = 'B19 SSBCI yn'
	pbp_b19a_ssbci_bendesc           = 'B19 SSBCI type'
	pbp_b19a_vbd_hospice_ben_yn      = 'B19 offer VBID Hospice Bnft'
	pbp_b19a_vbd_yn                  = 'B19 VBID Reduced or Add Ben YN'
	pbp_b19a_attestation             = 'B19 VBID  Attestation'
	pbp_b19a_reduct_cost_yn          = 'B19 Reduced Cost Sharing YN'
	pbp_b19a_reduct_package_num      = 'B19 Reduction Benefit Packages'
	pbp_b19b_add_cost_yn             = '19B Add Benefits YN'
	pbp_b19b_add_package_num         = '19B Add Benefit Packages'
	pbp_b19c_conins_enrol_yn         = 'Hospice INN Drugs Coins'
	pbp_b19c_coins_pct_minov         = 'Hospice INN Drugs Coins Min'
	pbp_b19c_coins_pct_maxov         = 'Hospice INN Drugs Coins Max'
	pbp_b19c_pres_drug_max           = 'Hospice INN Max Drug Amt'
	pbp_b19c_copay_enrol_yn          = 'Hospice INN Drugs Copay'
	pbp_b19c_copay_amt_minov         = 'Hospice INN Drugs Copay Min'
	pbp_b19c_copay_amt_maxov         = 'Hospice INN Drugs Copay Max'
	pbp_b19c_conins_resp_enrol_yn    = 'Hospice INN Respite Coins YN'
	pbp_b19c_coins_pct_resp_min      = 'Hospice INN Respite Coins Min'
	pbp_b19c_coins_pct_resp_max      = 'Hospice INN Respite Coins Max'
	pbp_b19c_resp_care_max           = 'Hospice INN Max Day Amt'
	pbp_b19c_conins_enrol2_yn        = 'Hospice OON Drugs Coins'
	pbp_b19c_coins_pct2_minov        = 'Hospice OON Drugs Coins Min'
	pbp_b19c_coins_pct2_maxov        = 'Hospice OON Drugs Coins Max'
	pbp_b19c_pres_drug2_max          = 'Hospice OON Max Drug Amt'
	pbp_b19c_copay_enrol2_yn         = 'Hospice OON Drugs Copay YN'
	pbp_b19c_copay_amt2_minov        = 'Hospice OON Drugs Copay Min'
	pbp_b19c_copay_amt2_maxov        = 'Hospice OON Drugs Copay Max'
	pbp_b19c_conins_resp_enrol2_yn   = 'Hospice OON Respite Coins YN'
	pbp_b19c_coins_pct_resp2_min     = 'Hospice OON Respite Coins Min'
	pbp_b19c_coins_pct_resp2_max     = 'Hospice OON Respite Copay Max'
	pbp_b19c_resp_care2_max          = 'Hospice OON Max Day Amt'
	pbp_b19c_mand_supp_ben_yn        = 'Hospice Supp Ben YN'
	pbp_b19c_max_plan_ben_yn         = 'Hospice Max Amt YN'
	pbp_b19c_max_plan_ben_amt        = 'Hospice Supp Max Ben Amount'
	pbp_b19c_hosp_supp_ben_cont_yn   = 'Hospice Supp IIN Contingent YN'
	pbp_b19c_cov_hlth_rltd_yn        = 'Hospice Supp Reduce Impact'
	pbp_b19c_cov_hlth_rltd           = 'Hospice Supp Impact Items'
	pbp_b19c_tmp_cov_res_fac_yn      = 'Hospice Supp Temp Coverage YN'
	pbp_b19c_red_cost_shar_yn        = 'Hospice Supp Reduced Cost'
	pbp_b19c_oth_man_supp_ben_yn     = 'Hospice Supp Othr Mand Supp YN'
	pbp_b19c_oth_man_supp_ben        = 'Hospice Supp Other Supp Note'
;

run;

proc sort data = pbp_b19 out=out.pbp_b19;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_b19(obs = 10);
  title 'pbp_b19_model_test file ';
run;

proc means data = out.pbp_b19;
  title 'pbp_b19_model_test file ';
run;

proc freq data = out.pbp_b19;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	pbp_b19a_uf_yn
	pbp_b19a_ssbci_yn
	pbp_b19a_ssbci_bendesc
	pbp_b19a_vbd_hospice_ben_yn
	pbp_b19a_vbd_yn
	pbp_b19a_attestation
	pbp_b19a_reduct_cost_yn
	pbp_b19b_add_cost_yn
	pbp_b19c_conins_enrol_yn
	pbp_b19c_copay_enrol_yn
	pbp_b19c_conins_resp_enrol_yn
	pbp_b19c_conins_enrol2_yn
	pbp_b19c_copay_enrol2_yn
	pbp_b19c_conins_resp_enrol2_yn
	pbp_b19c_mand_supp_ben_yn
	pbp_b19c_max_plan_ben_yn
	pbp_b19c_hosp_supp_ben_cont_yn
	pbp_b19c_cov_hlth_rltd_yn
	pbp_b19c_tmp_cov_res_fac_yn
	pbp_b19c_red_cost_shar_yn
	pbp_b19c_oth_man_supp_ben_yn
/ missing;
run;

proc contents data = out.pbp_b19;
  title 'pbp_b19 data';
run;